/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import com.google.common.collect.ImmutableList;
import forge.game.GameView;
import forge.game.player.PlayerView;
import forge.gamemodes.match.NextGameDecision;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestDraftUtils;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.home.quest.CSubmenuQuestDraft;
import forge.screens.home.quest.VSubmenuQuestDraft;
import forge.screens.match.CMatchUI;
import forge.screens.match.ControlWinLose;
import forge.screens.match.ViewWinLose;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import java.awt.event.ActionListener;
import java.util.Iterator;

public class QuestDraftWinLose
extends ControlWinLose {
    private final transient ViewWinLose view;

    public QuestDraftWinLose(ViewWinLose view0, GameView game0, CMatchUI matchUI) {
        super(view0, game0, matchUI);
        this.view = view0;
    }

    @Override
    public final boolean populateCustomPanel() {
        String warningCaption;
        String warningString;
        String quitString;
        QuestController quest = FModel.getQuest();
        boolean gameHadHumanPlayer = this.matchUI.hasLocalPlayers();
        if (this.lastGame.isMatchOver()) {
            String winner = this.lastGame.getWinningPlayerName();
            quest.getAchievements().getCurrentDraft().setWinner(winner);
            quest.save();
            VSubmenuQuestDraft.SINGLETON_INSTANCE.populate();
        }
        if (!gameHadHumanPlayer) {
            QuestDraftUtils.matchInProgress = false;
            QuestDraftUtils.update(this.matchUI);
            return false;
        }
        this.view.getBtnRestart().setEnabled(false);
        this.view.getBtnRestart().setVisible(false);
        boolean isMatchOver = this.lastGame.isMatchOver();
        if (isMatchOver) {
            quitString = "Continue Tournament";
            warningString = null;
            warningCaption = null;
        } else {
            quitString = "Forfeit Tournament";
            warningString = "Quitting the match now will forfeit the tournament!\n\nReally quit?";
            warningCaption = "Really Quit Tournament?";
        }
        this.view.getBtnQuit().setEnabled(true);
        this.view.getBtnContinue().setEnabled(!isMatchOver);
        this.view.getBtnQuit().setText(quitString);
        for (ActionListener listener : this.view.getBtnQuit().getActionListeners()) {
            this.view.getBtnQuit().removeActionListener(listener);
        }
        this.view.getBtnQuit().addActionListener(e -> {
            if (warningString == null || FOptionPane.showOptionDialog(warningString, warningCaption, FSkin.getImage(FSkinProp.ICO_WARNING).scale(2.0), ImmutableList.of("Yes", "No"), 1) == 0) {
                if (warningString != null) {
                    PlayerView humanPlayer = null;
                    Iterator<PlayerView> iterator = this.matchUI.getLocalPlayers().iterator();
                    while (iterator.hasNext()) {
                        PlayerView playerView;
                        humanPlayer = playerView = iterator.next();
                    }
                    for (PlayerView playerView : this.lastGame.getPlayers()) {
                        if (humanPlayer == null) {
                            throw new IllegalStateException("Forfeit tournament button was pressed in a match without human players.");
                        }
                        if (playerView == humanPlayer) continue;
                        quest.getAchievements().getCurrentDraft().setWinner(playerView.getName());
                        quest.save();
                        CSubmenuQuestDraft.SINGLETON_INSTANCE.update();
                        VSubmenuQuestDraft.SINGLETON_INSTANCE.populate();
                    }
                    QuestDraftUtils.cancelFurtherMatches();
                } else {
                    this.matchUI.getGameController().nextGameDecision(NextGameDecision.QUIT);
                    QuestDraftUtils.matchInProgress = false;
                    QuestDraftUtils.continueMatches(this.matchUI);
                }
            }
        });
        CSubmenuQuestDraft.SINGLETON_INSTANCE.update();
        VSubmenuQuestDraft.SINGLETON_INSTANCE.populate();
        return false;
    }
}

