/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.game.GameView;
import forge.gamemodes.limited.LimitedWinLoseController;
import forge.screens.match.CMatchUI;
import forge.screens.match.ControlWinLose;
import forge.screens.match.ViewWinLose;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.Dimension;

public class LimitedWinLose
extends ControlWinLose {
    private final LimitedWinLoseController controller;
    private static final FSkin.SkinColor FORE_COLOR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private static final String CONSTRAINTS_TITLE = "w 95%!, gap 0 0 20px 10px";
    private static final String CONSTRAINTS_TEXT = "w 95%!,, h 180px!, gap 0 0 0 20px";

    public LimitedWinLose(ViewWinLose view0, GameView game0, CMatchUI matchUI) {
        super(view0, game0, matchUI);
        this.controller = new LimitedWinLoseController(view0, game0){

            @Override
            protected void showOutcome(Runnable runnable) {
                runnable.run();
            }

            @Override
            protected void showMessage(String message, String title) {
                TitleLabel lblTemp1 = new TitleLabel(title);
                FSkin.SkinnedLabel lblTemp2 = new FSkin.SkinnedLabel(message);
                lblTemp2.setHorizontalAlignment(0);
                lblTemp2.setFont(FSkin.getRelativeFont(17));
                lblTemp2.setForeground(FORE_COLOR);
                lblTemp2.setIconTextGap(50);
                LimitedWinLose.this.getView().getPnlCustom().add((Component)lblTemp1, LimitedWinLose.CONSTRAINTS_TITLE);
                LimitedWinLose.this.getView().getPnlCustom().add((Component)lblTemp2, LimitedWinLose.CONSTRAINTS_TEXT);
            }

            @Override
            protected void saveOptions() {
                LimitedWinLose.this.saveOptions();
            }
        };
    }

    @Override
    public final boolean populateCustomPanel() {
        this.controller.showOutcome();
        return true;
    }

    @Override
    public final void actionOnRestart() {
        this.controller.actionOnRestart();
        super.actionOnRestart();
    }

    @Override
    public final void actionOnQuit() {
        this.controller.actionOnQuit();
        super.actionOnQuit();
    }

    @Override
    public final void actionOnContinue() {
        if (!this.controller.actionOnContinue()) {
            super.actionOnContinue();
        }
    }

    private class TitleLabel
    extends FSkin.SkinnedLabel {
        TitleLabel(String msg) {
            super(msg);
            this.setFont(FSkin.getRelativeFont(18));
            this.setPreferredSize(new Dimension(200, 40));
            this.setHorizontalAlignment(0);
            this.setForeground(FORE_COLOR);
            this.setBorder(new FSkin.MatteSkinBorder(1, 0, 1, 0, FORE_COLOR));
        }
    }
}

