/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.game.GameView;
import forge.gamemodes.gauntlet.GauntletWinLoseController;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.CMatchUI;
import forge.screens.match.ControlWinLose;
import forge.screens.match.ViewWinLose;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class GauntletWinLose
extends ControlWinLose {
    private final GauntletWinLoseController controller;

    public GauntletWinLose(final ViewWinLose view0, GameView game0, CMatchUI matchUI) {
        super(view0, game0, matchUI);
        this.controller = new GauntletWinLoseController(view0, game0){

            @Override
            protected void showOutcome(boolean isMatchOver, String message1, String message2, FSkinProp icon, List<String> lstEventNames, List<String> lstEventRecords, int len, int num) {
                FLabel lblTitle = new FLabel.Builder().text(Localizer.getInstance().getMessage("lblGauntletProgress", new Object[0])).fontAlign(0).fontSize(18).build();
                JPanel pnlResults = new JPanel();
                pnlResults.setOpaque(false);
                pnlResults.setLayout(new MigLayout("insets 0, gap 0, wrap " + (int)Math.ceil((double)len / 2.0) + ", flowy"));
                if (!lstEventNames.isEmpty()) {
                    for (int i = 0; i < len; ++i) {
                        FLabel lblTemp = new FLabel.Builder().fontSize(14).build();
                        if (i <= num) {
                            ((JComponent)lblTemp).setForeground(Color.green.darker());
                            lblTemp.setText(i + 1 + ". " + lstEventNames.get(i) + " (" + lstEventRecords.get(i) + ")");
                        } else {
                            ((JComponent)lblTemp).setForeground(Color.red);
                            lblTemp.setText(i + 1 + ". ??????");
                        }
                        pnlResults.add((Component)lblTemp, "w 50%!, h 25px!, gap 0 0 5px 0");
                    }
                }
                FSkin.SkinnedPanel pnl = view0.getPnlCustom();
                pnl.setLayout(new MigLayout("insets 0, gap 0, wrap, ax center"));
                pnl.setOpaque(true);
                pnl.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
                pnl.add((Component)lblTitle, "gap 0 0 20px 10px, ax center");
                pnl.add((Component)pnlResults, "w 96%!, growy, pushy, gap 2% 0 0 0");
                if (message1 != null) {
                    pnl.add((Component)new FLabel.Builder().icon(FSkin.getIcon(icon)).build(), "w 120px!, h 120px!, ax center");
                    pnl.add((Component)new FLabel.Builder().fontSize(24).text(message1).build(), "w 96%!, h 40px!, gap 2% 0 0 0");
                    pnl.add((Component)new FLabel.Builder().fontSize(18).text(message2).build(), "w 96%!, h 40px!, gap 2% 0 0 50px");
                }
            }

            @Override
            protected void saveOptions() {
                GauntletWinLose.this.saveOptions();
            }
        };
    }

    @Override
    public final boolean populateCustomPanel() {
        this.controller.showOutcome();
        return true;
    }

    @Override
    public void actionOnContinue() {
        if (!this.controller.actionOnContinue()) {
            super.actionOnContinue();
        }
    }

    @Override
    public void actionOnQuit() {
        super.actionOnQuit();
        this.controller.actionOnQuit();
    }
}

