/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.gui.MouseUtil;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LayerUI;
import net.miginfocom.swing.MigLayout;

public class GameLogPanel
extends JPanel {
    private FScrollPane scrollPane;
    private MyScrollablePanel scrollablePanel;
    private FSkin.SkinFont textFont = FSkin.getFont();
    private final LayerUI<FScrollPane> layerUI = new GameLogPanelLayerUI();
    private JLayer<FScrollPane> layer;
    private boolean isScrollBarVisible = false;

    public GameLogPanel() {
        this.setMyLayout();
        this.createScrollablePanel();
        this.addNewScrollPane();
        this.setResizeListener();
    }

    public void reset() {
        this.scrollablePanel.removeAll();
        this.scrollablePanel.validate();
    }

    protected void setVerticalScrollbarVisibility() {
        if (this.isScrollBarVisible) {
            this.scrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        this.forceVerticalScrollbarToMax();
    }

    private void setMyLayout() {
        this.setLayout(new MigLayout("insets 0"));
        this.setOpaque(false);
    }

    private void setResizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                GameLogPanel.this.forceVerticalScrollbarToMax();
            }
        });
    }

    private void addNewScrollPane() {
        this.scrollPane = new FScrollPane(false);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getViewport().add(this.scrollablePanel);
        this.layer = new JLayer<FScrollPane>(this.scrollPane, this.layerUI);
        this.add(this.layer, "w 10:100%, h 100%");
    }

    private void createScrollablePanel() {
        this.scrollablePanel = new MyScrollablePanel();
        this.scrollablePanel.setLayout(new MigLayout("insets 0, gap 0, flowy"));
    }

    private void forceVerticalScrollbarToMax() {
        this.scrollPane.validate();
        SwingUtilities.invokeLater(() -> {
            JScrollBar scrollbar = this.scrollPane.getVerticalScrollBar();
            scrollbar.setValue(scrollbar.getMaximum());
            this.scrollPane.validate();
            scrollbar.setValue(scrollbar.getMaximum());
        });
    }

    public void addLogEntry(String text) {
        boolean useAlternateBackColor = this.scrollablePanel.getComponents().length % 2 == 0;
        JTextArea tar = this.createNewLogEntryJTextArea(text, useAlternateBackColor);
        String importantWidthConstraint = "w 10:100%";
        this.scrollablePanel.add((Component)tar, "w 10:100%");
        if (this.isScrollBarVisible) {
            this.isScrollBarVisible = false;
            this.setVerticalScrollbarVisibility();
        }
        this.forceVerticalScrollbarToMax();
    }

    public void setTextFont(FSkin.SkinFont newFont) {
        this.textFont = newFont;
    }

    private JTextArea createNewLogEntryJTextArea(String text, boolean useAlternateBackColor) {
        FSkin.SkinnedTextArea tar = new FSkin.SkinnedTextArea(text);
        tar.setFont(this.textFont);
        tar.setBorder(new EmptyBorder(3, 4, 3, 4));
        tar.setFocusable(false);
        tar.setEditable(false);
        tar.setLineWrap(true);
        tar.setWrapStyleWord(true);
        tar.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        FSkin.SkinColor skinColor = FSkin.getColor(FSkin.Colors.CLR_ZEBRA);
        if (useAlternateBackColor) {
            skinColor = skinColor.darker();
        }
        tar.setOpaque(true);
        tar.setBackground(skinColor);
        return tar;
    }

    protected final class GameLogPanelLayerUI
    extends LayerUI<FScrollPane> {
        protected GameLogPanelLayerUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            JLayer l = (JLayer)c;
            l.setLayerEventMask(16L);
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            JLayer l = (JLayer)c;
            l.setLayerEventMask(0L);
        }

        @Override
        protected void processMouseEvent(MouseEvent e, JLayer<? extends FScrollPane> l) {
            boolean isScrollBarRequired = GameLogPanel.this.scrollPane.getVerticalScrollBar().getMaximum() > GameLogPanel.this.getHeight();
            boolean isHoveringOverLogEntry = e.getSource() instanceof JTextArea;
            switch (e.getID()) {
                case 504: {
                    if (!isScrollBarRequired || !isHoveringOverLogEntry) break;
                    MouseUtil.setCursor(12);
                    break;
                }
                case 505: {
                    MouseUtil.resetCursor();
                    break;
                }
                case 502: {
                    if (e.getButton() != 1 || !isHoveringOverLogEntry) break;
                    GameLogPanel.this.isScrollBarVisible = isScrollBarRequired && !GameLogPanel.this.isScrollBarVisible;
                    GameLogPanel.this.setVerticalScrollbarVisibility();
                }
            }
        }
    }

    protected final class MyScrollablePanel
    extends JPanel
    implements Scrollable {
        protected MyScrollablePanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return GameLogPanel.this.textFont.getSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return GameLogPanel.this.textFont.getSize();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

