/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import forge.Singletons;
import forge.game.GameView;
import forge.gamemodes.match.NextGameDecision;
import forge.gui.SOverlayUtils;
import forge.gui.framework.FScreen;
import forge.interfaces.IGameController;
import forge.screens.match.CMatchUI;
import forge.screens.match.ViewWinLose;
import javax.swing.JButton;

public class ControlWinLose {
    private final ViewWinLose view;
    protected final GameView lastGame;
    protected final CMatchUI matchUI;

    public ControlWinLose(ViewWinLose v, GameView game0, CMatchUI matchUI) {
        this.view = v;
        this.lastGame = game0;
        this.matchUI = matchUI;
        this.addListeners();
    }

    public void addListeners() {
        this.view.getBtnContinue().addActionListener(e -> this.actionOnContinue());
        this.view.getBtnRestart().addActionListener(e -> this.actionOnRestart());
        this.view.getBtnQuit().addActionListener(e -> {
            this.actionOnQuit();
            ((JButton)e.getSource()).setEnabled(false);
        });
    }

    public void actionOnContinue() {
        this.nextGameAction(NextGameDecision.CONTINUE);
    }

    public void actionOnRestart() {
        this.nextGameAction(NextGameDecision.NEW);
    }

    public void actionOnQuit() {
        this.nextGameAction(NextGameDecision.QUIT);
        Singletons.getControl().setCurrentScreen(FScreen.HOME_SCREEN);
    }

    private void nextGameAction(NextGameDecision decision) {
        SOverlayUtils.hideOverlay();
        this.saveOptions();
        for (IGameController controller : this.matchUI.getOriginalGameControllers()) {
            controller.nextGameDecision(decision);
        }
    }

    public void saveOptions() {
        this.matchUI.writeMatchPreferences();
    }

    public boolean populateCustomPanel() {
        return false;
    }

    public ViewWinLose getView() {
        return this.view;
    }
}

