/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.match;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import forge.ImageCache;
import forge.LobbyPlayer;
import forge.Singletons;
import forge.StaticData;
import forge.ai.GameState;
import forge.card.CardStateName;
import forge.control.KeyboardShortcuts;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deckchooser.FDeckViewer;
import forge.game.GameEntity;
import forge.game.GameEntityView;
import forge.game.GameView;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.combat.CombatView;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellRemovedFromStack;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.DelayedReveal;
import forge.game.player.IHasIcon;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.SpellAbilityView;
import forge.game.spellability.StackItemView;
import forge.game.spellability.TargetChoices;
import forge.game.zone.ZoneType;
import forge.gamemodes.match.AbstractGuiGame;
import forge.gui.FNetOverlay;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.GuiChoose;
import forge.gui.GuiDialog;
import forge.gui.GuiUtils;
import forge.gui.MenuScroller;
import forge.gui.SOverlayUtils;
import forge.gui.framework.DragCell;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.gui.framework.SDisplayUtil;
import forge.gui.framework.SLayoutIO;
import forge.gui.framework.VEmptyDoc;
import forge.gui.util.SOptionPane;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.menus.IMenuProvider;
import forge.model.FModel;
import forge.player.PlayerZoneUpdate;
import forge.player.PlayerZoneUpdates;
import forge.screens.match.TargetingOverlay;
import forge.screens.match.VAssignCombatDamage;
import forge.screens.match.VAssignGenericAmount;
import forge.screens.match.VMatchUI;
import forge.screens.match.ViewWinLose;
import forge.screens.match.controllers.CAntes;
import forge.screens.match.controllers.CCombat;
import forge.screens.match.controllers.CDetailPicture;
import forge.screens.match.controllers.CDev;
import forge.screens.match.controllers.CDock;
import forge.screens.match.controllers.CLog;
import forge.screens.match.controllers.CPrompt;
import forge.screens.match.controllers.CStack;
import forge.screens.match.menus.CMatchUIMenus;
import forge.screens.match.views.VField;
import forge.screens.match.views.VHand;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import forge.toolbox.imaging.FImagePanel;
import forge.toolbox.imaging.FImageUtil;
import forge.toolbox.special.PhaseIndicator;
import forge.toolbox.special.PhaseLabel;
import forge.trackable.TrackableCollection;
import forge.util.ITriggerEvent;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import forge.view.FView;
import forge.view.arcane.CardPanel;
import forge.view.arcane.FloatingZone;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.layout.LinkHandler;
import net.miginfocom.swing.MigLayout;

public final class CMatchUI
extends AbstractGuiGame
implements ICDoc,
IMenuProvider {
    private final FScreen screen;
    private final VMatchUI view;
    private final CMatchUIMenus menus = new CMatchUIMenus(this);
    private final Map<EDocID, IVDoc<? extends ICDoc>> myDocs;
    private final TargetingOverlay targetingOverlay = new TargetingOverlay(this);
    private FCollectionView<PlayerView> sortedPlayers;
    private final Map<String, String> avatarImages = new HashMap<String, String>();
    private boolean allHands;
    private boolean showOverlay = true;
    private JPopupMenu openAbilityMenu;
    private IVDoc<? extends ICDoc> selectedDocBeforeCombat;
    private final CAntes cAntes = new CAntes(this);
    private final CCombat cCombat = new CCombat();
    private final CDetailPicture cDetailPicture = new CDetailPicture(this);
    private final CDev cDev = new CDev(this);
    private final CDock cDock = new CDock(this);
    private final CLog cLog = new CLog(this);
    private final CPrompt cPrompt = new CPrompt(this);
    private final CStack cStack = new CStack(this);
    private int nextNotifiableStackIndex = 0;

    public CMatchUI() {
        this.view = new VMatchUI(this);
        this.screen = FScreen.getMatchScreen(this, this.view);
        this.myDocs = new EnumMap<EDocID, IVDoc<? extends ICDoc>>(EDocID.class);
        this.myDocs.put(EDocID.CARD_PICTURE, this.cDetailPicture.getCPicture().getView());
        this.myDocs.put(EDocID.CARD_DETAIL, this.cDetailPicture.getCDetail().getView());
        if (CMatchUI.isPreferenceEnabled(ForgePreferences.FPref.UI_ANTE)) {
            this.myDocs.put(EDocID.CARD_ANTES, this.cAntes.getView());
        } else {
            this.myDocs.put(EDocID.CARD_ANTES, null);
        }
        this.myDocs.put(EDocID.REPORT_MESSAGE, this.getCPrompt().getView());
        this.myDocs.put(EDocID.REPORT_STACK, this.getCStack().getView());
        this.myDocs.put(EDocID.REPORT_COMBAT, this.cCombat.getView());
        this.myDocs.put(EDocID.REPORT_LOG, this.cLog.getView());
        this.myDocs.put(EDocID.DEV_MODE, this.getCDev().getView());
        this.myDocs.put(EDocID.BUTTON_DOCK, this.getCDock().getView());
    }

    private void registerDocs() {
        for (Map.Entry<EDocID, IVDoc<? extends ICDoc>> doc : this.myDocs.entrySet()) {
            doc.getKey().setDoc(doc.getValue());
        }
    }

    private static boolean isPreferenceEnabled(ForgePreferences.FPref preferenceName) {
        return FModel.getPreferences().getPrefBoolean(preferenceName);
    }

    FScreen getScreen() {
        return this.screen;
    }

    public boolean isCurrentScreen() {
        return Singletons.getControl().getCurrentScreen() == this.screen;
    }

    private boolean isInGame() {
        return this.getGameView() != null;
    }

    public String getAvatarImage(String playerName) {
        return this.avatarImages.get(playerName);
    }

    @Override
    public void setGameView(GameView gameView0) {
        super.setGameView(gameView0);
        gameView0 = this.getGameView();
        if (gameView0 == null) {
            return;
        }
        this.cDetailPicture.setGameView(gameView0);
        this.screen.setTabCaption(gameView0.getTitle());
        if (this.sortedPlayers != null) {
            FThreads.invokeInEdtNowOrLater(() -> {
                for (VField f : this.getFieldViews()) {
                    f.updateDetails();
                    f.updateZones();
                    f.updateManaPool();
                    f.getTabletop().update();
                }
                for (VHand h2 : this.getHandViews()) {
                    h2.getLayoutControl().updateHand();
                }
            });
        }
    }

    @Override
    protected void updateCurrentPlayer(PlayerView player) {
        this.getCDev().update();
    }

    public CDev getCDev() {
        return this.cDev;
    }

    public CDock getCDock() {
        return this.cDock;
    }

    CPrompt getCPrompt() {
        return this.cPrompt;
    }

    public CStack getCStack() {
        return this.cStack;
    }

    public TargetingOverlay getTargetingOverlay() {
        return this.targetingOverlay;
    }

    public void viewDeckList() {
        if (!this.isInGame() || this.getCurrentPlayer() == null) {
            return;
        }
        Deck deck = this.getGameView().getDeck(this.getCurrentPlayer());
        if (deck != null) {
            FDeckViewer.show(deck);
        }
    }

    public FSkin.SkinImage getPlayerAvatar(PlayerView p, int defaultIndex) {
        if (this.avatarImages.containsKey(p.getLobbyPlayerName())) {
            return ImageCache.getIcon(this.avatarImages.get(p.getLobbyPlayerName()));
        }
        int avatarIdx = p.getAvatarIndex();
        return FSkin.getAvatars().get(avatarIdx >= 0 ? avatarIdx : defaultIndex);
    }

    private void initMatch(FCollectionView<PlayerView> sortedPlayers, Collection<PlayerView> myPlayers) {
        this.sortedPlayers = sortedPlayers;
        this.allHands = sortedPlayers.size() == this.getLocalPlayerCount();
        String[] indices = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        ArrayList<VField> fields = new ArrayList<VField>();
        Singletons.getView().getLpnDocument().add((Component)this.targetingOverlay.getPanel(), FView.TARGETING_LAYER);
        this.targetingOverlay.getPanel().setSize(Singletons.getControl().getDisplaySize());
        int i = 0;
        for (PlayerView p : sortedPlayers) {
            boolean mirror = !this.isLocalPlayer(p);
            EDocID fieldDoc = EDocID.Fields[i];
            VField f = new VField(this, fieldDoc, p, mirror);
            fields.add(f);
            this.myDocs.put(fieldDoc, f);
            f.setAvatar(this.getPlayerAvatar(p, Integer.parseInt(indices[i > 2 ? 1 : 0])));
            f.getLayoutControl().initialize();
            ++i;
        }
        this.view.setFieldViews(fields);
        this.initHandViews();
        this.registerDocs();
        this.screen.setCloseButtonTooltip(this.getConcedeCaption() + " Game");
    }

    private void initHandViews() {
        ArrayList<VHand> hands = new ArrayList<VHand>();
        Set<PlayerView> localPlayers = this.getLocalPlayers();
        int i = 0;
        for (PlayerView p : this.sortedPlayers) {
            if (this.allHands || this.isLocalPlayer(p) || CardView.mayViewAny(p.getHand(), localPlayers)) {
                EDocID doc = EDocID.Hands[i];
                VHand newHand = new VHand(this, doc, p);
                newHand.getLayoutControl().initialize();
                hands.add(newHand);
                this.myDocs.put(doc, newHand);
            }
            ++i;
        }
        this.view.setHandViews(hands);
    }

    public void resetAllPhaseButtons() {
        for (VField v : this.view.getFieldViews()) {
            v.getPhaseIndicator().resetPhaseButtons();
        }
    }

    public List<VField> getFieldViews() {
        if (this.view == null) {
            return null;
        }
        return this.view.getFieldViews();
    }

    public VField getFieldViewFor(PlayerView p) {
        int idx = this.getPlayerIndex(p);
        return idx < 0 ? null : this.getFieldViews().get(idx);
    }

    public List<VHand> getHandViews() {
        return this.view.getHands();
    }

    public VHand getHandFor(PlayerView p) {
        int idx = this.getPlayerIndex(p);
        List<VHand> allHands = this.getHandViews();
        return idx < 0 || idx >= allHands.size() ? null : allHands.get(idx);
    }

    @Override
    public void setCard(CardView c) {
        this.setCard(c, false);
    }

    public void setCard(CardView c, boolean isInAltState) {
        FThreads.invokeInEdtNowOrLater(() -> this.cDetailPicture.showCard(c, isInAltState));
    }

    public void setCard(InventoryItem item) {
        this.cDetailPicture.showItem(item);
    }

    private int getPlayerIndex(PlayerView player) {
        return this.sortedPlayers.indexOf(player);
    }

    @Override
    public void showCombat() {
        CombatView combat = this.getGameView().getCombat();
        if (combat != null && combat.getNumAttackers() > 0 && this.getGameView().peekStack() == null) {
            IVDoc<? extends ICDoc> combatDoc;
            if (this.selectedDocBeforeCombat == null && (combatDoc = EDocID.REPORT_COMBAT.getDoc()).getParentCell() != null) {
                this.selectedDocBeforeCombat = combatDoc.getParentCell().getSelected();
                if (this.selectedDocBeforeCombat != combatDoc) {
                    SDisplayUtil.showTab(combatDoc);
                } else {
                    this.selectedDocBeforeCombat = null;
                }
            }
        } else if (this.selectedDocBeforeCombat != null) {
            SDisplayUtil.showTab(this.selectedDocBeforeCombat);
            this.selectedDocBeforeCombat = null;
        }
        this.cCombat.setModel(combat);
        this.cCombat.update();
    }

    @Override
    public void updateDayTime(String daytime) {
        super.updateDayTime(daytime);
        if ("Day".equals(daytime)) {
            FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_DAY), true);
            this.getScreen().setDaytime("Day");
        } else {
            FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_NIGHT), true);
            this.getScreen().setDaytime("Night");
        }
        FView.SINGLETON_INSTANCE.getPnlInsets().repaint();
    }

    @Override
    public void updateZones(Iterable<PlayerZoneUpdate> zonesToUpdate) {
        for (PlayerZoneUpdate update : zonesToUpdate) {
            PlayerView owner = update.getPlayer();
            boolean setupPlayZone = false;
            boolean updateHand = false;
            boolean updateAnte = false;
            boolean updateZones = false;
            block6: for (ZoneType zone : update.getZones()) {
                switch (zone) {
                    case Battlefield: {
                        setupPlayZone = true;
                        continue block6;
                    }
                    case Ante: {
                        updateAnte = true;
                        continue block6;
                    }
                    case Hand: {
                        updateHand = true;
                        updateZones = true;
                        FloatingZone.refresh(owner, zone);
                        continue block6;
                    }
                }
                updateZones = true;
                FloatingZone.refresh(owner, zone);
            }
            VField vField = this.getFieldViewFor(owner);
            if (setupPlayZone) {
                vField.getTabletop().update();
            }
            if (updateHand) {
                VHand vHand = this.getHandFor(owner);
                if (vHand != null) {
                    vHand.getLayoutControl().updateHand();
                }
                vField.updateDetails();
            }
            if (updateAnte) {
                this.cAntes.update();
            }
            if (!updateZones) continue;
            vField.updateZones();
        }
    }

    @Override
    public Iterable<PlayerZoneUpdate> tempShowZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        ArrayList<PlayerZoneUpdate> updatedPlayerZones = Lists.newArrayList();
        for (PlayerZoneUpdate update : zonesToUpdate) {
            PlayerView player = update.getPlayer();
            for (ZoneType zone : update.getZones()) {
                switch (zone) {
                    case Battlefield: {
                        break;
                    }
                    case Hand: {
                        if (controller == player || !FloatingZone.show(this, player, zone)) break;
                        updatedPlayerZones.add(update);
                        break;
                    }
                    case Ante: 
                    case Library: 
                    case Graveyard: 
                    case Exile: 
                    case Flashback: 
                    case Command: 
                    case Sideboard: {
                        if (!FloatingZone.show(this, player, zone)) break;
                        updatedPlayerZones.add(update);
                        break;
                    }
                }
            }
        }
        return updatedPlayerZones;
    }

    @Override
    public void hideZones(PlayerView controller, Iterable<PlayerZoneUpdate> zonesToUpdate) {
        if (zonesToUpdate != null) {
            for (PlayerZoneUpdate update : zonesToUpdate) {
                PlayerView player = update.getPlayer();
                for (ZoneType zone : update.getZones()) {
                    switch (zone) {
                        case Battlefield: {
                            break;
                        }
                        case Ante: 
                        case Hand: 
                        case Library: 
                        case Graveyard: 
                        case Exile: 
                        case Flashback: 
                        case Command: 
                        case Sideboard: {
                            FloatingZone.hide(this, player, zone);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void updateManaPool(Iterable<PlayerView> manaPoolUpdate) {
        for (PlayerView p : manaPoolUpdate) {
            this.getFieldViewFor(p).updateManaPool();
        }
    }

    @Override
    public void updateLives(Iterable<PlayerView> livesUpdate) {
        for (PlayerView p : livesUpdate) {
            this.getFieldViewFor(p).updateDetails();
        }
    }

    @Override
    public void updateShards(Iterable<PlayerView> shardsUpdate) {
    }

    @Override
    public void updateCards(Iterable<CardView> cards) {
        block4: for (CardView c : cards) {
            ZoneType zone = c.getZone();
            if (zone == null) {
                return;
            }
            switch (zone) {
                case Battlefield: {
                    VField battlefield = this.getFieldViewFor(c.getController());
                    if (battlefield == null) continue block4;
                    battlefield.getTabletop().updateCard(c, false);
                    break;
                }
                case Hand: {
                    CardPanel cp;
                    VHand hand = this.getHandFor(c.getController());
                    if (hand == null || (cp = hand.getHandArea().getCardPanel(c.getId())) == null) continue block4;
                    cp.setCard(c);
                    cp.repaintOverlays();
                    break;
                }
                default: {
                    FloatingZone.refresh(c.getController(), zone);
                }
            }
        }
    }

    @Override
    public void setSelectables(Iterable<CardView> cards) {
        super.setSelectables(cards);
        FThreads.invokeInEdtNowOrLater(() -> {
            for (PlayerView p : this.getGameView().getPlayers()) {
                if (p.getCards(ZoneType.Battlefield) != null) {
                    this.updateCards(p.getCards(ZoneType.Battlefield));
                }
                if (p.getCards(ZoneType.Hand) == null) continue;
                this.updateCards(p.getCards(ZoneType.Hand));
            }
            FloatingZone.refreshAll();
        });
    }

    @Override
    public void clearSelectables() {
        super.clearSelectables();
        FThreads.invokeInEdtNowOrLater(() -> {
            for (PlayerView p : this.getGameView().getPlayers()) {
                if (p.getCards(ZoneType.Battlefield) != null) {
                    this.updateCards(p.getCards(ZoneType.Battlefield));
                }
                if (p.getCards(ZoneType.Hand) == null) continue;
                this.updateCards(p.getCards(ZoneType.Hand));
            }
            FloatingZone.refreshAll();
        });
    }

    @Override
    public void refreshField() {
        super.refreshField();
        FThreads.invokeInEdtNowOrLater(() -> {
            for (PlayerView p : this.getGameView().getPlayers()) {
                if (p.getCards(ZoneType.Battlefield) == null) continue;
                this.updateCards(p.getCards(ZoneType.Battlefield));
            }
            FloatingZone.refreshAll();
        });
    }

    @Override
    public GameState getGamestate() {
        return null;
    }

    @Override
    public List<JMenu> getMenus() {
        return this.menus.getMenus();
    }

    @Override
    public void register() {
        this.initHandViews();
        this.registerDocs();
        for (EDocID fieldDoc : EDocID.VarDocs) {
            DragCell parent;
            if (this.myDocs.containsKey((Object)fieldDoc) || (parent = fieldDoc.getDoc().getParentCell()) == null) continue;
            parent.removeDoc(fieldDoc.getDoc());
            fieldDoc.setDoc(new VEmptyDoc(fieldDoc));
        }
    }

    @Override
    public void initialize() {
        Singletons.getControl().getForgeMenu().setProvider(this);
        this.updatePlayerControl();
        KeyboardShortcuts.attachKeyboardShortcuts(this);
        for (IVDoc<? extends ICDoc> view : this.myDocs.values()) {
            if (view == null) continue;
            ICDoc layoutControl = view.getLayoutControl();
            layoutControl.initialize();
            layoutControl.update();
        }
        FloatingZone.closeAll();
    }

    @Override
    public void update() {
    }

    public void repaintCardOverlays() {
        List<CardPanel> panels = this.getVisibleCardPanels();
        for (CardPanel panel : panels) {
            panel.repaintOverlays();
        }
    }

    private List<CardPanel> getVisibleCardPanels() {
        ArrayList<CardPanel> panels = new ArrayList<CardPanel>();
        for (VHand h2 : this.view.getHands()) {
            panels.addAll(h2.getHandArea().getCardPanels());
        }
        for (VField f : this.view.getFieldViews()) {
            panels.addAll(f.getTabletop().getCardPanels());
        }
        return panels;
    }

    private CardPanel findCardPanel(CardView card) {
        int id = card.getId();
        switch (card.getZone()) {
            case Battlefield: {
                for (VField f : this.view.getFieldViews()) {
                    CardPanel panel = f.getTabletop().getCardPanel(id);
                    if (panel == null) continue;
                    SDisplayUtil.showTab(f);
                    return panel;
                }
                break;
            }
            case Hand: {
                for (VHand h2 : this.view.getHands()) {
                    CardPanel panel = h2.getHandArea().getCardPanel(id);
                    if (panel == null) continue;
                    SDisplayUtil.showTab(h2);
                    return panel;
                }
                break;
            }
            case Library: 
            case Graveyard: 
            case Exile: 
            case Command: {
                return FloatingZone.getCardPanel(this, card);
            }
        }
        return null;
    }

    @Override
    public void updateButtons(PlayerView owner, String label1, String label2, boolean enable1, boolean enable2, boolean focus1) {
        FButton btn1 = this.view.getBtnOK();
        FButton btn2 = this.view.getBtnCancel();
        btn1.setText(label1);
        btn2.setText(label2);
        FButton toFocus = enable1 && focus1 ? btn1 : (enable2 ? btn2 : null);
        Runnable focusRoutine = () -> {
            btn1.setEnabled(enable1);
            btn2.setEnabled(enable2);
            btn1.setFocusable(enable1 && focus1);
            btn2.setFocusable(enable2 && !focus1);
            if (toFocus != null && !FNetOverlay.SINGLETON_INSTANCE.getTxtInput().hasFocus()) {
                toFocus.requestFocus();
            }
        };
        if (FThreads.isGuiThread()) {
            FThreads.invokeInEdtNowOrLater(focusRoutine);
        } else {
            FThreads.invokeInEdtAndWait(focusRoutine);
        }
    }

    @Override
    public void flashIncorrectAction() {
        this.getCPrompt().remind();
    }

    @Override
    public void alertUser() {
        this.getCPrompt().alert();
    }

    @Override
    public void updatePhase(boolean saveState) {
        PlayerView p = this.getGameView().getPlayerTurn();
        PhaseType ph = this.getGameView().getPhase();
        PhaseLabel lbl = null;
        if (ph != null) {
            lbl = p == null ? null : this.getFieldViewFor(p).getPhaseIndicator().getLabelFor(ph);
        } else {
            System.err.println("getGameView().getPhase() returned 'null'");
        }
        this.resetAllPhaseButtons();
        if (lbl != null) {
            lbl.setActive(true);
        }
        if (this.openAbilityMenu != null) {
            this.openAbilityMenu.setVisible(false);
        }
    }

    @Override
    public void updateTurn(PlayerView player) {
        VField nextField = this.getFieldViewFor(player);
        SDisplayUtil.showTab(nextField);
        this.cPrompt.updateText();
        this.repaintCardOverlays();
    }

    @Override
    public void updatePlayerControl() {
        this.initHandViews();
        SLayoutIO.loadLayout(null);
        this.view.populate();
        PlayerZoneUpdates zones = new PlayerZoneUpdates();
        for (PlayerView p : this.sortedPlayers) {
            zones.add(new PlayerZoneUpdate(p, ZoneType.Hand));
        }
        this.updateZones(zones);
    }

    @Override
    public void disableOverlay() {
        this.showOverlay = false;
    }

    @Override
    public void enableOverlay() {
        this.showOverlay = true;
    }

    @Override
    public void finishGame() {
        FloatingZone.closeAll();
        GameView gameView = this.getGameView();
        if (this.hasLocalPlayers() || gameView.isMatchOver()) {
            new ViewWinLose(gameView, this).show();
        }
        if (this.showOverlay) {
            SOverlayUtils.showOverlay();
        }
    }

    @Override
    public void updateStack() {
        FThreads.invokeInEdtNowOrLater(() -> this.getCStack().update());
    }

    public void clearPanelSelections() {
        List<VField> fields = this.view.getFieldViews();
        for (VField field : fields) {
            for (CardPanel p : field.getTabletop().getCardPanels()) {
                p.setSelected(false);
            }
        }
    }

    @Override
    public void setPanelSelection(CardView card) {
        for (VField v : this.view.getFieldViews()) {
            List<CardPanel> panels = v.getTabletop().getCardPanels();
            for (CardPanel p : panels) {
                if (!p.getCard().equals(card)) continue;
                p.setSelected(true);
                return;
            }
        }
    }

    @Override
    public SpellAbilityView getAbilityToPlay(CardView hostCard, List<SpellAbilityView> abilities, ITriggerEvent triggerEvent) {
        if (triggerEvent == null) {
            if (abilities.isEmpty()) {
                return null;
            }
            if (abilities.size() == 1) {
                return abilities.get(0);
            }
            return GuiChoose.oneOrNone(Localizer.getInstance().getMessage("lblChooseAbilityToPlay", new Object[0]), abilities);
        }
        if (abilities.isEmpty()) {
            return null;
        }
        if (abilities.size() == 1 && !abilities.get(0).promptIfOnlyPossibleAbility()) {
            if (abilities.get(0).canPlay()) {
                return abilities.get(0);
            }
            return null;
        }
        JPopupMenu menu = new JPopupMenu(Localizer.getInstance().getMessage("lblAbilities", new Object[0]));
        int firstEnabled = -1;
        int shortcut = 49;
        int index = 0;
        for (SpellAbilityView ab : abilities) {
            String s2;
            boolean enabled = ab.canPlay();
            if (enabled && firstEnabled < 0) {
                firstEnabled = index;
            }
            if ((s2 = ab.toString()).contains("\n")) {
                s2 = s2.substring(0, s2.indexOf("\n"));
            }
            GuiUtils.addMenuItem(menu, FSkin.encodeSymbols(s2, true), shortcut > 0 ? KeyStroke.getKeyStroke(shortcut, 0) : null, () -> this.getGameController().selectAbility(ab), enabled);
            if (shortcut > 0 && ++shortcut > 57) {
                shortcut = 0;
            }
            ++index;
        }
        if (firstEnabled >= 0) {
            int y;
            int x;
            Container menuParent;
            MenuScroller.setScrollerFor(menu, 8, 125, 3, 1);
            CardPanel panel = this.findCardPanel(hostCard);
            if (panel == null) {
                menuParent = this.getCPrompt().getView().getTarMessage();
                x = 0;
                y = 0;
                SDisplayUtil.showTab(this.getCPrompt().getView());
            } else {
                ZoneType zone = hostCard.getZone();
                if (ImmutableList.of(ZoneType.Command, ZoneType.Exile, ZoneType.Graveyard, ZoneType.Library).contains((Object)zone)) {
                    FloatingZone.show(this, hostCard.getController(), zone);
                }
                menuParent = panel.getParent();
                x = triggerEvent.getX();
                y = triggerEvent.getY();
            }
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    CMatchUI.this.openAbilityMenu = null;
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    CMatchUI.this.openAbilityMenu = null;
                }
            });
            menu.show(menuParent, x, y);
            this.openAbilityMenu = menu;
            MenuScroller.setMenuSelectedIndex(menu, firstEnabled, false);
        }
        return null;
    }

    @Override
    public void showPromptMessage(PlayerView playerView, String message) {
        this.cPrompt.setMessage(message);
    }

    @Override
    public void showCardPromptMessage(PlayerView playerView, String message, CardView card) {
        this.cPrompt.setMessage(message, card);
    }

    public void showPromptMessage(PlayerView playerView, String message, CardView card) {
        this.cPrompt.setMessage(message, card);
    }

    @Override
    public void showManaPool(PlayerView player) {
    }

    @Override
    public void hideManaPool(PlayerView player) {
    }

    @Override
    public Map<CardView, Integer> assignCombatDamage(CardView attacker, List<CardView> blockers, int damage, GameEntityView defender, boolean overrideOrder, boolean maySkip) {
        if (damage <= 0) {
            return Collections.emptyMap();
        }
        CardView firstBlocker = blockers.get(0);
        if (!overrideOrder && !attacker.getCurrentState().hasDeathtouch() && firstBlocker.getLethalDamage() >= damage) {
            return ImmutableMap.of(firstBlocker, damage);
        }
        AtomicReference result = new AtomicReference();
        FThreads.invokeInEdtAndWait(() -> {
            VAssignCombatDamage v = new VAssignCombatDamage(this, attacker, blockers, damage, defender, overrideOrder, maySkip);
            result.set(v.getDamageMap());
        });
        return (Map)result.get();
    }

    @Override
    public Map<Object, Integer> assignGenericAmount(CardView effectSource, Map<Object, Integer> target, int amount, boolean atLeastOne, String amountLabel) {
        if (amount <= 0) {
            return Collections.emptyMap();
        }
        AtomicReference result = new AtomicReference();
        FThreads.invokeInEdtAndWait(() -> {
            VAssignGenericAmount v = new VAssignGenericAmount(this, effectSource, target, amount, atLeastOne, amountLabel);
            result.set(v.getAssignedMap());
        });
        return (Map)result.get();
    }

    @Override
    public void openView(TrackableCollection<PlayerView> myPlayers) {
        GameView gameView = this.getGameView();
        gameView.getGameLog().addObserver(this.cLog);
        FCollectionView<PlayerView> players = gameView.getPlayers();
        if (players.size() == 2 && myPlayers != null && myPlayers.size() == 1 && myPlayers.get((PlayerView)false).equals(players.get((PlayerView)true))) {
            players = new FCollection<PlayerView>(new PlayerView[]{players.get((PlayerView)true), players.get((PlayerView)false)});
        }
        this.initMatch(players, myPlayers);
        this.clearSelectables();
        this.actuateMatchPreferences();
        Singletons.getControl().setCurrentScreen(this.screen);
        SDisplayUtil.showTab(EDocID.REPORT_LOG.getDoc());
        SOverlayUtils.hideOverlay();
        this.getScreen().setDaytime(null);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MATCH_IMAGE_VISIBLE)) {
            FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_MATCH), true);
        } else {
            FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage((Image)null);
        }
    }

    @Override
    public void afterGameEnd() {
        super.afterGameEnd();
        Singletons.getView().getLpnDocument().remove(this.targetingOverlay.getPanel());
        FThreads.invokeInEdtNowOrLater(() -> {
            Singletons.getView().getNavigationBar().closeTab(this.screen);
            LinkHandler.clearWeakReferencesNow();
        });
    }

    @Override
    public int showOptionDialog(String message, String title, FSkinProp icon, List<String> options, int defaultOption) {
        return FOptionPane.showOptionDialog(message, title, icon == null ? null : FSkin.getImage(icon), options, defaultOption);
    }

    @Override
    public String showInputDialog(String message, String title, FSkinProp icon, String initialInput, List<String> inputOptions, boolean isNumeric) {
        return FOptionPane.showInputDialog(message, title, icon == null ? null : FSkin.getImage(icon), initialInput, inputOptions);
    }

    @Override
    public <T> List<T> getChoices(String message, int min2, int max, List<T> choices, T selected, Function<T, String> display) {
        return GuiChoose.getChoices(message, min2, max, choices, selected, display, this);
    }

    @Override
    public <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices, CardView referenceCard, boolean sideboardingMode) {
        return GuiChoose.order(title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices, referenceCard, sideboardingMode, this);
    }

    @Override
    public List<PaperCard> sideboard(CardPool sideboard, CardPool main, String message) {
        return GuiChoose.sideboard(this, sideboard.toFlatList(), main.toFlatList(), message);
    }

    @Override
    public GameEntityView chooseSingleEntityForEffect(String title, List<? extends GameEntityView> optionList, DelayedReveal delayedReveal, boolean isOptional) {
        if (delayedReveal != null) {
            this.reveal(delayedReveal.getMessagePrefix(), delayedReveal.getCards());
        }
        if (isOptional) {
            return this.oneOrNone(title, optionList);
        }
        return this.one(title, optionList);
    }

    @Override
    public List<GameEntityView> chooseEntitiesForEffect(String title, List<? extends GameEntityView> optionList, int min2, int max, DelayedReveal delayedReveal) {
        if (delayedReveal != null) {
            this.reveal(delayedReveal.getMessagePrefix(), delayedReveal.getCards());
        }
        return this.order(title, Localizer.getInstance().getMessage("lblSelected", new Object[0]), optionList.size() - max, optionList.size() - min2, optionList, null, null, false);
    }

    @Override
    public List<CardView> manipulateCardList(String title, Iterable<CardView> cards, Iterable<CardView> manipulable, boolean toTop, boolean toBottom, boolean toAnywhere) {
        return GuiChoose.manipulateCardList(this, title, cards, manipulable, toTop, toBottom, toAnywhere);
    }

    @Override
    public void setPlayerAvatar(LobbyPlayer player, IHasIcon ihi) {
        this.avatarImages.put(player.getName(), ihi.getIconImageKey());
    }

    @Override
    public PlayerZoneUpdates openZones(PlayerView controller, Collection<ZoneType> zones, Map<PlayerView, Object> playersWithTargetables, boolean backupLastZones) {
        PlayerZoneUpdates zonesToUpdate = new PlayerZoneUpdates();
        for (PlayerView view : playersWithTargetables.keySet()) {
            for (ZoneType zone : zones) {
                if (zone.equals((Object)ZoneType.Battlefield) || zone.equals((Object)ZoneType.Hand) || zone.equals((Object)ZoneType.Stack)) continue;
                zonesToUpdate.add(new PlayerZoneUpdate(view, zone));
            }
        }
        this.tempShowZones(controller, zonesToUpdate);
        return zonesToUpdate;
    }

    @Override
    public void restoreOldZones(PlayerView playerView, PlayerZoneUpdates playerZoneUpdates) {
        this.hideZones(playerView, playerZoneUpdates);
    }

    @Override
    public boolean isUiSetToSkipPhase(PlayerView playerTurn, PhaseType phase) {
        PlayerView controlledPlayer = playerTurn.getMindSlaveMaster();
        boolean skippedPhase = true;
        if (controlledPlayer != null) {
            PhaseLabel controlledLabel = this.getFieldViewFor(controlledPlayer).getPhaseIndicator().getLabelFor(phase);
            skippedPhase = controlledLabel != null && !controlledLabel.getEnabled();
        }
        PhaseLabel label = this.getFieldViewFor(playerTurn).getPhaseIndicator().getLabelFor(phase);
        return skippedPhase && label != null && !label.getEnabled();
    }

    public void writeMatchPreferences() {
        ForgePreferences prefs = FModel.getPreferences();
        List<VField> fieldViews = this.getFieldViews();
        PhaseIndicator fvAi = fieldViews.get(1).getPhaseIndicator();
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_UPKEEP, fvAi.getLblUpkeep().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_DRAW, fvAi.getLblDraw().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_MAIN1, fvAi.getLblMain1().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_BEGINCOMBAT, fvAi.getLblBeginCombat().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_DECLAREATTACKERS, fvAi.getLblDeclareAttackers().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_DECLAREBLOCKERS, fvAi.getLblDeclareBlockers().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_FIRSTSTRIKE, fvAi.getLblFirstStrike().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_COMBATDAMAGE, fvAi.getLblCombatDamage().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_ENDCOMBAT, fvAi.getLblEndCombat().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_MAIN2, fvAi.getLblMain2().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_EOT, fvAi.getLblEndTurn().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_AI_CLEANUP, fvAi.getLblCleanup().getEnabled());
        PhaseIndicator fvHuman = fieldViews.get(0).getPhaseIndicator();
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_UPKEEP, fvHuman.getLblUpkeep().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_DRAW, fvHuman.getLblDraw().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_MAIN1, fvHuman.getLblMain1().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_BEGINCOMBAT, fvHuman.getLblBeginCombat().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_DECLAREATTACKERS, fvHuman.getLblDeclareAttackers().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_DECLAREBLOCKERS, fvHuman.getLblDeclareBlockers().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_FIRSTSTRIKE, fvHuman.getLblFirstStrike().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_COMBATDAMAGE, fvHuman.getLblCombatDamage().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_ENDCOMBAT, fvHuman.getLblEndCombat().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_MAIN2, fvHuman.getLblMain2().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_EOT, fvHuman.getLblEndTurn().getEnabled());
        prefs.setPref(ForgePreferences.FPref.PHASE_HUMAN_CLEANUP, fvHuman.getLblCleanup().getEnabled());
        prefs.save();
    }

    private void actuateMatchPreferences() {
        ForgePreferences prefs = FModel.getPreferences();
        List<VField> fieldViews = this.getFieldViews();
        PhaseIndicator fvHuman = fieldViews.get(0).getPhaseIndicator();
        fvHuman.getLblUpkeep().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_UPKEEP));
        fvHuman.getLblDraw().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_DRAW));
        fvHuman.getLblMain1().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_MAIN1));
        fvHuman.getLblBeginCombat().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_BEGINCOMBAT));
        fvHuman.getLblDeclareAttackers().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_DECLAREATTACKERS));
        fvHuman.getLblDeclareBlockers().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_DECLAREBLOCKERS));
        fvHuman.getLblFirstStrike().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_FIRSTSTRIKE));
        fvHuman.getLblCombatDamage().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_COMBATDAMAGE));
        fvHuman.getLblEndCombat().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_ENDCOMBAT));
        fvHuman.getLblMain2().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_MAIN2));
        fvHuman.getLblEndTurn().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_EOT));
        fvHuman.getLblCleanup().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_HUMAN_CLEANUP));
        for (int i = 1; i < fieldViews.size(); ++i) {
            PhaseIndicator fvAi = fieldViews.get(i).getPhaseIndicator();
            fvAi.getLblUpkeep().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_UPKEEP));
            fvAi.getLblDraw().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_DRAW));
            fvAi.getLblMain1().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_MAIN1));
            fvAi.getLblBeginCombat().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_BEGINCOMBAT));
            fvAi.getLblDeclareAttackers().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_DECLAREATTACKERS));
            fvAi.getLblDeclareBlockers().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_DECLAREBLOCKERS));
            fvAi.getLblFirstStrike().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_FIRSTSTRIKE));
            fvAi.getLblCombatDamage().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_COMBATDAMAGE));
            fvAi.getLblEndCombat().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_ENDCOMBAT));
            fvAi.getLblMain2().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_MAIN2));
            fvAi.getLblEndTurn().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_EOT));
            fvAi.getLblCleanup().setEnabled(prefs.getPrefBoolean(ForgePreferences.FPref.PHASE_AI_CLEANUP));
        }
    }

    @Override
    public void message(String message, String title) {
        SOptionPane.showMessageDialog(message, title);
    }

    @Override
    public void showErrorDialog(String message, String title) {
        SOptionPane.showErrorDialog(message, title);
    }

    @Override
    public boolean confirm(CardView c, String question, boolean defaultIsYes, List<String> options) {
        return GuiDialog.confirm(c, question, defaultIsYes, options, this);
    }

    @Override
    public boolean showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes) {
        ImmutableList<String> options = ImmutableList.of(yesButtonText, noButtonText);
        int reply = SOptionPane.showOptionDialog(message, title, SOptionPane.QUESTION_ICON, options, defaultYes ? 0 : 1);
        return reply == 0;
    }

    @Override
    public void notifyStackAddition(GameEventSpellAbilityCast event) {
        SpellAbility sa = event.sa;
        String stackNotificationPolicy = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_STACK_EFFECT_NOTIFICATION_POLICY);
        boolean isAi = sa.getActivatingPlayer().isAI();
        boolean isTrigger = sa.isTrigger();
        int stackIndex = event.stackIndex;
        if (stackIndex == this.nextNotifiableStackIndex) {
            if ("Always".equals(stackNotificationPolicy) || "AI cast/activated, or triggered by any player".equals(stackNotificationPolicy) && (isAi || isTrigger)) {
                SpellAbilityStackInstance si = event.si;
                MigLayout migLayout = new MigLayout("insets 15, left, gap 30, fill");
                JPanel mainPanel = new JPanel(migLayout);
                Dimension parentSize = JOptionPane.getRootFrame().getSize();
                Dimension maxSize = new Dimension(1400, parentSize.height - 100);
                mainPanel.setMaximumSize(maxSize);
                mainPanel.setOpaque(false);
                this.addBigImageToStackModalPanel(mainPanel, si);
                this.addTextToStackModalPanel(mainPanel, sa, si);
                int numSmallImages = 0;
                GameEntityView enchantedEntityView = null;
                Card hostCard = sa.getHostCard();
                if (hostCard.isEnchantment()) {
                    GameEntity enchantedEntity = hostCard.getEntityAttachedTo();
                    if (enchantedEntity != null) {
                        enchantedEntityView = enchantedEntity.getView();
                        ++numSmallImages;
                    } else if (sa.getRootAbility() != null && sa.getRootAbility().getPaidList("Sacrificed", true) != null && !sa.getRootAbility().getPaidList("Sacrificed", true).isEmpty() && (enchantedEntity = ((Card)sa.getRootAbility().getPaidList("Sacrificed", true).get(false)).getEnchantingCard()) != null) {
                        enchantedEntityView = enchantedEntity.getView();
                        ++numSmallImages;
                    }
                }
                SpellAbility sourceSA = (SpellAbility)si.getTriggeringObject(AbilityKey.SourceSA);
                CardView sourceCardView = null;
                if (sourceSA != null) {
                    sourceCardView = sourceSA.getHostCard().getView();
                    ++numSmallImages;
                }
                List<GameEntityView> targets = this.getTargets(si, new ArrayList<GameEntityView>());
                numSmallImages += targets.size();
                if (enchantedEntityView != null) {
                    this.addSmallImageToStackModalPanel(enchantedEntityView, mainPanel, numSmallImages);
                }
                if (sourceCardView != null) {
                    this.addSmallImageToStackModalPanel(sourceCardView, mainPanel, numSmallImages);
                }
                for (GameEntityView gev : targets) {
                    this.addSmallImageToStackModalPanel(gev, mainPanel, numSmallImages);
                }
                FOptionPane.showOptionDialog(null, "Forge", null, mainPanel, ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0])));
            }
            ++this.nextNotifiableStackIndex;
        } else {
            Runnable tryAgainThread = () -> this.notifyStackAddition(event);
            GuiBase.getInterface().invokeInEdtLater(tryAgainThread);
        }
    }

    private List<GameEntityView> getTargets(SpellAbilityStackInstance si, List<GameEntityView> result) {
        if (si == null) {
            return result;
        }
        TrackableCollection<CardView> targetCards = CardView.getCollection(si.getTargetChoices().getTargetCards());
        for (CardView currCardView : targetCards) {
            result.add(currCardView);
        }
        for (SpellAbility currSA : si.getTargetChoices().getTargetSpells()) {
            CardView currCardView = currSA.getCardView();
            result.add(currCardView);
        }
        TrackableCollection<PlayerView> targetPlayers = PlayerView.getCollection(si.getTargetChoices().getTargetPlayers());
        for (PlayerView currPlayerView : targetPlayers) {
            result.add(currPlayerView);
        }
        return this.getTargets(si.getSubInstance(), result);
    }

    private void addBigImageToStackModalPanel(JPanel mainPanel, SpellAbilityStackInstance si) {
        StackItemView siv = si.getView();
        int rotation = this.getRotation(si.getCardView());
        FImagePanel imagePanel = new FImagePanel();
        BufferedImage bufferedImage = FImageUtil.getImage(siv.getSourceCard().getCurrentState());
        imagePanel.setImage(bufferedImage, rotation, FImagePanel.AutoSizeImageMode.SOURCE);
        int imageWidth = 433;
        int imageHeight = 600;
        Dimension imagePanelDimension = new Dimension(imageWidth, imageHeight);
        imagePanel.setMinimumSize(imagePanelDimension);
        mainPanel.add((Component)imagePanel, "cell 0 0, spany 3");
    }

    private void addTextToStackModalPanel(JPanel mainPanel, SpellAbility sa, SpellAbilityStackInstance si) {
        String who = sa.getActivatingPlayer().getName();
        String action = sa.isSpell() ? " cast " : (sa.isTrigger() ? " triggered " : " activated ");
        String what = sa.getStackDescription().startsWith("Morph ") ? "Morph" : sa.getHostCard().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(who).append(action).append(what);
        if (sa.getTargetRestrictions() != null) {
            sb.append(" targeting ");
            TargetChoices targets = si.getTargetChoices();
            sb.append(targets);
        }
        sb.append(".");
        String message1 = sb.toString();
        String message2 = si.getStackDescription();
        String messageTotal = message1 + "\n\n" + message2;
        FTextArea prompt1 = new FTextArea(messageTotal);
        prompt1.setFont(FSkin.getFont(21));
        prompt1.setAutoSize(true);
        prompt1.setMinimumSize(new Dimension(475, 200));
        mainPanel.add((Component)prompt1, "cell 1 0, aligny top");
    }

    private void addSmallImageToStackModalPanel(GameEntityView gameEntityView, JPanel mainPanel, int numTarget) {
        if (gameEntityView instanceof CardView) {
            CardView cardView = (CardView)gameEntityView;
            int currRotation = this.getRotation(cardView);
            FImagePanel targetPanel = new FImagePanel();
            BufferedImage bufferedImage = FImageUtil.getImage(cardView.getCurrentState());
            targetPanel.setImage(bufferedImage, currRotation, FImagePanel.AutoSizeImageMode.SOURCE);
            int imageWidth = 217;
            int imageHeight = 300;
            Dimension targetPanelDimension = new Dimension(imageWidth, imageHeight);
            targetPanel.setMinimumSize(targetPanelDimension);
            mainPanel.add((Component)targetPanel, "cell 1 1, split " + numTarget + ",  aligny bottom");
        } else if (gameEntityView instanceof PlayerView) {
            PlayerView playerView = (PlayerView)gameEntityView;
            FSkin.SkinImage playerAvatar = this.getPlayerAvatar(playerView, 0);
            FLabel lblIcon = new FLabel.Builder().icon(playerAvatar).build();
            Dimension dimension = playerAvatar.getSizeForPaint(JOptionPane.getRootFrame().getGraphics());
            mainPanel.add((Component)lblIcon, "cell 1 1, split " + numTarget + ", w " + dimension.getWidth() + ", h " + dimension.getHeight() + ", aligny bottom");
        }
    }

    private int getRotation(CardView cardView) {
        int rotation;
        if (cardView.isSplitCard()) {
            PaperCard pc;
            boolean hasKeywordAftermath;
            String cardName = cardView.getName();
            if (cardName.isEmpty()) {
                cardName = cardView.getAlternateState().getName();
            }
            boolean bl = hasKeywordAftermath = (pc = StaticData.instance().getCommonCards().getCard(cardName)) != null && Card.getCardForUi(pc).hasKeyword(Keyword.AFTERMATH);
            rotation = cardView.isFaceDown() ? 0 : (hasKeywordAftermath ? (CardStateName.LeftSplit.equals((Object)cardView.getState(false).getState()) ? 0 : 270) : 90);
        } else {
            CardView.CardStateView cardStateView = cardView.getState(false);
            rotation = cardStateView.isPlane() || cardStateView.isPhenomenon() ? 90 : 0;
        }
        return rotation;
    }

    @Override
    public void notifyStackRemoval(GameEventSpellRemovedFromStack event) {
        --this.nextNotifiableStackIndex;
    }

    @Override
    public void handleLandPlayed(Card land) {
        Runnable createPopupThread = () -> this.createLandPopupPanel(land);
        GuiBase.getInterface().invokeInEdtAndWait(createPopupThread);
    }

    private void createLandPopupPanel(Card land) {
        String landPlayedNotificationPolicy = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LAND_PLAYED_NOTIFICATION_POLICY);
        Player cardController = land.getController();
        boolean isAi = cardController.isAI();
        if ("Always".equals(landPlayedNotificationPolicy) || "Lands entering a battlefield because of an action of a AI player".equals(landPlayedNotificationPolicy) && isAi || "Always, but only for nonbasic lands".equals(landPlayedNotificationPolicy) && !land.isBasicLand() || "Nonbasic lands entering a battlefield because of an action of a AI player".equals(landPlayedNotificationPolicy) && !land.isBasicLand() && isAi) {
            String title = "Forge";
            ImmutableList<String> options = ImmutableList.of(Localizer.getInstance().getMessage("lblOK", new Object[0]));
            MigLayout migLayout = new MigLayout("insets 15, left, gap 30, fill");
            JPanel mainPanel = new JPanel(migLayout);
            Dimension parentSize = JOptionPane.getRootFrame().getSize();
            Dimension maxSize = new Dimension(1400, parentSize.height - 100);
            mainPanel.setMaximumSize(maxSize);
            mainPanel.setOpaque(false);
            int rotation = this.getRotation(land.getView());
            FImagePanel imagePanel = new FImagePanel();
            BufferedImage bufferedImage = FImageUtil.getImage(land.getCurrentState().getView());
            imagePanel.setImage(bufferedImage, rotation, FImagePanel.AutoSizeImageMode.SOURCE);
            int imageWidth = 433;
            int imageHeight = 600;
            Dimension imagePanelDimension = new Dimension(imageWidth, imageHeight);
            imagePanel.setMinimumSize(imagePanelDimension);
            mainPanel.add((Component)imagePanel, "cell 0 0, spany 3");
            String msg = cardController.toString() + " puts " + land.toString() + " into play into " + ZoneType.Battlefield.toString() + ".";
            FTextArea prompt1 = new FTextArea(msg);
            prompt1.setFont(FSkin.getFont(21));
            prompt1.setAutoSize(true);
            prompt1.setMinimumSize(new Dimension(475, 200));
            mainPanel.add((Component)prompt1, "cell 1 0, aligny top");
            FOptionPane.showOptionDialog(null, title, null, mainPanel, options);
        }
    }
}

