/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.settings;

import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.VHomeUI;
import forge.screens.home.settings.CSubmenuReleaseNotes;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuReleaseNotes implements IVSubmenu<CSubmenuReleaseNotes>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("ReleaseNotes", new Object[0]));
    private final JPanel pnlMain = new JPanel();
    private FSkin.SkinnedTextArea tar;
    private final FScrollPane scroller;

    private VSubmenuReleaseNotes() {
        this.pnlMain.setOpaque(false);
        this.pnlMain.setLayout(new MigLayout("insets 0, gap 0, wrap 2"));
        this.tar = new FSkin.SkinnedTextArea();
        this.tar.setOpaque(true);
        this.tar.setLineWrap(true);
        this.tar.setWrapStyleWord(true);
        this.tar.setEditable(false);
        this.tar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tar.setFont(FSkin.getRelativeFixedFont(16));
        this.tar.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.tar.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.scroller = new FScrollPane(this.tar, true);
        this.pnlMain.add((Component)this.scroller, "w 100%!, h 100%!");
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlMain, "w 98%!, h 98%!, gap 1% 0 1% 0");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.SETTINGS;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("ReleaseNotes", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_RELEASE_NOTES;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_RELEASE_NOTES;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuReleaseNotes getLayoutControl() {
        return CSubmenuReleaseNotes.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    public void setReleaseNotesContent(String content) {
        this.tar.setText(content);
        this.setScrollbarToTop();
    }

    private void setScrollbarToTop() {
        SwingUtilities.invokeLater(() -> this.scroller.getVerticalScrollBar().setValue(0));
    }
}

