/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.settings;

import forge.StaticData;
import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.VHomeUI;
import forge.screens.home.settings.CSubmenuDownloaders;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.RuntimeVersion;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.tuple.Pair;

public enum VSubmenuDownloaders implements IVSubmenu<CSubmenuDownloaders>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab("Utilities");
    private final JPanel pnlContent = new JPanel(new MigLayout("insets 0, gap 0, wrap, ay center"));
    private final FScrollPane scrContent = new FScrollPane(this.pnlContent, false);
    private final FLabel btnCheckForUpdates = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnCheckForUpdates", new Object[0]));
    private final FLabel btnDownloadSetPics = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadSetPics", new Object[0]));
    private final FLabel btnDownloadPics = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadPics", new Object[0]));
    private final FLabel btnDownloadPicsHQ = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadPicsHQ", new Object[0]));
    private final FLabel btnDownloadQuestImages = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadQuestImages", new Object[0]));
    private final FLabel btnDownloadAchievementImages = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadAchievementImages", new Object[0]));
    private final FLabel btnReportBug = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnReportBug", new Object[0]));
    private final FLabel btnListImageData = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnListImageData", new Object[0]));
    private final FLabel btnImportPictures = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnImportPictures", new Object[0]));
    private final FLabel btnHowToPlay = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnHowToPlay", new Object[0]));
    private final FLabel btnDownloadPrices = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadPrices", new Object[0]));
    private final FLabel btnDownloadSkins = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnDownloadSkins", new Object[0]));
    private final FLabel btnLicensing = VSubmenuDownloaders._makeButton(this.localizer.getMessage("btnLicensing", new Object[0]));

    private VSubmenuDownloaders() {
        Localizer localizer = Localizer.getInstance();
        String constraintsLBL = "w 90%!, h 20px!, center, gap 0 0 3px 8px";
        String constraintsBTN = "h 30px!, w 50%!, center";
        this.pnlContent.setOpaque(false);
        if (this.javaRecentEnough()) {
            this.pnlContent.add((Component)this.btnCheckForUpdates, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblCheckForUpdates", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadPics, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadPics", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadPicsHQ, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadPicsHQ", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadSetPics, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadSetPics", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadQuestImages, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadQuestImages", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadAchievementImages, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadAchievementImages", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadPrices, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadPrices", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
            this.pnlContent.add((Component)this.btnDownloadSkins, "h 30px!, w 50%!, center");
            this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblDownloadSkins", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
        } else {
            String text = localizer.getMessage("lblYourVersionOfJavaIsTooOld", new Object[0]);
            FLabel label = new FLabel.Builder().fontAlign(0).text(text).fontStyle(1).fontSize(18).build();
            this.pnlContent.add((Component)label, "w 90%!, h 25px!, center, gap 0 0 30px 3px");
            text = localizer.getMessage("lblPleaseUpdateToTheLatestVersionOfJava", new Object[0]);
            label = new FLabel.Builder().fontAlign(0).text(text).fontStyle(1).fontSize(18).build();
            this.pnlContent.add((Component)label, "w 90%!, h 25px!, center, gap 0 0 0 36px");
            text = localizer.getMessage("lblYoureRunning", new Object[0]) + " " + System.getProperty("java.version");
            text = text + " . " + localizer.getMessage("lblYouNeedAtLeastJavaVersion", new Object[0]);
            label = new FLabel.Builder().fontAlign(0).text(text).fontStyle(1).fontSize(18).build();
            this.pnlContent.add((Component)label, "w 90%!, h 25px!, center, gap 0 0 0 36px");
        }
        this.pnlContent.add((Component)this.btnListImageData, "h 30px!, w 50%!, center");
        this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblListImageData", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
        this.pnlContent.add((Component)this.btnImportPictures, "h 30px!, w 50%!, center");
        this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblImportPictures", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
        this.pnlContent.add((Component)this.btnReportBug, "h 30px!, w 50%!, center");
        this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblReportBug", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
        this.pnlContent.add((Component)this.btnHowToPlay, "h 30px!, w 50%!, center");
        this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblHowToPlay", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
        this.pnlContent.add((Component)this.btnLicensing, "h 30px!, w 50%!, center");
        this.pnlContent.add((Component)VSubmenuDownloaders._makeLabel(localizer.getMessage("lblLicensing", new Object[0])), "w 90%!, h 20px!, center, gap 0 0 3px 8px");
    }

    private boolean javaRecentEnough() {
        RuntimeVersion javaVersion = RuntimeVersion.of(System.getProperty("java.version"));
        return javaVersion.getMajor() >= 9 || javaVersion.getMajor() >= 1 && (javaVersion.getMinor() > 8 || javaVersion.getMinor() == 8 && javaVersion.getUpdate() >= 101);
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.scrContent, "w 98%!, h 98%!, gap 1% 0 1% 0");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.SETTINGS;
    }

    public void setCheckForUpdatesCommand(UiCommand command) {
        this.btnCheckForUpdates.setCommand(command);
    }

    public void setDownloadPicsCommand(UiCommand command) {
        this.btnDownloadPics.setCommand(command);
    }

    public void setDownloadPicsHQCommand(UiCommand command) {
        this.btnDownloadPicsHQ.setCommand(command);
    }

    public void setDownloadSetPicsCommand(UiCommand command) {
        this.btnDownloadSetPics.setCommand(command);
    }

    public void setDownloadQuestImagesCommand(UiCommand command) {
        this.btnDownloadQuestImages.setCommand(command);
    }

    public void setDownloadAchievementImagesCommand(UiCommand command) {
        this.btnDownloadAchievementImages.setCommand(command);
    }

    public void setReportBugCommand(UiCommand command) {
        this.btnReportBug.setCommand(command);
    }

    public void setListImageDataCommand(UiCommand command) {
        this.btnListImageData.setCommand(command);
    }

    public void setImportPicturesCommand(UiCommand command) {
        this.btnImportPictures.setCommand(command);
    }

    public void setHowToPlayCommand(UiCommand command) {
        this.btnHowToPlay.setCommand(command);
    }

    public void setDownloadPricesCommand(UiCommand command) {
        this.btnDownloadPrices.setCommand(command);
    }

    public void setLicensingCommand(UiCommand command) {
        this.btnLicensing.setCommand(command);
    }

    public void setDownloadSkinsCommand(UiCommand command) {
        this.btnDownloadSkins.setCommand(command);
    }

    public void focusTopButton() {
        this.btnDownloadPics.requestFocusInWindow();
    }

    private void _showDialog(Component c, Runnable onShow) {
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        overlay.setLayout(new MigLayout("insets 0, gap 0, ax center, ay center"));
        FPanel p = new FPanel(new MigLayout("insets dialog, wrap, center"));
        p.setOpaque(false);
        p.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        FButton btnClose = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
        btnClose.addActionListener(arg0 -> SOverlayUtils.hideOverlay());
        p.add(c, "w 500!");
        p.add((Component)btnClose, "w 200!, h pref+12!, center, gaptop 30");
        overlay.add((Component)p, "gap 0 0 10% 10%");
        SOverlayUtils.showOverlay();
        SwingUtilities.invokeLater(() -> {
            if (null != onShow) {
                onShow.run();
            }
            btnClose.requestFocusInWindow();
        });
    }

    public void auditUpdate(FTextArea tar, FScrollPane scr) {
        StringBuffer nifSB = new StringBuffer();
        StringBuffer cniSB = new StringBuffer();
        nifSB.append("\n\n-------------------\n");
        nifSB.append("NO IMAGE FOUND LIST\n");
        nifSB.append("-------------------\n\n");
        cniSB.append("\n\n-------------------\n");
        cniSB.append("UNIMPLEMENTED CARD LIST\n");
        cniSB.append("-------------------\n\n");
        Pair<Integer, Integer> totalAudit = StaticData.instance().audit(nifSB, cniSB);
        tar.setText(nifSB.toString());
        tar.setCaretPosition(0);
        FButton btnClipboardCopy = new FButton(this.localizer.getMessage("btnCopyToClipboard", new Object[0]));
        btnClipboardCopy.addActionListener(arg0 -> {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(nifSB.toString()), null);
            SOverlayUtils.hideOverlay();
        });
        scr.getParent().add((Component)btnClipboardCopy, "w 200!, h pref+12!, center, gaptop 10");
        String labelText = "<html>Missing images: " + totalAudit.getLeft() + "<br>Unimplemented cards: " + totalAudit.getRight() + "<br>";
        FLabel statsLabel = new FLabel.Builder().text(labelText).fontSize(15).build();
        scr.getParent().add(statsLabel);
        FOverlay.SINGLETON_INSTANCE.getPanel().validate();
        FOverlay.SINGLETON_INSTANCE.getPanel().repaint();
    }

    public void showCardandImageAuditData() {
        FTextArea tar = new FTextArea("Auditing card and image data. Please wait...");
        tar.setOpaque(true);
        tar.setLineWrap(false);
        tar.setWrapStyleWord(false);
        tar.setEditable(false);
        tar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tar.setFont(FSkin.getRelativeFixedFont(12));
        tar.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        tar.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        FScrollPane scr = new FScrollPane(tar, true, 22, 32);
        this._showDialog(scr, () -> {
            this.auditUpdate(tar, scr);
            scr.getViewport().setViewPosition(new Point(0, 0));
        });
    }

    public void showLicensing() {
        String license = "<html>Forge License Information<br><br>This program is free software : you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.<br><br>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.<br><br>You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.</html>";
        FLabel licenseLabel = new FLabel.Builder().text(license).fontSize(15).build();
        this._showDialog(licenseLabel, null);
    }

    public void showHowToPlay() {
        FTextArea directions = new FTextArea(FileUtil.readFileToString(ForgeConstants.HOWTO_FILE));
        FScrollPane scr = new FScrollPane(directions, false, 22, 31);
        this._showDialog(scr, () -> scr.getViewport().setViewPosition(new Point(0, 0)));
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("ContentDownloaders", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_UTILITIES;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_UTILITIES;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuDownloaders getLayoutControl() {
        return CSubmenuDownloaders.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    private static FLabel _makeButton(String label) {
        return new FLabel.Builder().opaque().hoverable().text(label).fontSize(14).build();
    }

    private static FLabel _makeLabel(String label) {
        return new FLabel.Builder().fontAlign(0).text(label).fontStyle(2).build();
    }
}

