/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.settings;

import forge.gui.UiCommand;
import forge.gui.WrapLayout;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.VHomeUI;
import forge.screens.home.settings.CSubmenuAvatars;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuAvatars implements IVSubmenu<CSubmenuAvatars>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblAvatars", new Object[0]));
    private final JPanel pnlAvatars = new JPanel();
    private final FLabel lblAvatarHuman = new FLabel.Builder().hoverable(true).selectable(true).iconScaleFactor(0.99f).iconInBackground(true).build();
    private final FLabel lblAvatarAI = new FLabel.Builder().hoverable(true).selectable(true).iconScaleFactor(0.99f).iconInBackground(true).build();

    private VSubmenuAvatars() {
        this.populateAvatars();
    }

    public void focusHuman() {
        this.lblAvatarHuman.requestFocusInWindow();
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlAvatars, "w 98%!, h 98%!, gap 1% 0 1% 0");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.SETTINGS;
    }

    @Override
    public String getMenuTitle() {
        return Localizer.getInstance().getMessage("lblAvatars", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_AVATARS;
    }

    private void populateAvatars() {
        Map<Integer, FSkin.SkinImage> avatarMap = FSkin.getAvatars();
        JPanel pnlAvatarPics = new JPanel(new WrapLayout());
        JPanel pnlAvatarUsers = new JPanel(new MigLayout("insets 0, gap 0, align center"));
        this.pnlAvatars.setOpaque(false);
        pnlAvatarUsers.setOpaque(false);
        pnlAvatarPics.setOpaque(false);
        pnlAvatarUsers.add((Component)new FLabel.Builder().fontSize(12).text("Human").build(), "w 100px!, h 20px!, gap 0 20px 0 0");
        pnlAvatarUsers.add((Component)new FLabel.Builder().fontSize(12).text("AI").build(), "w 100px!, h 20px!, wrap");
        pnlAvatarUsers.add((Component)this.lblAvatarHuman, "w 100px!, h 100px!, gap 0 20px 0 0");
        pnlAvatarUsers.add((Component)this.lblAvatarAI, "w 100px!, h 100px!");
        for (Integer i : avatarMap.keySet()) {
            pnlAvatarPics.add(this.makeAvatarLabel(avatarMap.get(i), i));
        }
        this.pnlAvatars.removeAll();
        this.pnlAvatars.setLayout(new MigLayout("insets 0, gap 0"));
        this.pnlAvatars.add((Component)pnlAvatarUsers, "w 90%!, h 150px!, wrap");
        FScrollPane scroller = new FScrollPane(pnlAvatarPics, true);
        scroller.setHorizontalScrollBarPolicy(31);
        this.pnlAvatars.add((Component)scroller, "w 90%!, pushy, growy, gap 5% 0 0 0");
        UiCommand cmdHuman = () -> {
            this.lblAvatarAI.setSelected(false);
            this.lblAvatarHuman.requestFocusInWindow();
        };
        UiCommand cmdAI = () -> {
            this.lblAvatarHuman.setSelected(false);
            this.lblAvatarAI.requestFocusInWindow();
        };
        this.lblAvatarHuman.setCommand(cmdHuman);
        this.lblAvatarAI.setCommand(cmdAI);
        this.lblAvatarHuman.setSelected(true);
        String[] indexes = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        int humanIndex = Integer.parseInt(indexes[0]);
        int aiIndex = Integer.parseInt(indexes[1]);
        if (humanIndex >= FSkin.getAvatars().size()) {
            humanIndex = 0;
        }
        if (aiIndex >= FSkin.getAvatars().size()) {
            aiIndex = 0;
        }
        this.lblAvatarAI.setIcon(FSkin.getAvatars().get(aiIndex));
        this.lblAvatarHuman.setIcon(FSkin.getAvatars().get(humanIndex));
        FModel.getPreferences().setPref(ForgePreferences.FPref.UI_AVATARS, humanIndex + "," + aiIndex);
        FModel.getPreferences().save();
    }

    private FLabel makeAvatarLabel(FSkin.SkinImage img0, int index0) {
        FLabel lbl = new FLabel.Builder().icon(img0).iconScaleFactor(1.0).iconInBackground(true).hoverable(true).build();
        Dimension size = new Dimension(100, 100);
        lbl.setPreferredSize(size);
        lbl.setMaximumSize(size);
        lbl.setMinimumSize(size);
        UiCommand cmd = () -> {
            String[] indices = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
            if (this.lblAvatarAI.isSelected()) {
                this.lblAvatarAI.setIcon(FSkin.getAvatars().get(index0));
                this.lblAvatarAI.repaintSelf();
                indices[1] = String.valueOf(index0);
            } else {
                this.lblAvatarHuman.setIcon(FSkin.getAvatars().get(index0));
                this.lblAvatarHuman.repaintSelf();
                indices[0] = String.valueOf(index0);
            }
            FModel.getPreferences().setPref(ForgePreferences.FPref.UI_AVATARS, indices[0] + "," + indices[1]);
            FModel.getPreferences().save();
        };
        lbl.setCommand(cmd);
        return lbl;
    }

    public void refreshAvatarFromPrefs(int playerIndex) {
        FLabel avatar = playerIndex == 0 ? this.lblAvatarHuman : this.lblAvatarAI;
        String[] currentPrefs = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_AVATARS).split(",");
        int avatarIndex = Integer.parseInt(currentPrefs[playerIndex]);
        avatar.setIcon(FSkin.getAvatars().get(avatarIndex));
        avatar.repaintSelf();
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_AVATARS;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuAvatars getLayoutControl() {
        return CSubmenuAvatars.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }
}

