/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.settings;

import forge.game.card.CardView;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.item.IPaperCard;
import forge.localinstance.achievements.Achievement;
import forge.localinstance.achievements.AchievementCollection;
import forge.localinstance.skin.FSkinProp;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.VHomeUI;
import forge.screens.home.settings.CSubmenuAchievements;
import forge.toolbox.FComboBox;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.special.CardZoomer;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuAchievements implements IVSubmenu<CSubmenuAchievements>
{
    SINGLETON_INSTANCE;

    private static final int MIN_SHELVES = 3;
    private static final int TROPHIES_PER_SHELVE = 4;
    private static final int PADDING = 5;
    private static final int TROPHY_PADDING = 45;
    private static final FSkin.SkinFont NAME_FONT;
    private static final FSkin.SkinFont DESC_FONT;
    private static final FSkin.SkinColor TEXT_COLOR;
    private static final FSkin.SkinColor NOT_EARNED_COLOR;
    private static final FSkin.SkinColor TEXTURE_OVERLAY_COLOR;
    private static final FSkin.SkinColor BORDER_COLOR;
    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblAchievements", new Object[0]));
    private final FLabel lblTitle = new FLabel.Builder().text(this.localizer.getMessage("lblAchievements", new Object[0])).fontAlign(0).opaque(true).fontSize(16).build();
    private final FComboBox<AchievementCollection> cbCollections = new FComboBox();
    private final TrophyCase trophyCase = new TrophyCase();
    private final FScrollPane scroller = new FScrollPane(this.trophyCase, false, 20, 31);

    private VSubmenuAchievements() {
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.trophyCase.setMinimumSize(new Dimension(FSkinProp.IMG_TROPHY_SHELF.getWidth(), 0));
        this.trophyCase.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                VSubmenuAchievements.this.trophyCase.setSelectedAchievement(VSubmenuAchievements.this.getAchievementAt(e.getX(), e.getY()));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.trophyCase.addMouseListener(new FMouseAdapter(){
            private boolean preventMouseOut;

            @Override
            public void onMiddleMouseDown(MouseEvent e) {
                this.showCard(e);
            }

            @Override
            public void onMiddleMouseUp(MouseEvent e) {
                CardZoomer.SINGLETON_INSTANCE.closeZoomer();
            }

            @Override
            public void onLeftDoubleClick(MouseEvent e) {
                this.showCard(e);
            }

            private void showCard(MouseEvent e) {
                IPaperCard pc;
                Achievement achievement = VSubmenuAchievements.this.getAchievementAt(e.getX(), e.getY());
                if (achievement != null && (pc = achievement.getPaperCard()) != null) {
                    this.preventMouseOut = true;
                    CardZoomer.SINGLETON_INSTANCE.setCard(CardView.getCardForUi(pc).getCurrentState(), true);
                }
            }

            @Override
            public void onMouseExit(MouseEvent e) {
                if (this.preventMouseOut) {
                    this.preventMouseOut = false;
                    return;
                }
                VSubmenuAchievements.this.trophyCase.setSelectedAchievement(null);
            }
        });
        AchievementCollection.buildComboBox(this.cbCollections);
        this.cbCollections.setSkinFont(FSkin.getRelativeBoldFont(14));
        this.cbCollections.setTextAlignment(FComboBox.TextAlignment.CENTER);
        this.cbCollections.addActionListener(e -> this.setAchievements(this.cbCollections.getSelectedItem()));
        this.cbCollections.setSelectedIndex(0);
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        String width = "w " + (this.trophyCase.getMinimumSize().width + 20) + "px!";
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 10, gap 10, wrap"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "pushx, growx, h 30px!");
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new MigLayout("insets 0, gap 5, wrap, align center"));
        panel.add(this.cbCollections, width + ", h 30px!");
        panel.add((Component)this.scroller, width + ", pushy, growy");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)panel, "push, grow");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.SETTINGS;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblAchievements", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_ACHIEVEMENTS;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_ACHIEVEMENTS;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuAchievements getLayoutControl() {
        return CSubmenuAchievements.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    private void setAchievements(AchievementCollection achievements0) {
        this.trophyCase.achievements = achievements0;
        this.trophyCase.shelfCount = (int)Math.ceil((double)achievements0.getCount() / 4.0);
        if (this.trophyCase.shelfCount < 3) {
            this.trophyCase.shelfCount = 3;
        }
        this.trophyCase.setMinimumSize(new Dimension(this.trophyCase.getMinimumSize().width, FSkinProp.IMG_TROPHY_CASE_TOP.getHeight() + this.trophyCase.shelfCount * FSkinProp.IMG_TROPHY_SHELF.getHeight()));
        this.trophyCase.setPreferredSize(this.trophyCase.getMinimumSize());
        this.scroller.revalidate();
        this.scroller.repaint();
    }

    private Achievement getAchievementAt(float x0, float y0) {
        float w = this.scroller.getWidth();
        float shelfHeight = FSkinProp.IMG_TROPHY_SHELF.getHeight();
        float trophyWidth = FSkinProp.IMG_COMMON_TROPHY.getWidth() + 45;
        float x = (w - 4.0f * trophyWidth) / 2.0f;
        float y = FSkinProp.IMG_TROPHY_CASE_TOP.getHeight();
        int trophyCount = 0;
        float startX = x;
        for (Achievement achievement : this.trophyCase.achievements) {
            if (trophyCount == 4) {
                trophyCount = 0;
                x = startX;
                y += shelfHeight;
            }
            if (x <= x0 && x0 < x + trophyWidth && y <= y0 && y0 < y + shelfHeight) {
                return achievement;
            }
            ++trophyCount;
            x += trophyWidth;
        }
        return null;
    }

    static {
        NAME_FONT = FSkin.getRelativeBoldFont(14);
        DESC_FONT = FSkin.getFont();
        TEXT_COLOR = FSkin.getColor(FSkin.Colors.CLR_TEXT);
        NOT_EARNED_COLOR = TEXT_COLOR.alphaColor(128);
        TEXTURE_OVERLAY_COLOR = FSkin.getColor(FSkin.Colors.CLR_THEME);
        BORDER_COLOR = FSkin.getColor(FSkin.Colors.CLR_BORDERS);
    }

    private static class TrophyCase
    extends JPanel {
        private static final FSkin.SkinImage imgTop = FSkin.getImage(FSkinProp.IMG_TROPHY_CASE_TOP);
        private static final FSkin.SkinImage imgShelf = FSkin.getImage(FSkinProp.IMG_TROPHY_SHELF);
        private static final FSkin.SkinImage imgTrophyPlate = FSkin.getImage(FSkinProp.IMG_TROPHY_PLATE);
        private static final Font font = FSkin.getRelativeFixedFont(14).deriveFont(1);
        private static final Font subFont = FSkin.getFixedFont();
        private static final Color foreColor = new Color(239, 220, 144);
        private AchievementCollection achievements;
        private int shelfCount;
        private Achievement selectedAchievement;

        private TrophyCase() {
        }

        private void setSelectedAchievement(Achievement selectedAchievement0) {
            if (this.selectedAchievement == selectedAchievement0) {
                return;
            }
            this.selectedAchievement = selectedAchievement0;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g2) {
            FontMetrics fm;
            Graphics2D g2d = (Graphics2D)g2.create();
            Dimension imgTopSize = imgTop.getSizeForPaint(g2d);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHints(hints);
            int x = 0;
            int y = 0;
            int w = imgTopSize.width;
            int h2 = imgTopSize.height;
            FSkin.drawImage(g2d, imgTop, x, y, w, h2);
            y += h2;
            Dimension imgShelfSize = imgShelf.getSizeForPaint(g2d);
            h2 = imgShelfSize.height;
            for (int i = 0; i < this.shelfCount; ++i) {
                FSkin.drawImage(g2d, imgShelf, x, y, w, h2);
                y += h2;
            }
            int trophyImageWidth = FSkinProp.IMG_COMMON_TROPHY.getWidth();
            int trophyWidth = trophyImageWidth + 45;
            int trophyHeight = FSkinProp.IMG_COMMON_TROPHY.getHeight();
            Dimension trophyPlateSize = imgTrophyPlate.getSizeForPaint(g2d);
            int plateY = imgTopSize.height + h2 - trophyPlateSize.height;
            y = plateY - trophyHeight;
            int trophyCount = 0;
            int startX = x += (w - 4 * trophyWidth) / 2;
            int dy = h2;
            w = trophyWidth;
            h2 = trophyHeight;
            int plateOffset = (w - trophyPlateSize.width) / 2;
            Rectangle selectRect = null;
            for (Achievement achievement : this.achievements) {
                if (trophyCount == 4) {
                    trophyCount = 0;
                    y += dy;
                    plateY += dy;
                    x = startX;
                }
                FSkin.drawImage(g2d, (FSkin.SkinImage)achievement.getImage(), x + 22, y, trophyImageWidth, h2);
                FSkin.drawImage(g2d, imgTrophyPlate, x + plateOffset, plateY, trophyPlateSize.width, trophyPlateSize.height);
                g2d.setColor(foreColor);
                g2d.setFont(font);
                fm = g2d.getFontMetrics();
                String label = achievement.getDisplayName();
                int textY = plateY + (trophyPlateSize.height * 2 / 3 - fm.getHeight()) / 2 + fm.getAscent();
                g2d.drawString(label, x + plateOffset + (trophyPlateSize.width - fm.stringWidth(label)) / 2, textY);
                label = achievement.getSubTitle(false);
                if (label != null) {
                    textY += fm.getAscent();
                    g2d.setFont(subFont);
                    fm = g2d.getFontMetrics();
                    g2d.drawString(label, x + plateOffset + (trophyPlateSize.width - fm.stringWidth(label)) / 2, textY);
                }
                if (achievement == this.selectedAchievement) {
                    g2d.setColor(Color.GREEN);
                    int arcSize = w / 10;
                    int selY = y - imgShelfSize.height + trophyHeight + trophyPlateSize.height;
                    g2d.drawRoundRect(x, selY, w, imgShelfSize.height, arcSize, arcSize);
                    selectRect = new Rectangle(x, selY, w, imgShelfSize.height);
                }
                ++trophyCount;
                x += w;
            }
            if (selectRect != null) {
                String subTitle = this.selectedAchievement.getSubTitle(true);
                String sharedDesc = this.selectedAchievement.getSharedDesc();
                String mythicDesc = this.selectedAchievement.getMythicDesc();
                String rareDesc = this.selectedAchievement.getRareDesc();
                String uncommonDesc = this.selectedAchievement.getUncommonDesc();
                String commonDesc = this.selectedAchievement.getCommonDesc();
                int nameHeight = NAME_FONT.getFontMetrics().getHeight();
                int descHeight = DESC_FONT.getFontMetrics().getHeight();
                w = imgShelfSize.width - 10 - 1;
                h2 = nameHeight + 12;
                if (subTitle != null) {
                    h2 += descHeight;
                }
                if (sharedDesc != null) {
                    h2 += descHeight;
                }
                if (mythicDesc != null) {
                    h2 += descHeight;
                }
                if (rareDesc != null) {
                    h2 += descHeight;
                }
                if (uncommonDesc != null) {
                    h2 += descHeight;
                }
                if (commonDesc != null) {
                    h2 += descHeight;
                }
                x = 5;
                y = selectRect.y + selectRect.height + 5;
                FScrollPane scroller = (FScrollPane)this.getParent().getParent();
                if (y + h2 - scroller.getVerticalScrollBar().getValue() > scroller.getHeight()) {
                    y = selectRect.y - 5 > h2 ? selectRect.y - h2 - 5 : this.getHeight() - h2;
                }
                FSkin.drawImage(g2d, FSkin.getImage(FSkinProp.BG_TEXTURE), x, y, w, h2);
                FSkin.setGraphicsColor(g2d, TEXTURE_OVERLAY_COLOR);
                g2d.fillRect(x, y, w, h2);
                FSkin.setGraphicsColor(g2d, BORDER_COLOR);
                g2d.drawRect(x, y, w, h2);
                x += 5;
                y += 5;
                w -= 10;
                h2 -= 10;
                FSkin.setGraphicsFont(g2d, NAME_FONT);
                FSkin.setGraphicsColor(g2d, TEXT_COLOR);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                fm = g2d.getFontMetrics();
                g2d.drawString(this.selectedAchievement.getDisplayName(), x, y += fm.getAscent());
                y += nameHeight;
                FSkin.setGraphicsFont(g2d, DESC_FONT);
                if (subTitle != null) {
                    g2d.drawString(subTitle, x, y);
                    y += descHeight;
                }
                y += 5;
                if (sharedDesc != null) {
                    g2d.drawString(this.selectedAchievement.isSpecial() ? sharedDesc : sharedDesc + "...", x, y);
                    y += descHeight;
                }
                if (mythicDesc != null) {
                    FSkin.setGraphicsColor(g2d, this.selectedAchievement.earnedMythic() ? TEXT_COLOR : NOT_EARNED_COLOR);
                    g2d.drawString(this.selectedAchievement.isSpecial() ? mythicDesc : "(" + Localizer.getInstance().getMessage("lblMythic", new Object[0]) + ") " + mythicDesc, x, y);
                    y += descHeight;
                }
                if (rareDesc != null) {
                    FSkin.setGraphicsColor(g2d, this.selectedAchievement.earnedRare() ? TEXT_COLOR : NOT_EARNED_COLOR);
                    g2d.drawString("(" + Localizer.getInstance().getMessage("lblRare", new Object[0]) + ") " + rareDesc, x, y);
                    y += descHeight;
                }
                if (uncommonDesc != null) {
                    FSkin.setGraphicsColor(g2d, this.selectedAchievement.earnedUncommon() ? TEXT_COLOR : NOT_EARNED_COLOR);
                    g2d.drawString("(" + Localizer.getInstance().getMessage("lblUncommon", new Object[0]) + ") " + uncommonDesc, x, y);
                    y += descHeight;
                }
                if (commonDesc != null) {
                    FSkin.setGraphicsColor(g2d, this.selectedAchievement.earnedCommon() ? TEXT_COLOR : NOT_EARNED_COLOR);
                    g2d.drawString("(" + Localizer.getInstance().getMessage("lblCommon", new Object[0]) + ") " + commonDesc, x, y);
                }
            }
            g2d.dispose();
        }
    }
}

