/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.settings;

import forge.MulliganDefs;
import forge.Singletons;
import forge.StaticData;
import forge.ai.AiProfileUtil;
import forge.control.FControl;
import forge.download.AutoUpdater;
import forge.game.GameLogEntryType;
import forge.gamemodes.net.server.FServerManager;
import forge.gui.GuiBase;
import forge.gui.UiCommand;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorTokenViewer;
import forge.screens.home.settings.VSubmenuPreferences;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.toolbox.FComboBox;
import forge.toolbox.FComboBoxPanel;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum CSubmenuPreferences implements ICDoc
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private VSubmenuPreferences view;
    private ForgePreferences prefs;
    private boolean updating;
    private final List<Pair<JCheckBox, ForgePreferences.FPref>> lstControls = new ArrayList<Pair<JCheckBox, ForgePreferences.FPref>>();

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view = VSubmenuPreferences.SINGLETON_INSTANCE;
        this.prefs = FModel.getPreferences();
        this.view.getCbDevMode().addItemListener(arg0 -> {
            if (this.updating) {
                return;
            }
            if (FServerManager.getInstance().isMatchActive()) {
                System.out.println(this.localizer.getMessage("CantChangeDevModeWhileNetworkMath", new Object[0]));
                return;
            }
            boolean toggle = this.view.getCbDevMode().isSelected();
            this.prefs.setPref(ForgePreferences.FPref.DEV_MODE_ENABLED, String.valueOf(toggle));
            ForgePreferences.DEV_MODE = toggle;
            this.prefs.save();
        });
        this.view.getCbEnableMusic().addItemListener(arg0 -> {
            if (this.updating) {
                return;
            }
            boolean toggle = this.view.getCbEnableMusic().isSelected();
            this.prefs.setPref(ForgePreferences.FPref.UI_ENABLE_MUSIC, String.valueOf(toggle));
            this.prefs.save();
            SoundSystem.instance.changeBackgroundTrack();
        });
        this.view.getCbUseExperimentalNetworkStream().addItemListener(arg0 -> {
            if (this.updating) {
                return;
            }
            boolean toggle = this.view.getCbUseExperimentalNetworkStream().isSelected();
            GuiBase.enablePropertyConfig(toggle);
            this.prefs.setPref(ForgePreferences.FPref.UI_NETPLAY_COMPAT, String.valueOf(toggle));
            this.prefs.save();
        });
        this.lstControls.clear();
        this.lstControls.add(Pair.of(this.view.getCbAnte(), ForgePreferences.FPref.UI_ANTE));
        this.lstControls.add(Pair.of(this.view.getCbAnteMatchRarity(), ForgePreferences.FPref.UI_ANTE_MATCH_RARITY));
        this.lstControls.add(Pair.of(this.view.getCbManaBurn(), ForgePreferences.FPref.UI_MANABURN));
        this.lstControls.add(Pair.of(this.view.getCbScaleLarger(), ForgePreferences.FPref.UI_SCALE_LARGER));
        this.lstControls.add(Pair.of(this.view.getCbRenderBlackCardBorders(), ForgePreferences.FPref.UI_RENDER_BLACK_BORDERS));
        this.lstControls.add(Pair.of(this.view.getCbLargeCardViewers(), ForgePreferences.FPref.UI_LARGE_CARD_VIEWERS));
        this.lstControls.add(Pair.of(this.view.getCbSmallDeckViewer(), ForgePreferences.FPref.UI_SMALL_DECK_VIEWER));
        this.lstControls.add(Pair.of(this.view.getCbRandomArtInPools(), ForgePreferences.FPref.UI_RANDOM_ART_IN_POOLS));
        this.lstControls.add(Pair.of(this.view.getCbEnforceDeckLegality(), ForgePreferences.FPref.ENFORCE_DECK_LEGALITY));
        this.lstControls.add(Pair.of(this.view.getCbPerformanceMode(), ForgePreferences.FPref.PERFORMANCE_MODE));
        this.lstControls.add(Pair.of(this.view.getCbExperimentalRestore(), ForgePreferences.FPref.MATCH_EXPERIMENTAL_RESTORE));
        this.lstControls.add(Pair.of(this.view.getCbFilteredHands(), ForgePreferences.FPref.FILTERED_HANDS));
        this.lstControls.add(Pair.of(this.view.getCbCloneImgSource(), ForgePreferences.FPref.UI_CLONE_MODE_SOURCE));
        this.lstControls.add(Pair.of(this.view.getCbRemoveSmall(), ForgePreferences.FPref.DECKGEN_NOSMALL));
        this.lstControls.add(Pair.of(this.view.getCbCardBased(), ForgePreferences.FPref.DECKGEN_CARDBASED));
        this.lstControls.add(Pair.of(this.view.getCbRemoveArtifacts(), ForgePreferences.FPref.DECKGEN_ARTIFACTS));
        this.lstControls.add(Pair.of(this.view.getCbSingletons(), ForgePreferences.FPref.DECKGEN_SINGLETONS));
        this.lstControls.add(Pair.of(this.view.getCbEnableAICheats(), ForgePreferences.FPref.UI_ENABLE_AI_CHEATS));
        this.lstControls.add(Pair.of(this.view.getCbEnableUnknownCards(), ForgePreferences.FPref.UI_LOAD_UNKNOWN_CARDS));
        this.lstControls.add(Pair.of(this.view.getCbEnableNonLegalCards(), ForgePreferences.FPref.UI_LOAD_NONLEGAL_CARDS));
        this.lstControls.add(Pair.of(this.view.getCbAllowCustomCardsDeckConformance(), ForgePreferences.FPref.ALLOW_CUSTOM_CARDS_IN_DECKS_CONFORMANCE));
        this.lstControls.add(Pair.of(this.view.getCbUseExperimentalNetworkStream(), ForgePreferences.FPref.UI_NETPLAY_COMPAT));
        this.lstControls.add(Pair.of(this.view.getCbImageFetcher(), ForgePreferences.FPref.UI_ENABLE_ONLINE_IMAGE_FETCHER));
        this.lstControls.add(Pair.of(this.view.getCbDisableCardImages(), ForgePreferences.FPref.UI_DISABLE_CARD_IMAGES));
        this.lstControls.add(Pair.of(this.view.getCbDisplayFoil(), ForgePreferences.FPref.UI_OVERLAY_FOIL_EFFECT));
        this.lstControls.add(Pair.of(this.view.getCbRandomFoil(), ForgePreferences.FPref.UI_RANDOM_FOIL));
        this.lstControls.add(Pair.of(this.view.getCbEnableSounds(), ForgePreferences.FPref.UI_ENABLE_SOUNDS));
        this.lstControls.add(Pair.of(this.view.getCbAltSoundSystem(), ForgePreferences.FPref.UI_ALT_SOUND_SYSTEM));
        this.lstControls.add(Pair.of(this.view.getCbSROptimize(), ForgePreferences.FPref.UI_SR_OPTIMIZE));
        this.lstControls.add(Pair.of(this.view.getCbUiForTouchScreen(), ForgePreferences.FPref.UI_FOR_TOUCHSCREN));
        this.lstControls.add(Pair.of(this.view.getCbTimedTargOverlay(), ForgePreferences.FPref.UI_TIMED_TARGETING_OVERLAY_UPDATES));
        this.lstControls.add(Pair.of(this.view.getCbCompactMainMenu(), ForgePreferences.FPref.UI_COMPACT_MAIN_MENU));
        this.lstControls.add(Pair.of(this.view.getCbUseSentry(), ForgePreferences.FPref.USE_SENTRY));
        this.lstControls.add(Pair.of(this.view.getCbPromptFreeBlocks(), ForgePreferences.FPref.MATCHPREF_PROMPT_FREE_BLOCKS));
        this.lstControls.add(Pair.of(this.view.getCbPauseWhileMinimized(), ForgePreferences.FPref.UI_PAUSE_WHILE_MINIMIZED));
        this.lstControls.add(Pair.of(this.view.getCbWorkshopSyntax(), ForgePreferences.FPref.DEV_WORKSHOP_SYNTAX));
        this.lstControls.add(Pair.of(this.view.getCbCompactPrompt(), ForgePreferences.FPref.UI_COMPACT_PROMPT));
        this.lstControls.add(Pair.of(this.view.getCbHideReminderText(), ForgePreferences.FPref.UI_HIDE_REMINDER_TEXT));
        this.lstControls.add(Pair.of(this.view.getCbCardTextUseSansSerif(), ForgePreferences.FPref.UI_CARD_IMAGE_RENDER_USE_SANS_SERIF_FONT));
        this.lstControls.add(Pair.of(this.view.getCbCardTextHideReminder(), ForgePreferences.FPref.UI_CARD_IMAGE_RENDER_HIDE_REMINDER_TEXT));
        this.lstControls.add(Pair.of(this.view.getCbOpenPacksIndiv(), ForgePreferences.FPref.UI_OPEN_PACKS_INDIV));
        this.lstControls.add(Pair.of(this.view.getCbTokensInSeparateRow(), ForgePreferences.FPref.UI_TOKENS_IN_SEPARATE_ROW));
        this.lstControls.add(Pair.of(this.view.getCbStackCreatures(), ForgePreferences.FPref.UI_STACK_CREATURES));
        this.lstControls.add(Pair.of(this.view.getCbManaLostPrompt(), ForgePreferences.FPref.UI_MANA_LOST_PROMPT));
        this.lstControls.add(Pair.of(this.view.getCbEscapeEndsTurn(), ForgePreferences.FPref.UI_ALLOW_ESC_TO_END_TURN));
        this.lstControls.add(Pair.of(this.view.getCbDetailedPaymentDesc(), ForgePreferences.FPref.UI_DETAILED_SPELLDESC_IN_PROMPT));
        this.lstControls.add(Pair.of(this.view.getCbGrayText(), ForgePreferences.FPref.UI_GRAY_INACTIVE_TEXT));
        this.lstControls.add(Pair.of(this.view.getCbPreselectPrevAbOrder(), ForgePreferences.FPref.UI_PRESELECT_PREVIOUS_ABILITY_ORDER));
        this.lstControls.add(Pair.of(this.view.getCbShowStormCount(), ForgePreferences.FPref.UI_SHOW_STORM_COUNT_IN_PROMPT));
        this.lstControls.add(Pair.of(this.view.getCbRemindOnPriority(), ForgePreferences.FPref.UI_REMIND_ON_PRIORITY));
        this.lstControls.add(Pair.of(this.view.getCbFilterLandsByColorId(), ForgePreferences.FPref.UI_FILTER_LANDS_BY_COLOR_IDENTITY));
        this.lstControls.add(Pair.of(this.view.getCbLoadCardsLazily(), ForgePreferences.FPref.LOAD_CARD_SCRIPTS_LAZILY));
        this.lstControls.add(Pair.of(this.view.getCbLoadArchivedFormats(), ForgePreferences.FPref.LOAD_ARCHIVED_FORMATS));
        this.lstControls.add(Pair.of(this.view.getCbSmartCardArtSelectionOpt(), ForgePreferences.FPref.UI_SMART_CARD_ART));
        this.lstControls.add(Pair.of(this.view.getCbShowDraftRanking(), ForgePreferences.FPref.UI_OVERLAY_DRAFT_RANKING));
        for (Pair<JCheckBox, ForgePreferences.FPref> kv : this.lstControls) {
            kv.getKey().addItemListener(arg0 -> {
                if (this.updating) {
                    return;
                }
                this.prefs.setPref((ForgePreferences.FPref)((Object)((Object)kv.getValue())), String.valueOf(((JCheckBox)kv.getKey()).isSelected()));
                this.prefs.save();
            });
        }
        this.view.getCbSmartCardArtSelectionOpt().addItemListener(e -> {
            if (this.updating) {
                return;
            }
            boolean isEnabled = e.getStateChange() == 1;
            FModel.getMagicDb().setEnableSmartCardArtSelection(isEnabled);
        });
        this.view.getBtnReset().setCommand(this::resetForgeSettingsToDefault);
        this.view.getBtnDeleteEditorUI().setCommand(this::resetDeckEditorLayout);
        this.view.getBtnDeleteWorkshopUI().setCommand(this::resetWorkshopLayout);
        this.view.getBtnDeleteMatchUI().setCommand(this::resetMatchScreenLayout);
        this.view.getBtnUserProfileUI().setCommand(this::openUserProfileDirectory);
        this.view.getBtnClearImageCache().setCommand(this::clearImageCache);
        this.view.getBtnTokenPreviewer().setCommand(this::openTokenPreviewer);
        this.view.getBtnResetJavaFutureCompatibilityWarnings().setCommand(() -> {
            this.prefs.setPref(ForgePreferences.FPref.DISABLE_DISPLAY_JAVA_8_UPDATE_WARNING, false);
            this.prefs.save();
            FOptionPane.showMessageDialog(this.localizer.getMessage("CompatibilityWarningsReEnabled", new Object[0]));
        });
        this.view.getBtnContentDirectoryUI().setCommand(this::openContentDirectory);
        this.initializeGameLogVerbosityComboBox();
        this.initializeCloseActionComboBox();
        this.initializeDefaultFontSizeComboBox();
        this.initializeCardArtFormatComboBox();
        this.initializeCardArtPreference();
        this.initializeAutoUpdaterComboBox();
        this.initializeMulliganRuleComboBox();
        this.initializeAiProfilesComboBox();
        this.initializeAiSideboardingModeComboBox();
        this.initializeSoundSetsComboBox();
        this.initializeMusicSetsComboBox();
        this.initializeStackAdditionsComboBox();
        this.initializeLandPlayedComboBox();
        this.initializeColorIdentityCombobox();
        this.initializeSwitchStatesCombobox();
        this.initializeAutoYieldModeComboBox();
        this.initializeCounterDisplayTypeComboBox();
        this.initializeCounterDisplayLocationComboBox();
        this.initializeGraveyardOrderingComboBox();
        this.initializePlayerNameButton();
        this.initializeDefaultLanguageComboBox();
        this.disableLazyLoading();
    }

    @Override
    public void update() {
        this.updating = true;
        this.view = VSubmenuPreferences.SINGLETON_INSTANCE;
        this.prefs = FModel.getPreferences();
        this.setPlayerNameButtonText();
        this.view.getCbDevMode().setSelected(ForgePreferences.DEV_MODE);
        this.view.getCbEnableMusic().setSelected(this.prefs.getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_MUSIC));
        this.view.getCbUseExperimentalNetworkStream().setSelected(this.prefs.getPrefBoolean(ForgePreferences.FPref.UI_NETPLAY_COMPAT));
        for (Pair<JCheckBox, ForgePreferences.FPref> kv : this.lstControls) {
            kv.getKey().setSelected(this.prefs.getPrefBoolean(kv.getValue()));
        }
        this.view.reloadShortcuts();
        SwingUtilities.invokeLater(() -> this.view.getCbRemoveSmall().requestFocusInWindow());
        this.updating = false;
    }

    private void resetForgeSettingsToDefault() {
        String userPrompt = this.localizer.getMessage("AresetForgeSettingsToDefault", new Object[0]);
        if (FOptionPane.showConfirmDialog(userPrompt, this.localizer.getMessage("TresetForgeSettingsToDefault", new Object[0]))) {
            ForgePreferences prefs = FModel.getPreferences();
            prefs.reset();
            prefs.save();
            this.update();
            Singletons.getControl().restartForge();
        }
    }

    private void resetDeckEditorLayout() {
        String userPrompt = this.localizer.getMessage("AresetDeckEditorLayout", new Object[0]);
        if (FOptionPane.showConfirmDialog(userPrompt, this.localizer.getMessage("TresetDeckEditorLayout", new Object[0])) && FScreen.DECK_EDITOR_CONSTRUCTED.deleteLayoutFile()) {
            FOptionPane.showMessageDialog(this.localizer.getMessage("OKresetDeckEditorLayout", new Object[0]));
        }
    }

    private void resetWorkshopLayout() {
        String userPrompt = this.localizer.getMessage("AresetWorkshopLayout", new Object[0]);
        if (FOptionPane.showConfirmDialog(userPrompt, this.localizer.getMessage("TresetWorkshopLayout", new Object[0])) && FScreen.WORKSHOP_SCREEN.deleteLayoutFile()) {
            FOptionPane.showMessageDialog(this.localizer.getMessage("OKresetWorkshopLayout", new Object[0]));
        }
    }

    private void resetMatchScreenLayout() {
        String userPrompt = this.localizer.getMessage("AresetMatchScreenLayout", new Object[0]);
        if (FOptionPane.showConfirmDialog(userPrompt, this.localizer.getMessage("TresetMatchScreenLayout", new Object[0])) && FScreen.deleteMatchLayoutFile()) {
            FOptionPane.showMessageDialog(this.localizer.getMessage("OKresetMatchScreenLayout", new Object[0]));
        }
    }

    private void openUserProfileDirectory() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(new File(ForgeConstants.USER_DIR));
            }
        }
        catch (Exception e) {
            System.out.println("Unable to open Directory: " + e.toString());
        }
    }

    private void clearImageCache() {
        try {
            GuiBase.getInterface().clearImageCache();
        }
        catch (Exception e) {
            System.out.println("Unable to clear cache: " + e.toString());
        }
    }

    private void openTokenPreviewer() {
        Singletons.getControl().setCurrentScreen(FScreen.TOKEN_VIEWER);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorTokenViewer(CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture()));
    }

    private void openContentDirectory() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(new File(ForgeConstants.CACHE_DIR));
            }
        }
        catch (Exception e) {
            System.out.println("Unable to open Directory: " + e.toString());
        }
    }

    private void initializeGameLogVerbosityComboBox() {
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.DEV_LOG_ENTRY_TYPE;
        FComboBoxPanel<GameLogEntryType> panel = this.view.getGameLogVerbosityComboBoxPanel();
        FComboBox<GameLogEntryType> comboBox = this.createComboBox(GameLogEntryType.values(), userSetting);
        GameLogEntryType selectedItem = GameLogEntryType.valueOf(this.prefs.getPref(userSetting));
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeCloseActionComboBox() {
        FComboBoxPanel<FControl.CloseAction> panel = this.view.getCloseActionComboBoxPanel();
        FComboBox<FControl.CloseAction> comboBox = new FComboBox<FControl.CloseAction>(FControl.CloseAction.values());
        comboBox.addItemListener(e -> Singletons.getControl().setCloseAction((FControl.CloseAction)((Object)((Object)comboBox.getSelectedItem()))));
        panel.setComboBox(comboBox, Singletons.getControl().getCloseAction());
    }

    private void initializeDefaultLanguageComboBox() {
        File lang_root = new File(ForgeConstants.LANG_DIR);
        File[] files = lang_root.listFiles();
        ArrayList<String> allLanguages = new ArrayList<String>();
        for (File file : files) {
            String languageName;
            if (!file.isFile() || !(languageName = file.getName()).endsWith(".properties")) continue;
            allLanguages.add(languageName.replace(".properties", ""));
        }
        String[] choices = new String[allLanguages.size()];
        allLanguages.toArray(choices);
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_LANGUAGE;
        FComboBoxPanel<String> panel = this.view.getCbpDefaultLanguageComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(choices, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeAutoUpdaterComboBox() {
        String[] updatePaths = AutoUpdater.updateChannels;
        ForgePreferences.FPref updatePreference = ForgePreferences.FPref.AUTO_UPDATE;
        FComboBoxPanel<String> panel = this.view.getCbpAutoUpdater();
        FComboBox<String> comboBox = this.createComboBox(updatePaths, updatePreference);
        String selectedItem = this.prefs.getPref(updatePreference);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeMulliganRuleComboBox() {
        String[] choices = MulliganDefs.getMulliganRuleNames();
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.MULLIGAN_RULE;
        FComboBoxPanel<String> panel = this.view.getCbpMulliganRule();
        FComboBox<String> comboBox = this.createComboBox(choices, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        comboBox.addItemListener(e -> StaticData.instance().setMulliganRule(MulliganDefs.GetRuleByName(this.prefs.getPref(ForgePreferences.FPref.MULLIGAN_RULE))));
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeDefaultFontSizeComboBox() {
        String[] choices = new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_DEFAULT_FONT_SIZE;
        FComboBoxPanel<String> panel = this.view.getCbpDefaultFontSizeComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(choices, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeCardArtFormatComboBox() {
        String[] choices = new String[]{"Full", "Crop"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_CARD_ART_FORMAT;
        FComboBoxPanel<String> panel = this.view.getCbpCardArtFormatComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(choices, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeAiProfilesComboBox() {
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_CURRENT_AI_PROFILE;
        FComboBoxPanel<String> panel = this.view.getAiProfilesComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(AiProfileUtil.getProfilesArray(), userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeAiSideboardingModeComboBox() {
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.MATCH_AI_SIDEBOARDING_MODE;
        FComboBoxPanel<String> panel = this.view.getAiSideboardingModeComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(new String[]{"Off", "AI", "Human For AI"}, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
        comboBox.addActionListener(actionEvent -> AiProfileUtil.setAiSideboardingMode(AiProfileUtil.AISideboardingMode.normalizedValueOf((String)comboBox.getSelectedItem())));
    }

    private void initializeSoundSetsComboBox() {
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_CURRENT_SOUND_SET;
        FComboBoxPanel<String> panel = this.view.getSoundSetsComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(SoundSystem.instance.getAvailableSoundSets(), userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
        comboBox.addActionListener(actionEvent -> SoundSystem.instance.invalidateSoundCache());
    }

    private void initializeMusicSetsComboBox() {
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_CURRENT_MUSIC_SET;
        FComboBoxPanel<String> panel = this.view.getMusicSetsComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(SoundSystem.instance.getAvailableMusicSets(), userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
        comboBox.addActionListener(actionEvent -> {
            MusicPlaylist.invalidateMusicPlaylist();
            SoundSystem.instance.changeBackgroundTrack();
        });
    }

    private void initializeCardArtPreference() {
        String latestOpt = Localizer.getInstance().getMessage("latestArtOpt", new Object[0]);
        String originalOpt = Localizer.getInstance().getMessage("originalArtOpt", new Object[0]);
        String[] choices = new String[]{latestOpt, originalOpt};
        ForgePreferences.FPref uiPreferredArt = ForgePreferences.FPref.UI_PREFERRED_ART;
        FComboBoxPanel<String> panel = this.view.getCbpCardArtPreference();
        FComboBox<String> comboBox = new FComboBox<String>(choices);
        comboBox.addItemListener(e -> {
            String artPreference = (String)comboBox.getSelectedItem();
            if (artPreference == null) {
                artPreference = latestOpt;
            }
            boolean latestArt = artPreference.equalsIgnoreCase(latestOpt);
            boolean coreExpFilter = FModel.getMagicDb().isCoreExpansionOnlyFilterSet();
            FModel.getMagicDb().setCardArtPreference(latestArt, coreExpFilter);
            String preferenceOpt = FModel.getMagicDb().getCardArtPreferenceName();
            this.prefs.setPref(uiPreferredArt, preferenceOpt);
            this.prefs.save();
        });
        String selectedItem = FModel.getMagicDb().cardArtPreferenceIsLatest() ? latestOpt : originalOpt;
        panel.setComboBox(comboBox, selectedItem);
        JCheckBox coreExpFilter = this.view.getCbCardArtCoreExpansionsOnlyOpt();
        boolean selected = FModel.getMagicDb().isCoreExpansionOnlyFilterSet();
        coreExpFilter.setSelected(selected);
        coreExpFilter.addItemListener(e -> {
            boolean latestArt = FModel.getMagicDb().cardArtPreferenceIsLatest();
            boolean coreExpFilter1 = e.getStateChange() == 1;
            FModel.getMagicDb().setCardArtPreference(latestArt, coreExpFilter1);
            String preferenceOpt = FModel.getMagicDb().getCardArtPreferenceName();
            this.prefs.setPref(uiPreferredArt, preferenceOpt);
            this.prefs.save();
        });
    }

    private void initializeStackAdditionsComboBox() {
        String[] elems = new String[]{"Never", "Always", "AI cast/activated, or triggered by any player"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_STACK_EFFECT_NOTIFICATION_POLICY;
        FComboBoxPanel<String> panel = this.view.getCbpStackAdditionsComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(elems, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeLandPlayedComboBox() {
        String[] elems = new String[]{"Never", "Always", "Always, but only for nonbasic lands", "Lands entering a battlefield because of an action of a AI player", "Nonbasic lands entering a battlefield because of an action of a AI player"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_LAND_PLAYED_NOTIFICATION_POLICY;
        FComboBoxPanel<String> panel = this.view.getCbpLandPlayedComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(elems, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeColorIdentityCombobox() {
        String[] elems = new String[]{"Never", "Changed", "Multicolor", "Multi+Changed", "Always"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_DISPLAY_CURRENT_COLORS;
        FComboBoxPanel<String> panel = this.view.getDisplayColorIdentity();
        FComboBox<String> comboBox = this.createComboBox(elems, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeSwitchStatesCombobox() {
        String[] elems = new String[]{"Never", "Switch back on hover", "Always"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_SWITCH_STATES_DECKVIEW;
        FComboBoxPanel<String> panel = this.view.getSwitchStates();
        FComboBox<String> comboBox = this.createComboBox(elems, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeAutoYieldModeComboBox() {
        String[] elems = new String[]{"Per Ability (Each Match)", "Per Card (Each Game)"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_AUTO_YIELD_MODE;
        FComboBoxPanel<String> panel = this.view.getAutoYieldModeComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(elems, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeGraveyardOrderingComboBox() {
        String[] elems = new String[]{"Never", "With Relevant Cards", "Always"};
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_ALLOW_ORDER_GRAVEYARD_WHEN_NEEDED;
        FComboBoxPanel<String> panel = this.view.getCbpGraveyardOrdering();
        FComboBox<String> comboBox = this.createComboBox(elems, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeCounterDisplayTypeComboBox() {
        String[] elements = new String[ForgeConstants.CounterDisplayType.values().length];
        ForgeConstants.CounterDisplayType[] values = ForgeConstants.CounterDisplayType.values();
        for (int i = 0; i < values.length; ++i) {
            elements[i] = values[i].getName();
        }
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_TYPE;
        FComboBoxPanel<String> panel = this.view.getCounterDisplayTypeComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(elements, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private void initializeCounterDisplayLocationComboBox() {
        String[] elements = new String[ForgeConstants.CounterDisplayLocation.values().length];
        ForgeConstants.CounterDisplayLocation[] values = ForgeConstants.CounterDisplayLocation.values();
        for (int i = 0; i < values.length; ++i) {
            elements[i] = values[i].getName();
        }
        ForgePreferences.FPref userSetting = ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_LOCATION;
        FComboBoxPanel<String> panel = this.view.getCounterDisplayLocationComboBoxPanel();
        FComboBox<String> comboBox = this.createComboBox(elements, userSetting);
        String selectedItem = this.prefs.getPref(userSetting);
        panel.setComboBox(comboBox, selectedItem);
    }

    private <E> FComboBox<E> createComboBox(E[] items, ForgePreferences.FPref setting) {
        FComboBox<E> comboBox = new FComboBox<E>(items);
        this.addComboBoxListener(comboBox, setting);
        return comboBox;
    }

    private <E> void addComboBoxListener(FComboBox<E> comboBox, ForgePreferences.FPref setting) {
        comboBox.addItemListener(e -> {
            Object selectedType = comboBox.getSelectedItem();
            this.prefs.setPref(setting, selectedType.toString());
            this.prefs.save();
        });
    }

    private void initializePlayerNameButton() {
        FLabel btn = this.view.getBtnPlayerName();
        this.setPlayerNameButtonText();
        btn.setCommand(this.getPlayerNameButtonCommand());
    }

    private void disableLazyLoading() {
        this.view.getCbLoadCardsLazily().setSelected(false);
        this.view.getCbLoadCardsLazily().setEnabled(false);
        this.prefs.save();
    }

    private void setPlayerNameButtonText() {
        FLabel btn = this.view.getBtnPlayerName();
        String name = this.prefs.getPref(ForgePreferences.FPref.PLAYER_NAME);
        btn.setText(StringUtils.isBlank(name) ? this.localizer.getMessage("lblHuman", new Object[0]) : name);
    }

    private UiCommand getPlayerNameButtonCommand() {
        return () -> {
            GamePlayerUtil.setPlayerName();
            this.setPlayerNameButtonText();
        };
    }
}

