/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.itemmanager.DeckManager;
import forge.itemmanager.ItemManagerContainer;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.LblHeader;
import forge.screens.home.StartButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.sanctioned.CSubmenuWinston;
import forge.toolbox.FLabel;
import forge.toolbox.FList;
import forge.toolbox.FSkin;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuWinston implements IVSubmenu<CSubmenuWinston>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    private final DragTab tab = new DragTab("Winston Draft");
    private final LblHeader lblTitle = new LblHeader("Sanctioned Format: Winston Draft");
    private final JPanel pnlStart = new JPanel();
    private final StartButton btnStart = new StartButton();
    private final DeckManager lstDecks = new DeckManager(GameType.Winston, CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture());
    private final JList<String> lstAI = new FList<String>();
    private final JLabel lblInfo = new FLabel.Builder().fontAlign(2).fontSize(16).fontStyle(1).text("Build or select a deck").build();
    private final FLabel lblDir1 = new FLabel.Builder().text("In Winston Draft mode, two players draft 6 packs of cards by piles.").fontSize(12).build();
    private final FLabel lblDir2 = new FLabel.Builder().text("Build a deck from the cards you choose. The AI will do the same.").fontSize(12).build();
    private final FLabel lblDir3 = new FLabel.Builder().text("Then, play against the AI opponent you drafted against.").fontSize(12).build();
    private final FLabel btnBuildDeck = new FLabel.ButtonBuilder().text("New Winston Draft Game").fontSize(16).build();

    private VSubmenuWinston() {
        this.lstAI.setSelectionMode(0);
        this.btnStart.setEnabled(false);
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.lstDecks.setCaption("Winston Draft Decks");
        this.pnlStart.setLayout(new MigLayout("insets 0, gap 0, wrap 2"));
        this.pnlStart.setOpaque(false);
        this.pnlStart.add(this.btnStart);
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.SANCTIONED;
    }

    @Override
    public String getMenuTitle() {
        return "Winston Draft";
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_WINSTON;
    }

    public FLabel getBtnBuildDeck() {
        return this.btnBuildDeck;
    }

    public JButton getBtnStart() {
        return this.btnStart;
    }

    public DeckManager getLstDecks() {
        return this.lstDecks;
    }

    @Override
    public void populate() {
        VHomeUI.PnlDisplay pnlDisplay = VHomeUI.SINGLETON_INSTANCE.getPnlDisplay();
        pnlDisplay.removeAll();
        pnlDisplay.setLayout(new MigLayout("insets 0, gap 0, wrap, ax right"));
        pnlDisplay.add((Component)this.lblTitle, "w 80%!, h 40px!, gap 0 0 15px 15px, ax right");
        pnlDisplay.add((Component)this.lblInfo, "w 80%!, h 30px!, gap 0 10% 20px 5px");
        pnlDisplay.add((Component)this.lblDir1, "gap 0 0 0 5px");
        pnlDisplay.add((Component)this.lblDir2, "gap 0 0 0 5px");
        pnlDisplay.add((Component)this.lblDir3, "gap 0 0 0 20px");
        pnlDisplay.add((Component)this.btnBuildDeck, "w 250px!, h 30px!, ax center, gap 0 10% 0 20px");
        pnlDisplay.add((Component)new ItemManagerContainer(this.lstDecks), "w 80%!, gap 0 10% 0 0, pushy, growy");
        pnlDisplay.add((Component)this.pnlStart, "gap 0 10% 50px 50px, ax center");
        pnlDisplay.repaint();
        pnlDisplay.revalidate();
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_WINSTON;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public CSubmenuWinston getLayoutControl() {
        return CSubmenuWinston.SINGLETON_INSTANCE;
    }
}

