/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import forge.game.GameType;
import forge.gui.SOverlayUtils;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.itemmanager.DeckManager;
import forge.itemmanager.ItemManagerContainer;
import forge.localinstance.skin.FSkinProp;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.LblHeader;
import forge.screens.home.StartButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.sanctioned.CSubmenuSealed;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.JXButtonPanel;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuSealed implements IVSubmenu<CSubmenuSealed>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblSealedDeck", new Object[0]));
    private final LblHeader lblTitle = new LblHeader(this.localizer.getMessage("lblHeaderSealed", new Object[0]));
    private final JPanel pnlStart = new JPanel();
    private final StartButton btnStart = new StartButton();
    private final DeckManager lstDecks = new DeckManager(GameType.Sealed, CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture());
    private final JRadioButton radSingle = new FRadioButton(this.localizer.getMessage("lblPlayAnOpponent", new Object[0]));
    private final JRadioButton radAll = new FRadioButton(this.localizer.getMessage("lblPlayAll7opponents", new Object[0]));
    private final JComboBox<String> cbOpponent = new JComboBox();
    private final FLabel lblInfo = new FLabel.Builder().fontAlign(2).fontSize(16).fontStyle(1).text(this.localizer.getMessage("lblSealedText1", new Object[0])).build();
    private final FLabel lblDir1 = new FLabel.Builder().text(this.localizer.getMessage("lblSealedText2", new Object[0])).fontSize(12).build();
    private final FLabel lblDir2 = new FLabel.Builder().text(this.localizer.getMessage("lblSealedText3", new Object[0])).fontSize(12).build();
    private final FLabel lblDir3 = new FLabel.Builder().text(this.localizer.getMessage("lblSealedText4", new Object[0])).fontSize(12).build();
    private final FLabel btnBuildDeck = new FLabel.ButtonBuilder().text(this.localizer.getMessage("btnBuildNewSealedDeck", new Object[0])).fontSize(16).build();
    private final FLabel btnDirections = new FLabel.Builder().fontSize(16).opaque(true).hoverable(true).text(this.localizer.getMessage("lblHowtoPlay", new Object[0])).fontAlign(0).build();

    private VSubmenuSealed() {
        this.btnStart.setEnabled(false);
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.lstDecks.setCaption(this.localizer.getMessage("lblSealedDecks", new Object[0]));
    }

    @Override
    public void populate() {
        VHomeUI.PnlDisplay pnlDisplay = VHomeUI.SINGLETON_INSTANCE.getPnlDisplay();
        pnlDisplay.removeAll();
        pnlDisplay.setLayout(new MigLayout("insets 0, gap 0, wrap, ax right"));
        pnlDisplay.add((Component)this.lblTitle, "w 80%!, h 40px!, gap 0 0 15px 15px, ax right");
        pnlDisplay.add((Component)this.lblInfo, "w 80%!, h 30px!, gap 0 10% 20px 5px");
        pnlDisplay.add((Component)this.lblDir1, "gap 0 0 0 5px");
        pnlDisplay.add((Component)this.lblDir2, "gap 0 0 0 5px");
        pnlDisplay.add((Component)this.lblDir3, "gap 0 0 0 20px");
        pnlDisplay.add((Component)this.btnBuildDeck, "w 250px!, h 30px!, ax center, gap 0 10% 0 20px");
        pnlDisplay.add((Component)new ItemManagerContainer(this.lstDecks), "w 80%!, gap 0 10% 0 0, pushy, growy");
        JXButtonPanel grpPanel = new JXButtonPanel();
        grpPanel.add((Component)this.radSingle, "w 200px!, h 30px!");
        grpPanel.add((Component)this.radAll, "w 200px!, h 30px!");
        this.radSingle.setSelected(true);
        grpPanel.add(this.cbOpponent, "w 200px!, h 30px!");
        this.pnlStart.setLayout(new MigLayout("insets 0, gap 0, wrap 2"));
        this.pnlStart.setOpaque(false);
        this.pnlStart.add((Component)grpPanel, "gapright 20");
        this.pnlStart.add(this.btnStart);
        pnlDisplay.add((Component)this.pnlStart, "gap 0 10% 50px 50px, ax center");
        pnlDisplay.repaintSelf();
        pnlDisplay.revalidate();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.SANCTIONED;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblSealedDeck", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_SEALED;
    }

    public FLabel getBtnDirections() {
        return this.btnDirections;
    }

    public FLabel getBtnBuildDeck() {
        return this.btnBuildDeck;
    }

    public JButton getBtnStart() {
        return this.btnStart;
    }

    public DeckManager getLstDecks() {
        return this.lstDecks;
    }

    public boolean isSingleSelected() {
        return this.radSingle.isSelected();
    }

    public JComboBox<String> getCbOpponent() {
        return this.cbOpponent;
    }

    public JRadioButton getRadSingle() {
        return this.radSingle;
    }

    public JRadioButton getRadAll() {
        return this.radAll;
    }

    public void showDirections() {
        JPanel overlay = SOverlayUtils.genericOverlay();
        int w = overlay.getWidth();
        String instructions = this.localizer.getMessage("lblSealedModeInstruction", new Object[0]);
        FSkin.SkinnedTextPane tpnDirections = new FSkin.SkinnedTextPane();
        tpnDirections.setOpaque(false);
        tpnDirections.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        tpnDirections.setFont(FSkin.getRelativeFont(15));
        tpnDirections.setAlignmentX(0.0f);
        tpnDirections.setFocusable(false);
        tpnDirections.setEditable(false);
        tpnDirections.setBorder((Border)null);
        tpnDirections.setText(instructions);
        StyledDocument doc = tpnDirections.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        FButton btnCloseBig = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
        btnCloseBig.setBounds(new Rectangle(w / 2 - 100, 510, 200, 30));
        btnCloseBig.addActionListener(arg0 -> SOverlayUtils.hideOverlay());
        FPanel pnl = new FPanel();
        pnl.setCornerDiameter(0);
        pnl.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        pnl.setLayout(new MigLayout("insets 0, gap 0"));
        pnl.add((Component)tpnDirections, "w 90%!, h 90%!, gap 5% 0 5% 0");
        pnl.setBounds(new Rectangle(w / 2 - 250, 80, 500, 400));
        overlay.setLayout(null);
        overlay.add(btnCloseBig);
        overlay.add(pnl);
        SOverlayUtils.showOverlay();
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_SEALED;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuSealed getLayoutControl() {
        return CSubmenuSealed.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }
}

