/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import forge.gui.WrapLayout;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class SleeveSelector
extends FDialog {
    private final List<FLabel> selectables = new ArrayList<FLabel>();
    private final Map<Integer, FSkin.SkinImage> sleeveMap = FSkin.getSleeves();

    public SleeveSelector(String playerName, int currentIndex, Collection<Integer> usedIndices) {
        this.setTitle(Localizer.getInstance().getMessage("lblSelectSleevesFroPlayer", playerName));
        JPanel pnlSleevePics = new JPanel(new WrapLayout());
        pnlSleevePics.setOpaque(false);
        pnlSleevePics.setOpaque(false);
        FLabel initialSelection = this.makeSleeveLabel(this.sleeveMap.get(currentIndex), currentIndex, currentIndex);
        pnlSleevePics.add(initialSelection);
        for (Integer i : this.sleeveMap.keySet()) {
            if (currentIndex == i) continue;
            pnlSleevePics.add(this.makeSleeveLabel(this.sleeveMap.get(i), i, currentIndex));
        }
        int width = this.getOwner().getWidth() * 3 / 4;
        int height = this.getOwner().getHeight() * 3 / 4;
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
        FScrollPane scroller = new FScrollPane(pnlSleevePics, false);
        scroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)scroller, "w 100%-24px!, pushy, growy, gap 12px 0 0 0");
        this.setDefaultFocus(initialSelection);
    }

    private FLabel makeSleeveLabel(FSkin.SkinImage img0, int index0, int oldIndex) {
        FLabel lbl = new FLabel.Builder().icon(img0).iconScaleFactor(0.95).iconAlignX(0).iconInBackground(true).hoverable(true).selectable(true).selected(oldIndex == index0).unhoveredAlpha(oldIndex == index0 ? 0.9f : 0.7f).build();
        Dimension size = new Dimension(60, 80);
        lbl.setPreferredSize(size);
        lbl.setMaximumSize(size);
        lbl.setMinimumSize(size);
        lbl.setName("SleeveLabel" + index0);
        if (oldIndex == index0) {
            lbl.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS).alphaColor(255), 3));
        }
        this.selectables.add(lbl);
        return lbl;
    }

    public List<FLabel> getSelectables() {
        return this.selectables;
    }
}

