/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import forge.Singletons;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckProxy;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gamemodes.limited.WinstonDraft;
import forge.gamemodes.match.HostedMatch;
import forge.gui.GuiBase;
import forge.gui.GuiChoose;
import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorWinstonProcess;
import forge.screens.home.sanctioned.VSubmenuWinston;
import forge.toolbox.FOptionPane;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public enum CSubmenuWinston implements ICDoc
{
    SINGLETON_INSTANCE;

    private final UiCommand cmdDeckSelect = () -> VSubmenuWinston.SINGLETON_INSTANCE.getBtnStart().setEnabled(true);

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VSubmenuWinston view = VSubmenuWinston.SINGLETON_INSTANCE;
        view.getLstDecks().setSelectCommand(this.cmdDeckSelect);
        view.getBtnBuildDeck().setCommand(this::setupDraft);
        view.getBtnStart().addActionListener(e -> this.startGame(GameType.Winston));
    }

    @Override
    public void update() {
        VSubmenuWinston view = VSubmenuWinston.SINGLETON_INSTANCE;
        JButton btnStart = view.getBtnStart();
        view.getLstDecks().setPool(DeckProxy.getWinstonDecks(FModel.getDecks().getWinston()));
        view.getLstDecks().setup(ItemManagerConfig.WINSTON_DECKS);
        if (!view.getLstDecks().getPool().isEmpty()) {
            btnStart.setEnabled(true);
        }
        SwingUtilities.invokeLater(() -> {
            if (btnStart.isEnabled()) {
                view.getBtnStart().requestFocusInWindow();
            } else {
                view.getBtnBuildDeck().requestFocusInWindow();
            }
        });
    }

    private void startGame(GameType gameType) {
        String errorMessage;
        DeckProxy humanDeck = (DeckProxy)VSubmenuWinston.SINGLETON_INSTANCE.getLstDecks().getSelectedItem();
        boolean aiIndex = false;
        if (humanDeck == null) {
            FOptionPane.showErrorDialog("No deck selected for human.\n(You may need to build a new deck)", "No Deck");
            return;
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY) && null != (errorMessage = gameType.getDeckFormat().getDeckConformanceProblem(humanDeck.getDeck()))) {
            FOptionPane.showErrorDialog("Your deck " + errorMessage + " Please edit or choose a different deck.", "Invalid Deck");
            return;
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        DeckGroup opponentDecks = FModel.getDecks().getWinston().get(humanDeck.getName());
        Deck aiDeck = opponentDecks.getAiDecks().get(0);
        if (aiDeck == null) {
            throw new IllegalStateException("Draft: Computer deck is null!");
        }
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(humanDeck.getDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(new RegisteredPlayer(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()));
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        hostedMatch.startMatch(GameType.Winston, null, starter, human, GuiBase.getInterface().getNewGuiGame());
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }

    private void setupDraft() {
        LimitedPoolType poolType2 = GuiChoose.oneOrNone("Choose Draft Format", LimitedPoolType.values());
        if (poolType2 == null) {
            return;
        }
        WinstonDraft draft = WinstonDraft.createDraft(poolType2);
        if (draft == null) {
            return;
        }
        CEditorWinstonProcess draftController = new CEditorWinstonProcess(CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture());
        draftController.showGui(draft);
        Singletons.getControl().setCurrentScreen(FScreen.DRAFTING_PROCESS);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(draftController);
    }
}

