/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import forge.Singletons;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckGroup;
import forge.deck.DeckProxy;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.limited.SealedCardPoolGenerator;
import forge.gamemodes.match.HostedMatch;
import forge.gui.GuiBase;
import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.ACEditorBase;
import forge.screens.deckeditor.controllers.CEditorLimited;
import forge.screens.home.sanctioned.VSubmenuSealed;
import forge.toolbox.FOptionPane;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public enum CSubmenuSealed implements ICDoc
{
    SINGLETON_INSTANCE;

    private final UiCommand cmdDeckSelect = () -> {
        VSubmenuSealed.SINGLETON_INSTANCE.getBtnStart().setEnabled(true);
        this.fillOpponentComboBox();
    };
    private final ActionListener radioAction = e -> this.fillOpponentComboBox();

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VSubmenuSealed view = VSubmenuSealed.SINGLETON_INSTANCE;
        view.getLstDecks().setSelectCommand(this.cmdDeckSelect);
        view.getBtnBuildDeck().setCommand(this::setupSealed);
        view.getBtnStart().addActionListener(e -> this.startGame(GameType.Sealed));
        view.getBtnDirections().setCommand(view::showDirections);
        view.getRadSingle().addActionListener(this.radioAction);
        view.getRadAll().addActionListener(this.radioAction);
    }

    @Override
    public void update() {
        VSubmenuSealed view = VSubmenuSealed.SINGLETON_INSTANCE;
        view.getLstDecks().setPool(DeckProxy.getAllSealedDecks());
        view.getLstDecks().setup(ItemManagerConfig.SEALED_DECKS);
        SwingUtilities.invokeLater(() -> {
            JButton btnStart = view.getBtnStart();
            if (btnStart.isEnabled()) {
                view.getBtnStart().requestFocusInWindow();
            } else {
                view.getBtnBuildDeck().requestFocusInWindow();
            }
        });
    }

    private void startGame(GameType gameType) {
        String errorMessage;
        boolean gauntlet = !VSubmenuSealed.SINGLETON_INSTANCE.isSingleSelected();
        DeckProxy humanDeck = (DeckProxy)VSubmenuSealed.SINGLETON_INSTANCE.getLstDecks().getSelectedItem();
        if (humanDeck == null) {
            FOptionPane.showErrorDialog("Please build and/or select a deck for yourself.", "No Deck");
            return;
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY) && null != (errorMessage = gameType.getDeckFormat().getDeckConformanceProblem(humanDeck.getDeck()))) {
            FOptionPane.showErrorDialog("Your deck " + errorMessage + " Please edit or choose a different deck.", "Invalid Deck");
            return;
        }
        String duelType = (String)VSubmenuSealed.SINGLETON_INSTANCE.getCbOpponent().getSelectedItem();
        DeckGroup opponentDecks = FModel.getDecks().getSealed().get(humanDeck.getName());
        if (gauntlet) {
            if ("Gauntlet".equals(duelType)) {
                int rounds = opponentDecks.getAiDecks().size();
                FModel.getGauntletMini().launch(rounds, humanDeck.getDeck(), gameType);
            } else if ("Tournament".equals(duelType)) {
                // empty if block
            }
            return;
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        int aiIndex = Integer.parseInt(duelType) - 1;
        Deck aiDeck = opponentDecks.getAiDecks().get(aiIndex);
        if (aiDeck == null) {
            throw new IllegalStateException("Sealed: Computer deck is null!");
        }
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(humanDeck.getDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(new RegisteredPlayer(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()));
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        hostedMatch.startMatch(GameType.Sealed, null, starter, human, GuiBase.getInterface().getNewGuiGame());
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }

    private <T extends DeckBase> void setupSealed() {
        DeckGroup sealed = SealedCardPoolGenerator.generateSealedDeck(false);
        if (sealed == null) {
            return;
        }
        CEditorLimited editor = new CEditorLimited(FModel.getDecks().getSealed(), FScreen.DECK_EDITOR_SEALED, CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture());
        Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_SEALED);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(editor);
        ((ACEditorBase)editor).getDeckController().setModel(sealed);
    }

    private void fillOpponentComboBox() {
        VSubmenuSealed view = VSubmenuSealed.SINGLETON_INSTANCE;
        JComboBox<String> combo = view.getCbOpponent();
        combo.removeAllItems();
        DeckProxy humanDeck = (DeckProxy)view.getLstDecks().getSelectedItem();
        if (humanDeck == null) {
            return;
        }
        if (VSubmenuSealed.SINGLETON_INSTANCE.isSingleSelected()) {
            DeckGroup opponentDecks = FModel.getDecks().getSealed().get(humanDeck.getName());
            int indx = 0;
            for (Deck d : opponentDecks.getAiDecks()) {
                combo.addItem(String.valueOf(++indx));
            }
        } else {
            combo.addItem("Gauntlet");
        }
    }
}

