/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.Singletons;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.DeckProxy;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.LimitedPoolType;
import forge.gamemodes.match.HostedMatch;
import forge.gui.GuiBase;
import forge.gui.GuiChoose;
import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.itemmanager.ItemManagerConfig;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorDraftingProcess;
import forge.screens.deckeditor.views.VProbabilities;
import forge.screens.deckeditor.views.VStatistics;
import forge.screens.home.sanctioned.VSubmenuDraft;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public enum CSubmenuDraft implements ICDoc
{
    SINGLETON_INSTANCE;

    private final UiCommand cmdDeckSelect = () -> {
        VSubmenuDraft.SINGLETON_INSTANCE.getBtnStart().setEnabled(true);
        this.fillOpponentComboBox();
    };
    private final ActionListener radioAction = e -> this.fillOpponentComboBox();

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VSubmenuDraft view = VSubmenuDraft.SINGLETON_INSTANCE;
        view.getLstDecks().setSelectCommand(this.cmdDeckSelect);
        view.getBtnBuildDeck().setCommand(this::setupDraft);
        view.getBtnStart().addActionListener(e -> this.startGame(GameType.Draft));
        view.getRadSingle().addActionListener(this.radioAction);
        view.getRadAll().addActionListener(this.radioAction);
        view.getRadMultiple().addActionListener(this.radioAction);
    }

    @Override
    public void update() {
        VSubmenuDraft view = VSubmenuDraft.SINGLETON_INSTANCE;
        JButton btnStart = view.getBtnStart();
        view.getLstDecks().setPool(DeckProxy.getAllDraftDecks());
        view.getLstDecks().setup(ItemManagerConfig.DRAFT_DECKS);
        if (!view.getLstDecks().getPool().isEmpty()) {
            btnStart.setEnabled(true);
            this.fillOpponentComboBox();
        }
        SwingUtilities.invokeLater(() -> {
            if (btnStart.isEnabled()) {
                view.getBtnStart().requestFocusInWindow();
            } else {
                view.getBtnBuildDeck().requestFocusInWindow();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void startGame(GameType gameType) {
        String errorMessage;
        Localizer localizer = Localizer.getInstance();
        boolean gauntlet = VSubmenuDraft.SINGLETON_INSTANCE.isGauntlet();
        DeckProxy humanDeck = (DeckProxy)VSubmenuDraft.SINGLETON_INSTANCE.getLstDecks().getSelectedItem();
        if (humanDeck == null) {
            FOptionPane.showErrorDialog(localizer.getMessage("lblNoDeckSelected", new Object[0]), localizer.getMessage("lblNoDeck", new Object[0]));
            return;
        }
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY) && null != (errorMessage = gameType.getDeckFormat().getDeckConformanceProblem(humanDeck.getDeck()))) {
            FOptionPane.showErrorDialog("Your deck " + errorMessage + " Please edit or choose a different deck.", "Invalid Deck");
            return;
        }
        FModel.getGauntletMini().resetGauntletDraft();
        String duelType = (String)VSubmenuDraft.SINGLETON_INSTANCE.getCbOpponent().getSelectedItem();
        if (duelType == null) {
            FOptionPane.showErrorDialog("Please select duel types for the draft match.", "Missing opponent items");
            return;
        }
        DeckGroup opponentDecks = FModel.getDecks().getDraft().get(humanDeck.getName());
        if (gauntlet) {
            if ("Gauntlet".equals(duelType)) {
                int rounds = opponentDecks.getAiDecks().size();
                FModel.getGauntletMini().launch(rounds, humanDeck.getDeck(), gameType);
            } else if ("Tournament".equals(duelType)) {
                // empty if block
            }
            return;
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        HashMap<Integer, Deck> aiMap = Maps.newHashMap();
        if (VSubmenuDraft.SINGLETON_INSTANCE.isSingleSelected()) {
            int aiIndex = Integer.parseInt(duelType) - 1;
            Deck aiDeck = opponentDecks.getAiDecks().get(aiIndex);
            if (aiDeck == null) {
                throw new IllegalStateException("Draft: Computer deck is null!");
            }
            aiMap.put(aiIndex + 1, aiDeck);
        } else {
            void var11_15;
            int maxDecks;
            int numOpponents = Integer.parseInt(duelType);
            if (numOpponents > (maxDecks = opponentDecks.getAiDecks().size())) {
                throw new IllegalStateException("Draft: Not enough decks for the number of opponents!");
            }
            Object aiIndices = Lists.newArrayList();
            boolean bl = false;
            while (var11_15 < maxDecks) {
                aiIndices.add((int)var11_15);
                ++var11_15;
            }
            Collections.shuffle(aiIndices);
            aiIndices = aiIndices.subList(0, numOpponents);
            Iterator iterator = aiIndices.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                Deck aiDeck = opponentDecks.getAiDecks().get(i2);
                if (aiDeck == null) {
                    throw new IllegalStateException("Draft: Computer deck is null!");
                }
                aiMap.put(i2 + 1, aiDeck);
            }
        }
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(humanDeck.getDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        human.setId(0);
        human.assignConspiracies();
        for (Map.Entry entry : aiMap.entrySet()) {
            RegisteredPlayer aiPlayer = new RegisteredPlayer((Deck)entry.getValue()).setPlayer(GamePlayerUtil.createAiPlayer());
            aiPlayer.setId((Integer)entry.getKey());
            starter.add(aiPlayer);
            aiPlayer.assignConspiracies();
        }
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        hostedMatch.startMatch(GameType.Draft, null, starter, human, GuiBase.getInterface().getNewGuiGame());
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }

    private void setupDraft() {
        Localizer localizer = Localizer.getInstance();
        LimitedPoolType poolType2 = GuiChoose.oneOrNone(localizer.getMessage("lblChooseDraftFormat", new Object[0]), LimitedPoolType.values(true));
        if (poolType2 == null) {
            return;
        }
        BoosterDraft draft = BoosterDraft.createDraft(poolType2);
        if (draft == null) {
            return;
        }
        CEditorDraftingProcess draftController = new CEditorDraftingProcess(CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture());
        draftController.showGui(draft);
        Singletons.getControl().setCurrentScreen(FScreen.DRAFTING_PROCESS);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(draftController);
        VProbabilities.SINGLETON_INSTANCE.getLayoutControl().update();
        VStatistics.SINGLETON_INSTANCE.getLayoutControl().update();
    }

    private void fillOpponentComboBox() {
        VSubmenuDraft view = VSubmenuDraft.SINGLETON_INSTANCE;
        JComboBox<String> combo = view.getCbOpponent();
        combo.removeAllItems();
        DeckProxy humanDeck = (DeckProxy)view.getLstDecks().getSelectedItem();
        if (humanDeck == null) {
            return;
        }
        if (VSubmenuDraft.SINGLETON_INSTANCE.isSingleSelected()) {
            DeckGroup opponentDecks = FModel.getDecks().getDraft().get(humanDeck.getName());
            int indx = 0;
            for (Deck d : opponentDecks.getAiDecks()) {
                combo.addItem(String.valueOf(++indx));
            }
        } else if (VSubmenuDraft.SINGLETON_INSTANCE.isGauntlet()) {
            combo.addItem("Gauntlet");
        } else {
            combo.addItem("2");
            combo.addItem("3");
            combo.addItem("4");
            combo.addItem("5");
        }
    }
}

