/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.sanctioned;

import forge.gui.WrapLayout;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class AvatarSelector
extends FDialog {
    private final List<FLabel> selectables = new ArrayList<FLabel>();
    private final Map<Integer, FSkin.SkinImage> avatarMap = FSkin.getAvatars();

    public AvatarSelector(String playerName, int currentIndex, Collection<Integer> usedIndices) {
        Localizer localizer = Localizer.getInstance();
        String s2 = localizer.getMessage("lblSelectAvatarFor", new Object[0]);
        this.setTitle(s2.replace("%s", playerName));
        JPanel pnlAvatarPics = new JPanel(new WrapLayout());
        pnlAvatarPics.setOpaque(false);
        pnlAvatarPics.setOpaque(false);
        FLabel initialSelection = this.makeAvatarLabel(this.avatarMap.get(currentIndex), currentIndex, currentIndex);
        pnlAvatarPics.add(initialSelection);
        for (Integer i : this.avatarMap.keySet()) {
            if (currentIndex == i) continue;
            pnlAvatarPics.add(this.makeAvatarLabel(this.avatarMap.get(i), i, currentIndex));
        }
        int width = this.getOwner().getWidth() * 3 / 4;
        int height = this.getOwner().getHeight() * 3 / 4;
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
        FScrollPane scroller = new FScrollPane(pnlAvatarPics, false);
        scroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)scroller, "w 100%-24px!, pushy, growy, gap 12px 0 0 0");
        this.setDefaultFocus(initialSelection);
    }

    private FLabel makeAvatarLabel(FSkin.SkinImage img0, int index0, int oldIndex) {
        FLabel lbl = new FLabel.Builder().icon(img0).iconScaleFactor(0.95).iconAlignX(0).iconInBackground(true).hoverable(true).selectable(true).selected(oldIndex == index0).unhoveredAlpha(oldIndex == index0 ? 0.9f : 0.7f).build();
        Dimension size = new Dimension(80, 80);
        lbl.setPreferredSize(size);
        lbl.setMaximumSize(size);
        lbl.setMinimumSize(size);
        lbl.setName("AvatarLabel" + index0);
        if (oldIndex == index0) {
            lbl.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS).alphaColor(255), 3));
        }
        this.selectables.add(lbl);
        return lbl;
    }

    public List<FLabel> getSelectables() {
        return this.selectables;
    }
}

