/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.bazaar.QuestStallDefinition;
import forge.gamemodes.quest.data.QuestAssets;
import forge.model.FModel;
import forge.screens.bazaar.VBazaarUI;
import forge.screens.home.quest.ViewItem;
import forge.toolbox.FLabel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;

public class ViewStall
extends JPanel {
    private final FLabel lblStallName = new FLabel.Builder().text("").fontAlign(0).build();
    private final FLabel lblEmpty = new FLabel.Builder().text("The merchant does not have anything useful for sale.").fontAlign(0).build();
    private final FLabel lblStats = new FLabel.Builder().fontAlign(0).fontSize(12).build();
    private final FSkin.SkinnedTextPane tpnFluff = new FSkin.SkinnedTextPane();
    private final JPanel pnlInventory = new JPanel();
    private final FScrollPane scrInventory = new FScrollPane(this.pnlInventory, false);
    private final VBazaarUI parentView;
    private final List<ViewItem> lstItemPanels;
    private QuestStallDefinition stall;

    public ViewStall(VBazaarUI v0) {
        this.parentView = v0;
        this.lstItemPanels = new ArrayList<ViewItem>();
        this.setOpaque(false);
        this.tpnFluff.setOpaque(false);
        this.tpnFluff.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.tpnFluff.setFont(FSkin.getRelativeItalicFont(15));
        this.tpnFluff.setFocusable(false);
        this.tpnFluff.setEditable(false);
        this.tpnFluff.setBorder((Border)null);
        StyledDocument doc = this.tpnFluff.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        this.pnlInventory.setOpaque(false);
        this.scrInventory.setVerticalScrollBarPolicy(20);
        this.scrInventory.setHorizontalScrollBarPolicy(31);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap, ay center"));
        this.add((Component)this.lblStallName, "w 90%!, h 40px!, gap 5% 0 10px 0");
        this.add((Component)this.tpnFluff, "w 90%!, h 20px!, gap 5% 0 10px 40px");
        this.add((Component)this.lblStats, "w 90%!, h 18px!, gap 5% 0 0 10px");
        this.add((Component)this.scrInventory, "w 95%!, h 70%!");
        this.pnlInventory.setLayout(new MigLayout("insets 0, gap 0, wrap, alignx center, hidemode 3"));
        this.pnlInventory.add((Component)this.lblEmpty, "w 90%!, h 30px!, gap 5% 0 50px 50px");
    }

    public FLabel getLblStallName() {
        return this.lblStallName;
    }

    public JTextPane getTpnFluff() {
        return this.tpnFluff;
    }

    public FLabel getLblStats() {
        return this.lblStats;
    }

    public FScrollPane getScrInventory() {
        return this.scrInventory;
    }

    public void setStall(QuestStallDefinition q0) {
        this.stall = q0;
    }

    public void updateStall() {
        QuestController qData = FModel.getQuest();
        if (qData.getAssets() == null) {
            return;
        }
        QuestAssets qS = qData.getAssets();
        StringBuilder sb = new StringBuilder();
        sb.append("Credits: ");
        sb.append(QuestUtil.formatCredits(qS.getCredits()));
        sb.append("         Life: ");
        sb.append(qS.getLife(qData.getMode()));
        sb.append("         Level: ");
        sb.append(qData.getLevel());
        this.lblStats.setText(sb.toString());
        List<IQuestBazaarItem> items = qData.getBazaar().getItems(qData, this.stall.getName());
        this.lblStallName.setText(this.stall.getDisplayName());
        this.tpnFluff.setText(this.stall.getFluff());
        for (Component i : this.pnlInventory.getComponents()) {
            i.setVisible(false);
        }
        if (items.size() == 0) {
            this.lblEmpty.setVisible(true);
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (this.lstItemPanels.size() == i) {
                ViewItem pnlItem = new ViewItem();
                this.lstItemPanels.add(i, pnlItem);
                this.pnlInventory.add((Component)pnlItem, "w 90%!, gap 5% 0 0 10px");
            }
            this.lstItemPanels.get(i).setItem(items.get(i));
            this.lstItemPanels.get(i).update();
            this.lstItemPanels.get(i).setVisible(true);
        }
    }

    public VBazaarUI getParentView() {
        return this.parentView;
    }
}

