/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.bazaar.IQuestBazaarItem;
import forge.gamemodes.quest.data.QuestAssets;
import forge.gui.GuiBase;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.bazaar.VBazaarUI;
import forge.toolbox.FHtmlViewer;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import java.awt.Component;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class ViewItem
extends FPanel {
    private final FLabel lblIcon = new FLabel.Builder().iconScaleFactor(1.0).iconInBackground(true).build();
    private final FLabel lblName = new FLabel.Builder().fontStyle(1).build();
    private final FLabel lblPrice = new FLabel.Builder().fontStyle(1).fontSize(12).build();
    private final FLabel btnPurchase;
    private final FHtmlViewer tarDesc = new FHtmlViewer();
    private IQuestBazaarItem item;

    public ViewItem() {
        this.btnPurchase = new FLabel.Builder().text("Buy").opaque(true).fontSize(20).hoverable(true).build();
        this.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.setLayout(new MigLayout("insets 0, gap 0"));
        this.add((Component)this.lblIcon, "w 100px!, h n:90%:100px, ay center, span 1 3, gap 5px 5px 5px 5px");
        this.add((Component)this.lblName, "pushx, w 60%!, h 22px!, gap 0 0 5px 5px");
        this.add((Component)this.btnPurchase, "w 80px!, h 80px!, ay center, span 1 3, gap 0 15px 0 0, wrap");
        this.add((Component)this.tarDesc, "w 60%!, gap 0 0 0 10px, wrap");
        this.add((Component)this.lblPrice, "w 60%!, h 20px!, gap 0 0 0 5px");
        this.btnPurchase.setCommand(() -> {
            QuestUtil.buyQuestItem(this.getItem());
            VBazaarUI.SINGLETON_INSTANCE.refreshLastInstance();
        });
    }

    public void setItem(IQuestBazaarItem i0) {
        this.item = i0;
    }

    public IQuestBazaarItem getItem() {
        return this.item;
    }

    public void update() {
        SwingUtilities.invokeLater(() -> {
            FSkin.SkinImage i;
            QuestAssets qA = FModel.getQuest().getAssets();
            IQuestBazaarItem bazaarItem = this.getItem();
            try {
                i = (FSkin.SkinImage)bazaarItem.getIcon(qA);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                i = (FSkin.SkinImage)GuiBase.getInterface().getSkinIcon(FSkinProp.ICO_UNKNOWN);
            }
            this.lblIcon.setIcon(i);
            this.lblName.setText(bazaarItem.getPurchaseName());
            this.lblPrice.setText("Cost: " + bazaarItem.getBuyingPrice(qA) + " credits");
            String desc = bazaarItem.getPurchaseDescription(qA);
            this.tarDesc.setText(FSkin.encodeSymbols(desc, false));
            this.btnPurchase.setEnabled(qA.getCredits() >= (long)bazaarItem.getBuyingPrice(qA));
            this.revalidate();
            this.repaintSelf();
        });
    }
}

