/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.StartingPoolType;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.item.PreconDeck;
import forge.localinstance.properties.ForgeConstants;
import forge.model.CardCollections;
import forge.model.FModel;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.VHomeUI;
import forge.screens.home.quest.CSubmenuQuestStart;
import forge.toolbox.FCheckBox;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FLabel;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.JXButtonPanel;
import forge.util.Localizer;
import forge.util.WordUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuQuestStart implements IVSubmenu<CSubmenuQuestStart>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblStartanewQuest", new Object[0]));
    private final FLabel lblTitleNew = new FLabel.Builder().text(this.localizer.getMessage("lblStartanewQuest", new Object[0])).opaque(true).fontSize(16).build();
    String str = ForgeConstants.QUEST_SAVE_DIR.replace('\\', '/');
    private final JPanel pnlOptions = new JPanel();
    private final FRadioButton radEasy = new FRadioButton(this.localizer.getMessage("questDifficultyEasy", new Object[0]));
    private final FRadioButton radMedium = new FRadioButton(this.localizer.getMessage("questDifficultyMedium", new Object[0]));
    private final FRadioButton radHard = new FRadioButton(this.localizer.getMessage("questDifficultyHard", new Object[0]));
    private final FRadioButton radExpert = new FRadioButton(this.localizer.getMessage("questDifficultyExpert", new Object[0]));
    private final FCheckBox boxFantasy = new FCheckBox(this.localizer.getMessage("rbFantasyMode", new Object[0]));
    private final FCheckBox boxCommander = new FCheckBox(this.localizer.getMessage("rbCommanderSubformat", new Object[0]));
    private final FLabel lblStartingWorld = new FLabel.Builder().text(this.localizer.getMessage("lblStartingWorld", new Object[0]) + ":").build();
    private final FComboBoxWrapper<QuestWorld> cbxStartingWorld = new FComboBoxWrapper();
    private final FLabel lblStartingPool = new FLabel.Builder().text(this.localizer.getMessage("lblStartingPool", new Object[0]) + ":").build();
    private final FComboBoxWrapper<StartingPoolType> cbxStartingPool = new FComboBoxWrapper();
    private final FLabel lblUnrestricted = new FLabel.Builder().text(this.localizer.getMessage("lblAllCardsAvailable", new Object[0])).build();
    private final FLabel lblPreconDeck = new FLabel.Builder().text(this.localizer.getMessage("lblStarterEventdeck", new Object[0]) + ":").build();
    private final FComboBoxWrapper<String> cbxPreconDeck = new FComboBoxWrapper();
    private final FLabel lblFormat = new FLabel.Builder().text(this.localizer.getMessage("lblSanctionedFormat", new Object[0]) + ":").build();
    private final FComboBoxWrapper<GameFormat> cbxFormat = new FComboBoxWrapper();
    private final FLabel lblCustomDeck = new FLabel.Builder().text(this.localizer.getMessage("lblCustomdeck", new Object[0])).build();
    private final FComboBoxWrapper<Deck> cbxCustomDeck = new FComboBoxWrapper();
    private final FLabel btnDefineCustomFormat = new FLabel.Builder().opaque(true).hoverable(true).text(this.localizer.getMessage("lblDefineCustomFormat", new Object[0])).build();
    private final FLabel btnSelectFormat = new FLabel.Builder().opaque(true).hoverable(true).text(this.localizer.getMessage("lblSelectFormat", new Object[0])).build();
    private final FCheckBox boxCompleteSet = new FCheckBox(this.localizer.getMessage("lblStartWithAllCards", new Object[0]));
    private final FCheckBox boxAllowDuplicates = new FCheckBox(this.localizer.getMessage("lblAllowDuplicateCards", new Object[0]));
    private final FLabel lblPreferredColor = new FLabel.Builder().text(this.localizer.getMessage("lblStartingPoolDistribution", new Object[0])).build();
    private final FLabel btnPreferredColors = new FLabel.Builder().opaque(true).hoverable(true).text(this.localizer.getMessage("lblChooseDistribution", new Object[0])).build();
    private final FLabel btnPrizeDefineCustomFormat = new FLabel.Builder().opaque(true).hoverable(true).text(this.localizer.getMessage("lblDefineCustomFormat", new Object[0])).build();
    private final FLabel btnPrizeSelectFormat = new FLabel.Builder().opaque(true).hoverable(true).text(this.localizer.getMessage("lblSelectFormat", new Object[0])).build();
    private final FLabel lblPrizedCards = new FLabel.Builder().text(this.localizer.getMessage("lblPrizedCards", new Object[0])).build();
    private final FComboBoxWrapper<Object> cbxPrizedCards = new FComboBoxWrapper();
    private final FLabel lblPrizeFormat = new FLabel.Builder().text(this.localizer.getMessage("lblSanctionedFormat", new Object[0]) + ":").build();
    private final FComboBoxWrapper<GameFormat> cbxPrizeFormat = new FComboBoxWrapper();
    private final FLabel lblPrizeUnrestricted = new FLabel.Builder().text(this.localizer.getMessage("lblAllCardsAvailableWin", new Object[0])).build();
    private final FLabel lblPrizeSameAsStarting = new FLabel.Builder().text(this.localizer.getMessage("lblOnlySetsInStarting", new Object[0])).build();
    private final FCheckBox cboAllowUnlocks = new FCheckBox(this.localizer.getMessage("lblAllowUnlockAdEd", new Object[0]));
    private final FLabel btnEmbark = new FLabel.Builder().opaque(true).fontSize(16).hoverable(true).text(this.localizer.getMessage("lblEmbark", new Object[0])).build();
    private final ActionListener alStartingPool = e -> {
        StartingPoolType newVal = this.getStartingPoolType();
        this.lblUnrestricted.setVisible(newVal == StartingPoolType.Complete);
        this.lblPreconDeck.setVisible(newVal == StartingPoolType.Precon);
        this.cbxPreconDeck.setVisible(newVal == StartingPoolType.Precon);
        this.lblFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.cbxFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.btnDefineCustomFormat.setVisible(newVal == StartingPoolType.CustomFormat);
        this.btnSelectFormat.setVisible(newVal == StartingPoolType.Casual);
        boolean usesDeckList = newVal == StartingPoolType.SealedDeck || newVal == StartingPoolType.DraftDeck || newVal == StartingPoolType.Cube;
        this.lblCustomDeck.setVisible(usesDeckList);
        this.cbxCustomDeck.setVisible(usesDeckList);
        if (usesDeckList) {
            this.cbxCustomDeck.removeAllItems();
            CardCollections decks = FModel.getDecks();
            switch (newVal) {
                case SealedDeck: {
                    for (DeckGroup d : decks.getSealed()) {
                        this.cbxCustomDeck.addItem(d.getHumanDeck());
                    }
                    break;
                }
                case DraftDeck: {
                    for (DeckGroup d : decks.getDraft()) {
                        this.cbxCustomDeck.addItem(d.getHumanDeck());
                    }
                    break;
                }
                case Cube: {
                    for (Deck d : decks.getCubes()) {
                        this.cbxCustomDeck.addItem(d);
                    }
                    break;
                }
            }
        }
    };
    private final ActionListener alPrizesPool = e -> {
        StartingPoolType newVal = this.getPrizedPoolType();
        this.lblPrizeUnrestricted.setVisible(newVal == StartingPoolType.Complete);
        this.cboAllowUnlocks.setVisible(newVal != StartingPoolType.Complete);
        this.lblPrizeFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.cbxPrizeFormat.setVisible(newVal == StartingPoolType.Sanctioned);
        this.btnPrizeDefineCustomFormat.setVisible(newVal == StartingPoolType.CustomFormat);
        this.btnPrizeSelectFormat.setVisible(newVal == StartingPoolType.Casual);
        this.lblPrizeSameAsStarting.setVisible(newVal == null);
    };
    private final ActionListener alStartingWorld = e -> this.updateEnabledFormats();

    private void updateEnabledFormats() {
        QuestWorld qw = FModel.getWorlds().get(this.getStartingWorldName());
        if (qw != null) {
            this.cbxStartingPool.setEnabled(qw.getFormat() == null);
            this.cbxFormat.setEnabled(qw.getFormat() == null);
            this.cbxCustomDeck.setEnabled(qw.getFormat() == null);
        }
    }

    private VSubmenuQuestStart() {
        this.lblTitleNew.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        JXButtonPanel difficultyPanel = new JXButtonPanel();
        String difficulty_constraints = "h 25px!, gapbottom 5";
        difficultyPanel.add((Component)this.radEasy, "h 25px!, gapbottom 5");
        difficultyPanel.add((Component)this.radMedium, "h 25px!, gapbottom 5");
        difficultyPanel.add((Component)this.radHard, "h 25px!, gapbottom 5");
        difficultyPanel.add((Component)this.radExpert, "h 25px!, gapbottom 5");
        this.radEasy.setSelected(true);
        this.boxCompleteSet.setToolTipText(this.localizer.getMessage("lblboxCompleteSet", new Object[0]));
        this.boxAllowDuplicates.setToolTipText(this.localizer.getMessage("lblboxAllowDuplicates", new Object[0]));
        this.lblStartingWorld.setLabelFor(this.cbxStartingWorld.getComponent());
        this.lblStartingPool.setLabelFor(this.cbxStartingPool.getComponent());
        this.lblPreconDeck.setLabelFor(this.cbxPreconDeck.getComponent());
        this.lblFormat.setLabelFor(this.cbxFormat.getComponent());
        this.lblCustomDeck.setLabelFor(this.cbxCustomDeck.getComponent());
        this.lblPrizedCards.setLabelFor(this.cbxPrizedCards.getComponent());
        this.lblPrizeFormat.setLabelFor(this.cbxPrizeFormat.getComponent());
        this.cbxStartingPool.addItem(StartingPoolType.Complete);
        this.cbxStartingPool.addItem(StartingPoolType.Sanctioned);
        this.cbxStartingPool.addItem(StartingPoolType.Casual);
        this.cbxStartingPool.addItem(StartingPoolType.CustomFormat);
        this.cbxStartingPool.addItem(StartingPoolType.Precon);
        this.cbxStartingPool.addItem(StartingPoolType.DraftDeck);
        this.cbxStartingPool.addItem(StartingPoolType.SealedDeck);
        this.cbxStartingPool.addItem(StartingPoolType.Cube);
        this.cbxStartingPool.addActionListener(this.alStartingPool);
        this.alStartingPool.actionPerformed(null);
        this.alPrizesPool.actionPerformed(null);
        this.cbxPrizedCards.addItem(this.localizer.getMessage("lblSameAsStartingPool", new Object[0]));
        this.cbxPrizedCards.addItem((Object)StartingPoolType.Complete);
        this.cbxPrizedCards.addItem((Object)StartingPoolType.Sanctioned);
        this.cbxPrizedCards.addItem((Object)StartingPoolType.Casual);
        this.cbxPrizedCards.addItem((Object)StartingPoolType.CustomFormat);
        this.cbxPrizedCards.addActionListener(this.alPrizesPool);
        for (GameFormat gameFormat : FModel.getFormats().getSanctionedList()) {
            this.cbxFormat.addItem(gameFormat);
            this.cbxPrizeFormat.addItem(gameFormat);
        }
        for (QuestWorld questWorld : FModel.getWorlds()) {
            this.cbxStartingWorld.addItem(questWorld);
        }
        this.cbxStartingWorld.setSelectedItem((Object)FModel.getWorlds().get("Main world"));
        this.cbxStartingWorld.addActionListener(this.alStartingWorld);
        this.updateEnabledFormats();
        this.cboAllowUnlocks.setSelected(true);
        final HashMap<String, String> preconDescriptions = new HashMap<String, String>();
        for (PreconDeck preconDeck : QuestController.getPrecons()) {
            if (QuestController.getPreconDeals(preconDeck).getMinWins() > 0) continue;
            String name = preconDeck.getName();
            this.cbxPreconDeck.addItem(name);
            String description = preconDeck.getDescription();
            preconDescriptions.put(name, WordUtil.wordWrapAsHTML(description));
        }
        this.cbxPreconDeck.setRenderer(new BasicComboBoxRenderer(){
            private static final long serialVersionUID = 3477357932538947199L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component defaultComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (-1 < index && null != value) {
                    String val = (String)value;
                    list.setToolTipText((String)preconDescriptions.get(val));
                }
                return defaultComponent;
            }
        });
        this.boxFantasy.setSelected(true);
        this.boxFantasy.setEnabled(true);
        this.boxCommander.setSelected(false);
        this.boxCommander.setEnabled(true);
        this.boxCommander.addActionListener(e -> {
            if (!this.isCommander()) {
                return;
            }
            this.cbxStartingWorld.setSelectedItem((Object)FModel.getWorlds().get("Random Commander"));
        });
        this.boxCompleteSet.setEnabled(true);
        this.boxAllowDuplicates.setEnabled(true);
        this.pnlOptions.setOpaque(false);
        this.pnlOptions.setLayout(new MigLayout("insets 0, gap 10px, fillx, wrap 2"));
        JPanel jPanel = new JPanel(new MigLayout("insets 0, gap 1%, flowy"));
        jPanel.add((Component)difficultyPanel, "gapright 4%");
        jPanel.add((Component)this.boxFantasy, "h 25px!, gapbottom 15, gapright 4%");
        jPanel.add((Component)this.boxCommander, "h 25px!, gapbottom 15, gapright 4%");
        jPanel.add((Component)this.lblStartingWorld, "h 25px!, hidemode 3");
        this.cbxStartingWorld.addTo(jPanel, "h 27px!, w 40%, pushx, gapbottom 7");
        jPanel.setOpaque(false);
        this.pnlOptions.add((Component)jPanel, "w 40%");
        JPanel pnlRestrictions = new JPanel();
        String constraints = "h 25px!, ";
        String hidemode = "hidemode 3, ";
        String cboWidth = "w 240px!, pushx, ";
        String cboWidthStart = "w 240px!, pushx, hidemode 3, ";
        String btnStartingCustomFormatWidth = "w " + (4 + this.cbxStartingPool.getAutoSizeWidth()) + "px!, ";
        pnlRestrictions.setLayout(new MigLayout("insets 0, gap 10", "[right][left]"));
        pnlRestrictions.add((Component)this.lblStartingPool, "h 15px!, cell 0 0");
        this.cbxStartingPool.addTo(pnlRestrictions, "h 25px!, w 240px!, pushx, hidemode 3,  cell 1 0");
        pnlRestrictions.add((Component)this.lblUnrestricted, "h 25px!, hidemode 3,  cell 1 1, ");
        pnlRestrictions.add((Component)this.lblPreconDeck, "h 25px!, hidemode 3,  cell 0 1");
        this.cbxPreconDeck.addTo(pnlRestrictions, "h 25px!, w 240px!, pushx, hidemode 3,  cell 1 1");
        pnlRestrictions.add((Component)this.lblCustomDeck, "h 25px!, hidemode 3,  cell 0 1");
        this.cbxCustomDeck.addTo(pnlRestrictions, "h 25px!, w 240px!, pushx, hidemode 3,  cell 1 1");
        pnlRestrictions.add((Component)this.lblFormat, "h 25px!, hidemode 3,  cell 0 1");
        this.cbxFormat.addTo(pnlRestrictions, "h 25px!, w 240px!, pushx, hidemode 3,  cell 1 1");
        pnlRestrictions.add((Component)this.btnDefineCustomFormat, btnStartingCustomFormatWidth + "h 25px!, " + "hidemode 3, " + " cell 1 1");
        pnlRestrictions.add((Component)this.btnSelectFormat, btnStartingCustomFormatWidth + "h 25px!, " + "hidemode 3, " + " cell 1 1");
        pnlRestrictions.add((Component)this.boxAllowDuplicates, "h 15px!, cell 1 2");
        pnlRestrictions.add((Component)this.boxCompleteSet, "h 15px!, cell 1 3");
        pnlRestrictions.add((Component)this.lblPreferredColor, "h 25px!, hidemode 3, cell 0 4");
        pnlRestrictions.add((Component)this.btnPreferredColors, btnStartingCustomFormatWidth + "h 25px!, " + "hidemode 3, " + "cell 1 4");
        pnlRestrictions.add((Component)this.lblPrizedCards, "h 25px!,  cell 0 5");
        this.cbxPrizedCards.addTo(pnlRestrictions, "h 25px!, w 240px!, pushx,  cell 1 5");
        pnlRestrictions.add((Component)this.lblPrizeFormat, "h 25px!, hidemode 3, cell 0 6");
        this.cbxPrizeFormat.addTo(pnlRestrictions, "h 25px!, w 240px!, pushx, hidemode 3, cell 1 6");
        pnlRestrictions.add((Component)this.btnPrizeDefineCustomFormat, btnStartingCustomFormatWidth + "h 25px!, " + "hidemode 3, " + "cell 1 6");
        pnlRestrictions.add((Component)this.btnPrizeSelectFormat, btnStartingCustomFormatWidth + "h 25px!, " + "hidemode 3, " + "cell 1 6");
        pnlRestrictions.add((Component)this.lblPrizeSameAsStarting, "h 25px!, hidemode 3, cell 1 6");
        pnlRestrictions.add((Component)this.lblPrizeUnrestricted, "h 25px!, hidemode 3, cell 1 6");
        pnlRestrictions.add((Component)this.cboAllowUnlocks, "h 25px!, cell 1 7");
        pnlRestrictions.setOpaque(false);
        this.pnlOptions.add((Component)pnlRestrictions, "pushx, ay top");
        this.pnlOptions.add((Component)this.btnEmbark, "w 300px!, h 30px!, ax center, span 2, gap 0 0 15px 30px");
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, wrap"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitleNew, "w 98%, h 30px!, gap 1% 0 15px 10px");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlOptions, "w 98%!, growy, pushy, gap 1% 0 0 0");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.QUEST;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblStartanewQuest", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return this.getDocumentID();
    }

    public FLabel getBtnEmbark() {
        return this.btnEmbark;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_QUESTSTART;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuQuestStart getLayoutControl() {
        return CSubmenuQuestStart.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    public int getSelectedDifficulty() {
        if (this.radEasy.isSelected()) {
            return 0;
        }
        if (this.radMedium.isSelected()) {
            return 1;
        }
        if (this.radHard.isSelected()) {
            return 2;
        }
        if (this.radExpert.isSelected()) {
            return 3;
        }
        return 0;
    }

    public String getSelectedPrecon() {
        return this.cbxPreconDeck.getSelectedItem();
    }

    public Deck getSelectedDeck() {
        Deck sel = this.cbxCustomDeck.getSelectedItem();
        return sel != null ? sel : null;
    }

    public boolean isUnlockSetsAllowed() {
        return this.cboAllowUnlocks.isSelected();
    }

    public StartingPoolType getStartingPoolType() {
        return this.cbxStartingPool.getSelectedItem();
    }

    public StartingPoolType getPrizedPoolType() {
        Object v = this.cbxPrizedCards.getSelectedItem();
        return v instanceof StartingPoolType ? (StartingPoolType)((Object)v) : null;
    }

    public String getStartingWorldName() {
        return this.cbxStartingWorld.getSelectedItem().toString();
    }

    public boolean isFantasy() {
        return this.boxFantasy.isSelected();
    }

    public boolean isCommander() {
        return this.boxCommander.isSelected();
    }

    public boolean startWithCompleteSet() {
        return this.boxCompleteSet.isSelected();
    }

    public boolean allowDuplicateCards() {
        return this.boxAllowDuplicates.isSelected();
    }

    public boolean randomizeColorDistribution() {
        return false;
    }

    public GameFormat getRotatingFormat() {
        return this.cbxFormat.getSelectedItem();
    }

    public GameFormat getPrizedRotatingFormat() {
        return this.cbxPrizeFormat.getSelectedItem();
    }

    public GameFormat getCasualFormat() {
        return this.cbxFormat.getSelectedItem();
    }

    public GameFormat getPrizedCasualFormat() {
        return this.cbxPrizeFormat.getSelectedItem();
    }

    public FLabel getBtnCustomFormat() {
        return this.btnDefineCustomFormat;
    }

    public FLabel getBtnSelectFormat() {
        return this.btnSelectFormat;
    }

    public FLabel getBtnPrizeSelectFormat() {
        return this.btnPrizeSelectFormat;
    }

    public FLabel getBtnPrizeCustomFormat() {
        return this.btnPrizeDefineCustomFormat;
    }

    public FLabel getBtnPreferredColors() {
        return this.btnPreferredColors;
    }
}

