/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.VHomeUI;
import forge.screens.home.quest.CSubmenuQuestPrefs;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuQuestPrefs implements IVSubmenu<CSubmenuQuestPrefs>
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    final Localizer localizer = Localizer.getInstance();
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblQuestPreferences", new Object[0]));
    private final FLabel lblTitle = new FLabel.Builder().text(this.localizer.getMessage("lblQuestPreferences", new Object[0])).fontAlign(0).opaque(true).fontSize(16).build();
    private final JPanel pnlContent = new JPanel();
    private final FScrollPane scrContent = new FScrollPane(this.pnlContent, false);
    private final JPanel pnlGameSettings = new JPanel();
    private final JPanel pnlRewards = new JPanel();
    private final JPanel pnlDifficulty = new JPanel();
    private final JPanel pnlBooster = new JPanel();
    private final JPanel pnlShop = new JPanel();
    private final JPanel pnlDraftTournaments = new JPanel();
    private final FLabel lblErrGameSettings = new FLabel.Builder().text(this.localizer.getMessage("lblQuestGameSettingsError", new Object[0])).fontStyle(1).build();
    private final FLabel lblErrRewards = new FLabel.Builder().text(this.localizer.getMessage("lblRewardsError", new Object[0])).fontStyle(1).build();
    private final FLabel lblErrDifficulty = new FLabel.Builder().text(this.localizer.getMessage("lblDifficultyError", new Object[0])).fontStyle(1).build();
    private final FLabel lblErrBooster = new FLabel.Builder().text(this.localizer.getMessage("lblBoosterError", new Object[0])).fontStyle(1).build();
    private final FLabel lblErrShop = new FLabel.Builder().text(this.localizer.getMessage("lblShopError", new Object[0])).fontStyle(1).build();
    private final FLabel lblErrDraftTournaments = new FLabel.Builder().text(this.localizer.getMessage("lblDraftTournamentsError", new Object[0])).fontStyle(1).build();
    private final QuestPreferences prefs = FModel.getQuestPreferences();
    private PrefInput focusTarget;
    private static final String fieldConstraints = "w 60px!, h 26px!";
    private static final String labelConstraints = "w 200px!, h 26px!, gap 0 10px 0 0";

    private VSubmenuQuestPrefs() {
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.pnlContent.setOpaque(false);
        this.pnlContent.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.lblErrGameSettings.setForeground(Color.red);
        this.lblErrRewards.setForeground(Color.red);
        this.lblErrDifficulty.setForeground(Color.red);
        this.lblErrBooster.setForeground(Color.red);
        this.lblErrShop.setForeground(Color.red);
        this.lblErrDraftTournaments.setForeground(Color.red);
        FPanel pnlTitleGameSettings = new FPanel();
        pnlTitleGameSettings.setLayout(new MigLayout("insets 0, align center"));
        pnlTitleGameSettings.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        pnlTitleGameSettings.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblQuestGameSettings", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_QUEST_GEAR)).fontSize(16).build(), "h 95%!, gap 0 0 2.5% 0");
        this.pnlContent.add((Component)pnlTitleGameSettings, "w 96%!, h 36px!, gap 2% 0 10px 20px");
        this.pnlContent.add((Component)this.pnlGameSettings, "w 96%!, gap 2% 0 10px 20px");
        this.populateGameSettings();
        FPanel pnlTitleRewards = new FPanel();
        pnlTitleRewards.setLayout(new MigLayout("insets 0, align center"));
        pnlTitleRewards.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        pnlTitleRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblRewards", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_QUEST_COIN)).fontSize(16).build(), "h 95%!, gap 0 0 2.5% 0");
        this.pnlContent.add((Component)pnlTitleRewards, "w 96%!, h 36px!, gap 2% 0 10px 20px");
        this.pnlContent.add((Component)this.pnlRewards, "w 96%!, gap 2% 0 10px 20px");
        this.populateRewards();
        FPanel pnlTitleBooster = new FPanel();
        pnlTitleBooster.setLayout(new MigLayout("insets 0, align center"));
        pnlTitleBooster.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        pnlTitleBooster.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblBoosterPackRatios", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_QUEST_BOOK)).fontSize(16).build(), "h 95%!, gap 0 0 2.5% 0");
        this.pnlContent.add((Component)pnlTitleBooster, "w 96%!, h 36px!, gap 2% 0 10px 10px");
        this.pnlContent.add((Component)this.pnlBooster, "w 96%!, gap 2% 0 10px 20px");
        this.populateBooster();
        FPanel pnlTitleDifficulty = new FPanel();
        pnlTitleDifficulty.setLayout(new MigLayout("insets 0, align center"));
        pnlTitleDifficulty.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        pnlTitleDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblDifficultyAdjustments", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_QUEST_NOTES)).fontSize(16).build(), "h 95%!, gap 0 0 2.5% 0");
        this.pnlContent.add((Component)pnlTitleDifficulty, "w 96%!, h 36px!, gap 2% 0 10px 10px");
        this.pnlContent.add((Component)this.pnlDifficulty, "w 96%!, gap 2% 0 10px 20px");
        this.populateDifficulty();
        FPanel pnlTitleShop = new FPanel();
        pnlTitleShop.setLayout(new MigLayout("insets 0, align center"));
        pnlTitleShop.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        pnlTitleShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblShopPreferences", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_QUEST_COIN)).fontSize(16).build(), "h 95%!, gap 0 0 2.5% 0");
        this.pnlContent.add((Component)pnlTitleShop, "w 96%!, h 36px!, gap 2% 0 10px 10px");
        this.pnlContent.add((Component)this.pnlShop, "w 96%!, gap 2% 0 10px 20px");
        this.populateShop();
        FPanel pnlTitleDraftTournaments = new FPanel();
        pnlTitleDraftTournaments.setLayout(new MigLayout("insets 0, align center"));
        pnlTitleDraftTournaments.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        pnlTitleDraftTournaments.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblDraftTournaments", new Object[0])).icon(FSkin.getIcon(FSkinProp.ICO_QUEST_COIN)).fontSize(16).build(), "h 95%!, gap 0 0 2.5% 0");
        this.pnlContent.add((Component)pnlTitleDraftTournaments, "w 96%!, h 36px!, gap 2% 0 10px 10px");
        this.pnlContent.add((Component)this.pnlDraftTournaments, "w 96%!, gap 2% 0 10px 20px");
        this.populateDraftTournaments();
    }

    @Override
    public void populate() {
        CSubmenuQuestPrefs.resetErrors();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, wrap"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 98%!, h 30px!, gap 1% 0 15px 15px");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.scrContent, "w 98%!, growy, pushy, gap 1% 0 0 20px");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.QUEST;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblQuestPreferences", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_QUESTPREFS;
    }

    public JLabel getLblErrGameSettings() {
        return this.lblErrGameSettings;
    }

    public JLabel getLblErrRewards() {
        return this.lblErrRewards;
    }

    public JLabel getLblErrShop() {
        return this.lblErrShop;
    }

    public JLabel getLblErrDifficulty() {
        return this.lblErrDifficulty;
    }

    public JLabel getLblErrBooster() {
        return this.lblErrBooster;
    }

    public JLabel getLblErrDraftTournaments() {
        return this.lblErrDraftTournaments;
    }

    public void focusFirstTextbox() {
        this.focusTarget.requestFocusInWindow();
    }

    private void populateGameSettings() {
        this.pnlGameSettings.setOpaque(false);
        this.pnlGameSettings.setLayout(new MigLayout("insets 0px, gap 0, wrap 2, hidemode 3"));
        this.pnlGameSettings.removeAll();
        this.pnlGameSettings.add((Component)this.lblErrGameSettings, "w 100%!, h 30px!, span 2 1");
        FLabel worldRulesConformance = new FLabel.Builder().text(this.localizer.getMessage("lblWorldRulesConformance", new Object[0])).fontAlign(4).build();
        worldRulesConformance.setToolTipText(this.localizer.getMessage("ttWorldRulesConformance", new Object[0]));
        this.pnlGameSettings.add((Component)worldRulesConformance, labelConstraints);
        this.focusTarget = new PrefInput(QuestPreferences.QPref.WORLD_RULES_CONFORMANCE, QuestPreferencesErrType.GAME_SETTINGS);
        this.pnlGameSettings.add((Component)this.focusTarget, fieldConstraints);
    }

    private void populateRewards() {
        this.pnlRewards.setOpaque(false);
        this.pnlRewards.setLayout(new MigLayout("insets 0px, gap 0, wrap 2, hidemode 3"));
        this.pnlRewards.removeAll();
        this.pnlRewards.add((Component)this.lblErrRewards, "w 100%!, h 30px!, span 2 1");
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblBaseWinnings", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.focusTarget = new PrefInput(QuestPreferences.QPref.REWARDS_BASE, QuestPreferencesErrType.REWARDS);
        this.pnlRewards.add((Component)this.focusTarget, fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblNoLosses", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_UNDEFEATED, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblPoisonWin", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_POISON, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblMillingWin", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_MILLED, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblMulligan0Win", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_MULLIGAN0, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblAlternativeWin", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_ALTERNATIVE, QuestPreferencesErrType.REWARDS), fieldConstraints);
        FLabel winMulti = new FLabel.Builder().text(this.localizer.getMessage("lblBonusMultiplierperWin", new Object[0])).fontAlign(4).build();
        winMulti.setToolTipText(this.localizer.getMessage("ttBonusMultiplierperWin", new Object[0]));
        this.pnlRewards.add((Component)winMulti, labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_WINS_MULTIPLIER, QuestPreferencesErrType.REWARDS), fieldConstraints);
        FLabel winMultiMax = new FLabel.Builder().text(this.localizer.getMessage("lblMaxWinsforMultiplier", new Object[0])).fontAlign(4).build();
        winMultiMax.setToolTipText(this.localizer.getMessage("ttMaxWinsforMultiplier", new Object[0]));
        this.pnlRewards.add((Component)winMultiMax, labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_WINS_MULTIPLIER_MAX, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinbyTurn15", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_TURN15, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinbyTurn10", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_TURN10, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinbyTurn5", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_TURN5, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblFirstTurnWin", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_TURN1, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblMaxLifeDiffBonus", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.REWARDS_HEALTH_DIFF_MAX, QuestPreferencesErrType.REWARDS), fieldConstraints);
        this.pnlRewards.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblExcludePromosFromRewardPool", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlRewards.add((Component)new PrefInput(QuestPreferences.QPref.EXCLUDE_PROMOS_FROM_POOL, QuestPreferencesErrType.REWARDS), fieldConstraints);
    }

    private void populateDifficulty() {
        this.pnlDifficulty.setOpaque(false);
        this.pnlDifficulty.setLayout(new MigLayout("insets 0, gap 0, wrap 5, hidemode 3"));
        this.pnlDifficulty.removeAll();
        this.pnlDifficulty.add((Component)this.lblErrDifficulty, "w 100%!, h 30px!, span 5 1");
        this.pnlDifficulty.add((Component)new FLabel.Builder().text("").build(), labelConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("questDifficultyEasy", new Object[0])).build(), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("questDifficultyMedium", new Object[0])).build(), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("questDifficultyHard", new Object[0])).build(), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("questDifficultyExpert", new Object[0])).build(), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforBooster", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_BOOSTER_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_BOOSTER_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_BOOSTER_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_BOOSTER_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforRankIncrease", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_RANKUP_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_RANKUP_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_RANKUP_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_RANKUP_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforMediumAI", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_MEDIUMAI_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_MEDIUMAI_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_MEDIUMAI_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_MEDIUMAI_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforHardAI", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_HARDAI_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_HARDAI_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_HARDAI_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_HARDAI_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforExpertAI", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_EXPERTAI_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_EXPERTAI_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_EXPERTAI_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_EXPERTAI_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblStartingCommons", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_COMMONS_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_COMMONS_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_COMMONS_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_COMMONS_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblStartingUncommons", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_UNCOMMONS_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_UNCOMMONS_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_UNCOMMONS_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_UNCOMMONS_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblStartingRares", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_RARES_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_RARES_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_RARES_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_RARES_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblStartingCredits", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_CREDITS_EASY, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_CREDITS_MEDIUM, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_CREDITS_HARD, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_CREDITS_EXPERT, QuestPreferencesErrType.DIFFICULTY), fieldConstraints);
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforNewChallenge", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WINS_NEW_CHALLENGE, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblStartingSnowLands", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_SNOW_LANDS, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        FLabel colorBias = new FLabel.Builder().text(this.localizer.getMessage("lblColorBias", new Object[0])).fontAlign(4).build();
        colorBias.setToolTipText(this.localizer.getMessage("ttColorBias", new Object[0]));
        this.pnlDifficulty.add((Component)colorBias, labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.STARTING_POOL_COLOR_BIAS, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblPenaltyforLoss", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.PENALTY_LOSS, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblMoreDuelChoices", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.MORE_DUEL_CHOICES, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWildOpponentMultiplier", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WILD_OPPONENTS_MULTIPLIER, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        this.pnlDifficulty.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWildOpponentNumber", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDifficulty.add((Component)new PrefInput(QuestPreferences.QPref.WILD_OPPONENTS_NUMBER, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
    }

    private void populateBooster() {
        this.pnlBooster.setOpaque(false);
        this.pnlBooster.setLayout(new MigLayout("insets 0, gap 0, wrap 2, hidemode 3"));
        this.pnlBooster.removeAll();
        this.pnlBooster.add((Component)this.lblErrBooster, "w 100%!, h 30px!, span 2 1");
        this.pnlBooster.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblCommon", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlBooster.add((Component)new PrefInput(QuestPreferences.QPref.BOOSTER_COMMONS, QuestPreferencesErrType.BOOSTER), fieldConstraints);
        this.pnlBooster.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblUncommon", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlBooster.add((Component)new PrefInput(QuestPreferences.QPref.BOOSTER_UNCOMMONS, QuestPreferencesErrType.BOOSTER), fieldConstraints);
        this.pnlBooster.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblRare", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlBooster.add((Component)new PrefInput(QuestPreferences.QPref.BOOSTER_RARES, QuestPreferencesErrType.BOOSTER), fieldConstraints);
        FLabel specialBoosters = new FLabel.Builder().text(this.localizer.getMessage("lblSpecialBoosters", new Object[0])).fontAlign(4).build();
        specialBoosters.setToolTipText(this.localizer.getMessage("ttSpecialBoosters", new Object[0]));
        this.pnlBooster.add((Component)specialBoosters, labelConstraints);
        this.pnlBooster.add((Component)new PrefInput(QuestPreferences.QPref.SPECIAL_BOOSTERS, QuestPreferencesErrType.BOOSTER), fieldConstraints);
    }

    private void populateShop() {
        this.pnlShop.setOpaque(false);
        this.pnlShop.setLayout(new MigLayout("insets 0, gap 0, wrap 2, hidemode 3"));
        this.pnlShop.removeAll();
        this.pnlShop.add((Component)this.lblErrShop, "w 100%!, h 30px!, span 2 1");
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblMaximumPacks", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_MAX_PACKS, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblMinimumPacks", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_MIN_PACKS, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblStartingPacks", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_STARTING_PACKS, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforPack", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_WINS_FOR_ADDITIONAL_PACK, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsperSetUnlock", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.WINS_UNLOCK_SET, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblAllowFarUnlocks", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.UNLIMITED_UNLOCKING, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblUnlockDistanceMultiplier", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.UNLOCK_DISTANCE_MULTIPLIER, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblCommonSingles", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_SINGLES_COMMON, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblUncommonSingles", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_SINGLES_UNCOMMON, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblRareSingles", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_SINGLES_RARE, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblCardSalePercentageBase", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_SELLING_PERCENTAGE_BASE, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblCardSalePercentageCap", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_SELLING_PERCENTAGE_MAX, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblCardSalePriceCap", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_MAX_SELLING_PRICE, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinstoUncapSalePrice", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.SHOP_WINS_FOR_NO_SELL_LIMIT, QuestPreferencesErrType.SHOP), fieldConstraints);
        FLabel extraCardsToKeep = new FLabel.Builder().text(this.localizer.getMessage("lblPlaysetSize", new Object[0])).fontAlign(4).build();
        extraCardsToKeep.setToolTipText(this.localizer.getMessage("ttPlaysetSize", new Object[0]));
        this.pnlShop.add((Component)extraCardsToKeep, labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.PLAYSET_SIZE, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        FLabel extraLandsToKeep = new FLabel.Builder().text(this.localizer.getMessage("lblPlaysetSizeBasicLand", new Object[0])).fontAlign(4).build();
        extraLandsToKeep.setToolTipText(this.localizer.getMessage("ttPlaysetSizeBasicLand", new Object[0]));
        this.pnlShop.add((Component)extraLandsToKeep, labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.PLAYSET_BASIC_LAND_SIZE, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        FLabel infiniteToKeep = new FLabel.Builder().text(this.localizer.getMessage("lblPlaysetSizeAnyNumber", new Object[0])).fontAlign(4).build();
        infiniteToKeep.setToolTipText(this.localizer.getMessage("ttPlaysetSizeAnyNumber", new Object[0]));
        this.pnlShop.add((Component)infiniteToKeep, labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.PLAYSET_ANY_NUMBER_SIZE, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblItemLevelRestriction", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.ITEM_LEVEL_RESTRICTION, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblFoilfilterAlwaysOn", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.FOIL_FILTER_DEFAULT, QuestPreferencesErrType.SHOP), fieldConstraints);
        this.pnlShop.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblRatingsfilterAlwaysOn", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlShop.add((Component)new PrefInput(QuestPreferences.QPref.RATING_FILTER_DEFAULT, QuestPreferencesErrType.SHOP), fieldConstraints);
    }

    private void populateDraftTournaments() {
        this.pnlDraftTournaments.setOpaque(false);
        this.pnlDraftTournaments.setLayout(new MigLayout("insets 0, gap 0, wrap 2, hidemode 3"));
        this.pnlDraftTournaments.removeAll();
        this.pnlDraftTournaments.add((Component)this.lblErrDraftTournaments, "w 100%!, h 30px!, span 2 1");
        FLabel randomAIMatches = new FLabel.Builder().text(this.localizer.getMessage("lblSimulateAIvsAIResults", new Object[0])).fontAlign(4).build();
        randomAIMatches.setToolTipText(this.localizer.getMessage("ttSimulateAIvsAIResults", new Object[0]));
        this.pnlDraftTournaments.add((Component)randomAIMatches, labelConstraints);
        this.pnlDraftTournaments.add((Component)new PrefInput(QuestPreferences.QPref.SIMULATE_AI_VS_AI_RESULTS, QuestPreferencesErrType.DRAFT_TOURNAMENTS), fieldConstraints);
        this.pnlDraftTournaments.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblWinsforNewDraft", new Object[0])).fontAlign(4).build(), labelConstraints);
        this.pnlDraftTournaments.add((Component)new PrefInput(QuestPreferences.QPref.WINS_NEW_DRAFT, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        FLabel rotationAmount = new FLabel.Builder().text(this.localizer.getMessage("lblWinsperDraftRotation", new Object[0])).fontAlign(4).build();
        rotationAmount.setToolTipText(this.localizer.getMessage("ttWinsperDraftRotation", new Object[0]));
        this.pnlDraftTournaments.add((Component)rotationAmount, labelConstraints);
        this.pnlDraftTournaments.add((Component)new PrefInput(QuestPreferences.QPref.WINS_ROTATE_DRAFT, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
        FLabel rotationType = new FLabel.Builder().text(this.localizer.getMessage("lblRotationType", new Object[0])).fontAlign(4).build();
        rotationType.setToolTipText(this.localizer.getMessage("ttRotationType", new Object[0]));
        this.pnlDraftTournaments.add((Component)rotationType, labelConstraints);
        this.pnlDraftTournaments.add((Component)new PrefInput(QuestPreferences.QPref.DRAFT_ROTATION, QuestPreferencesErrType.DIFFICULTY), "w 60px!, h 26px!, wrap");
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_QUESTPREFS;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuQuestPrefs getLayoutControl() {
        return CSubmenuQuestPrefs.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    public class PrefInput
    extends FSkin.SkinnedTextField {
        private final QuestPreferences.QPref qpref;
        private final QuestPreferencesErrType err;
        private final FSkin.SkinColor clrHover;
        private final FSkin.SkinColor clrActive;
        private final FSkin.SkinColor clrText;
        private boolean isFocus = false;
        private String previousText = "";

        public PrefInput(QuestPreferences.QPref qp0, QuestPreferencesErrType e0) {
            this.qpref = qp0;
            this.err = e0;
            this.clrHover = FSkin.getColor(FSkin.Colors.CLR_HOVER);
            this.clrActive = FSkin.getColor(FSkin.Colors.CLR_ACTIVE);
            this.clrText = FSkin.getColor(FSkin.Colors.CLR_TEXT);
            this.setOpaque(false);
            this.setBorder((Border)null);
            this.setFont(FSkin.getRelativeFont(13));
            this.setForeground(this.clrText);
            this.setCaretColor(this.clrText);
            this.setBackground(this.clrHover);
            this.setHorizontalAlignment(0);
            this.setText(VSubmenuQuestPrefs.this.prefs.getPref(this.qpref));
            this.setPreviousText(VSubmenuQuestPrefs.this.prefs.getPref(this.qpref));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (PrefInput.this.isFocus) {
                        return;
                    }
                    PrefInput.this.setOpaque(true);
                    PrefInput.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (PrefInput.this.isFocus) {
                        return;
                    }
                    PrefInput.this.setOpaque(false);
                    PrefInput.this.repaint();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    PrefInput.this.isFocus = true;
                    PrefInput.this.setOpaque(true);
                    PrefInput.this.setBackground(PrefInput.this.clrActive);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    PrefInput.this.isFocus = false;
                    PrefInput.this.setOpaque(false);
                    PrefInput.this.setBackground(PrefInput.this.clrHover);
                    CSubmenuQuestPrefs.validateAndSave(PrefInput.this);
                }
            });
        }

        public QuestPreferences.QPref getQPref() {
            return this.qpref;
        }

        public QuestPreferencesErrType getErrType() {
            return this.err;
        }

        public String getPreviousText() {
            return this.previousText;
        }

        public void setPreviousText(String s0) {
            this.previousText = s0;
        }
    }

    public static enum QuestPreferencesErrType {
        GAME_SETTINGS,
        REWARDS,
        DIFFICULTY,
        BOOSTER,
        SHOP,
        DRAFT_TOURNAMENTS;

    }
}

