/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.Singletons;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.quest.IQuestTournamentView;
import forge.gamemodes.quest.QuestDraftUtils;
import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.data.QuestEventDraftContainer;
import forge.gui.GuiBase;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.itemmanager.DeckManager;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorQuestDraftingProcess;
import forge.screens.deckeditor.controllers.CEditorQuestLimited;
import forge.screens.deckeditor.views.VCurrentDeck;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.LblHeader;
import forge.screens.home.StartButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.quest.CSubmenuQuestDraft;
import forge.screens.home.quest.PnlDraftEvent;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FLabel;
import forge.toolbox.FRadioButton;
import forge.toolbox.FScrollPanel;
import forge.toolbox.FSkin;
import forge.toolbox.JXButtonPanel;
import forge.util.Localizer;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuQuestDraft implements IVSubmenu<CSubmenuQuestDraft>,
IQuestTournamentView
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblTournaments", new Object[0]));
    private final LblHeader lblTitle = new LblHeader(this.localizer.getMessage("lblQuestModeDraftTournament", new Object[0]));
    private final FLabel lblCredits = new FLabel.Builder().icon(FSkin.getIcon(FSkinProp.ICO_QUEST_COINSTACK)).iconScaleFactor(0.75).fontSize(14).build();
    private final FScrollPanel pnlTournaments = new FScrollPanel(new MigLayout("insets 0, gap 0, wrap, ax center"), true, 20, 31);
    private final JLabel lblInfo = new FLabel.Builder().text(this.localizer.getMessage("lblSelectaTournament", new Object[0]) + ":").fontStyle(1).fontSize(16).fontAlign(2).build();
    private final JLabel lblNoDrafts = new FLabel.Builder().text(this.localizer.getMessage("lblNoTournaments", new Object[0])).fontStyle(0).fontSize(16).fontAlign(2).build();
    private final JPanel pnlStats = new JPanel();
    private final FLabel lblPastResults = new FLabel.Builder().text(this.localizer.getMessage("lblPastResults", new Object[0]) + ":").fontSize(19).build();
    private final FLabel lblFirst = new FLabel.Builder().fontSize(15).build();
    private final FLabel lblSecond = new FLabel.Builder().fontSize(15).build();
    private final FLabel lblThird = new FLabel.Builder().fontSize(15).build();
    private final FLabel lblFourth = new FLabel.Builder().fontSize(15).build();
    private final StartButton btnStartDraft = new StartButton();
    private final StartButton btnStartTournament = new StartButton();
    private final StartButton btnStartMatch = new StartButton();
    private final FLabel btnEditDeck = new FLabel.ButtonBuilder().text(this.localizer.getMessage("btnEditDeck", new Object[0])).fontSize(24).build();
    private final FLabel btnLeaveTournament = new FLabel.ButtonBuilder().text(this.localizer.getMessage("btnLeaveTournament", new Object[0])).fontSize(12).build();
    private final FLabel btnSpendToken = new FLabel.ButtonBuilder().text(this.localizer.getMessage("btnSpendToken", new Object[0])).fontSize(14).build();
    private final FLabel btnStartMatchSmall = new FLabel.ButtonBuilder().text(this.localizer.getMessage("btnStartMatchSmall", new Object[0])).fontSize(12).build();
    private final PnlMatchup[] matchups = new PnlMatchup[8];
    private final JPanel pnlDeckImage;
    private QuestDraftUtils.Mode mode = QuestDraftUtils.Mode.SELECT_TOURNAMENT;
    private DragCell parentCell;
    private final KeyAdapter startOnEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if ('\n' == e.getKeyChar()) {
                VSubmenuQuestDraft.this.btnStartDraft.doClick();
            }
        }
    };
    private final MouseAdapter startOnDblClick = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (1 == e.getButton() && 2 == e.getClickCount()) {
                VSubmenuQuestDraft.this.btnStartDraft.doClick();
            }
        }
    };

    private VSubmenuQuestDraft() {
        FSkin.SkinImage avatar = FSkin.getAvatars().get(GuiBase.getInterface().getAvatarCount() - 1);
        this.matchups[0] = new PnlMatchup(PnlMatchup.LineDirection.DOWN, PnlMatchup.LineSide.RIGHT, PnlMatchup.BoxSize.SMALL);
        this.matchups[0].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[0].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[1] = new PnlMatchup(PnlMatchup.LineDirection.UP, PnlMatchup.LineSide.RIGHT, PnlMatchup.BoxSize.SMALL);
        this.matchups[1].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[1].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[2] = new PnlMatchup(PnlMatchup.LineDirection.DOWN, PnlMatchup.LineSide.RIGHT, PnlMatchup.BoxSize.SMALL);
        this.matchups[2].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[2].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[3] = new PnlMatchup(PnlMatchup.LineDirection.UP, PnlMatchup.LineSide.RIGHT, PnlMatchup.BoxSize.SMALL);
        this.matchups[3].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[3].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[4] = new PnlMatchup(PnlMatchup.LineDirection.DOWN, PnlMatchup.LineSide.BOTH, PnlMatchup.BoxSize.MEDIUM);
        this.matchups[4].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[4].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[5] = new PnlMatchup(PnlMatchup.LineDirection.UP, PnlMatchup.LineSide.BOTH, PnlMatchup.BoxSize.MEDIUM);
        this.matchups[5].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[5].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[6] = new PnlMatchup(PnlMatchup.LineDirection.STRAIGHT, PnlMatchup.LineSide.BOTH, PnlMatchup.BoxSize.LARGE);
        this.matchups[6].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[6].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[7] = new PnlMatchup(PnlMatchup.LineDirection.STRAIGHT, PnlMatchup.LineSide.LEFT, PnlMatchup.BoxSize.LARGE_SINGLE, true);
        this.matchups[7].setPlayerOne(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.matchups[7].setPlayerTwo(this.localizer.getMessage("lblUndetermined", new Object[0]), avatar);
        this.pnlDeckImage = new ProportionalPanel(FSkin.getImage(FSkinProp.IMG_QUEST_DRAFT_DECK), 680, 475);
        String constraints = "h 30px!, gap 0 0 0 10px";
        this.pnlStats.setLayout(new MigLayout("insets 0, gap 0, wrap, hidemode 0"));
        this.pnlStats.add((Component)this.lblPastResults, "h 30px!, gap 0 0 0 25px");
        this.pnlStats.add((Component)this.lblFirst, "h 30px!, gap 0 0 0 10px");
        this.pnlStats.add((Component)this.lblSecond, "h 30px!, gap 0 0 0 10px");
        this.pnlStats.add((Component)this.lblThird, "h 30px!, gap 0 0 0 10px");
        this.pnlStats.add((Component)this.lblFourth, "h 30px!, gap 0 0 0 10px");
        this.pnlStats.add((Component)this.btnSpendToken, "w 150px!, h 40px!, ax center");
        this.pnlStats.setOpaque(false);
        this.btnSpendToken.setToolTipText(this.localizer.getMessage("btnSpendTokenTT", new Object[0]));
    }

    public LblHeader getLblTitle() {
        return this.lblTitle;
    }

    @Override
    public FLabel getLblCredits() {
        return this.lblCredits;
    }

    public FScrollPanel getPnlTournaments() {
        return this.pnlTournaments;
    }

    public StartButton getBtnStartDraft() {
        return this.btnStartDraft;
    }

    public StartButton getBtnStartTournament() {
        return this.btnStartTournament;
    }

    public StartButton getBtnStartMatch() {
        return this.btnStartMatch;
    }

    public FLabel getBtnStartMatchSmall() {
        return this.btnStartMatchSmall;
    }

    public FLabel getBtnEditDeck() {
        return this.btnEditDeck;
    }

    @Override
    public FLabel getBtnLeaveTournament() {
        return this.btnLeaveTournament;
    }

    public PnlMatchup[] getLblsMatchups() {
        return this.matchups;
    }

    @Override
    public FLabel getLblFirst() {
        return this.lblFirst;
    }

    @Override
    public FLabel getLblSecond() {
        return this.lblSecond;
    }

    @Override
    public FLabel getLblThird() {
        return this.lblThird;
    }

    @Override
    public FLabel getLblFourth() {
        return this.lblFourth;
    }

    @Override
    public FLabel getBtnSpendToken() {
        return this.btnSpendToken;
    }

    @Override
    public void setMode(QuestDraftUtils.Mode mode) {
        this.mode = mode;
    }

    @Override
    public QuestDraftUtils.Mode getMode() {
        return this.mode;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_QUESTDRAFTS;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuQuestDraft getLayoutControl() {
        return CSubmenuQuestDraft.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.QUEST;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblTournaments", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_QUESTDRAFTS;
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        switch (this.mode) {
            case SELECT_TOURNAMENT: {
                this.populateSelectTournament();
                break;
            }
            case PREPARE_DECK: {
                this.populatePrepareDeck();
                break;
            }
            case TOURNAMENT_ACTIVE: {
                this.populateTournamentActive();
                break;
            }
            default: {
                VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, ax right, wrap 2"));
                VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 80%!, h 40px!, gap 0 0 15px 35px, ax right, span 2");
                VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblNoDrafts, "h 30px!, gap 0 0 5px, span 2");
                VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlTournaments, "w 88% - 200px!, pushy, growy");
                VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlStats, "w 185px!, pushy, growy, gap 4% 4% 0 0");
            }
        }
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    private void populateSelectTournament() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, ax right, wrap 2"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 80%!, h 40px!, gap 0 0 15px 35px, ax right, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblCredits, "h 25px!, gap 0 0 30px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblInfo, "h 30px!, gap 0 0 5px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlTournaments, "w 88% - 200px!, pushy, growy");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlStats, "w 185px!, pushy, growy, gap 4% 4% 0 0");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnStartDraft, "gap 0 6% 30px 30px, ax center, span 2");
    }

    private void populatePrepareDeck() {
        this.lblTitle.setText(this.localizer.getMessage("lblQuestModeDraftTournament", new Object[0]) + " - " + FModel.getQuest().getAchievements().getCurrentDraft().getTitle());
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, ax center, wrap", "", "[][grow, center][][][]"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 80%!, h 40px!, gap 20% 0 15px 35px, ax right");
        this.pnlDeckImage.setMaximumSize(new Dimension(680, 475));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlDeckImage, "ax center, grow");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnEditDeck, "w 150px, h 50px, gap 0 0 15px 0, ax center");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnStartTournament, "gap 0 0 0 15px, ax center");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnLeaveTournament, "w 150px, h 35px, gap 0 0 25px 10%, ax center");
        this.btnEditDeck.setFontSize(24);
        this.btnLeaveTournament.setFontSize(12);
    }

    private void populateTournamentActive() {
        this.lblTitle.setText(this.localizer.getMessage("lblQuestModeDraftTournament", new Object[0]) + " - " + FModel.getQuest().getAchievements().getCurrentDraft().getTitle());
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, ax center, wrap 1"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 80%!, h 40px!, gap 20% 0 15px 10px, ax right, span 2");
        FScrollPanel panel = new FScrollPanel(new MigLayout("insets 0, gap 0, wrap 4, ax center"), true, 20, 30);
        String constraintsLeft = "w 350px!, h 196px!, gap 0px 0px 0px 0px, ay center";
        String constraintsMiddle = "w 350px!, h 392px!, gap 0px 0px 0px 0px, ay center";
        String constraintsRight = "w 350px!, h 784px!, gap 0px 0px 0px 0px, ay center";
        panel.add((Component)this.matchups[0], constraintsLeft);
        panel.add((Component)this.matchups[4], constraintsMiddle + ", span 1 2");
        panel.add((Component)this.matchups[6], constraintsRight + ", span 1 4");
        panel.add((Component)this.matchups[7], constraintsRight + ", span 1 4");
        panel.add((Component)this.matchups[1], constraintsLeft);
        panel.add((Component)this.matchups[2], constraintsLeft);
        panel.add((Component)this.matchups[5], constraintsMiddle + ", span 1 2");
        panel.add((Component)this.matchups[3], constraintsLeft);
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)panel, "gap 0 0 0 0, ax center");
        this.btnEditDeck.setFontSize(12);
        JPanel bottomButtons = new JPanel(new MigLayout("insets 0, gap 0, wrap 2, ax center"));
        if (FModel.getQuest().getAchievements().getCurrentDraft().playerHasMatchesLeft()) {
            VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnStartMatch, "gap 0 0 0 20px, ax center");
            bottomButtons.add((Component)this.btnEditDeck, "w 135px!, h 25px!, gap 0 25px 10px 10px, ax right");
            bottomButtons.add((Component)this.btnLeaveTournament, "w 135px!, h 25px!, gap 25px 0 10px 10px, ax right");
            this.btnLeaveTournament.setFontSize(12);
        } else {
            VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnLeaveTournament, "w 250px!, h 60px!, gap 0 0 20px 20px, ax center");
            bottomButtons.add((Component)this.btnEditDeck, "w 135px!, h 25px!, gap 0 25px 10px 10px, ax right");
            bottomButtons.add((Component)this.btnStartMatchSmall, "w 135px!, h 25px!, gap 25px 0 10px 10px, ax right");
            this.btnLeaveTournament.setFontSize(24);
        }
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)bottomButtons, "w 100%!");
        bottomButtons.setOpaque(false);
    }

    @Override
    public void updateEventList(QuestEventDraftContainer events) {
        this.pnlTournaments.removeAll();
        if (events == null) {
            return;
        }
        JXButtonPanel grpPanel = new JXButtonPanel();
        boolean firstPanel = true;
        for (QuestEventDraft draft : events) {
            PnlDraftEvent draftPanel = new PnlDraftEvent(draft);
            FRadioButton button = draftPanel.getRadioButton();
            if (firstPanel) {
                button.setSelected(true);
                SwingUtilities.invokeLater(button::requestFocusInWindow);
                firstPanel = false;
            }
            grpPanel.add((Component)draftPanel, button, "w 100%!, h 135px!, gapy 15px");
            button.addKeyListener(this.startOnEnter);
            button.addMouseListener(this.startOnDblClick);
        }
        this.pnlTournaments.add((Component)grpPanel, "w 100%!");
    }

    @Override
    public void updateTournamentBoxLabel(String playerID, int iconID, int box, boolean first) {
        FSkin.SkinImage icon = FSkin.getAvatars().get(iconID);
        if (icon == null) {
            icon = FSkin.getAvatars().get(0);
        }
        if (first) {
            this.matchups[box].setPlayerOne(playerID, icon);
        } else {
            this.matchups[box].setPlayerTwo(playerID, icon);
        }
    }

    @Override
    public void startDraft(BoosterDraft draft) {
        CEditorQuestDraftingProcess draftController = new CEditorQuestDraftingProcess(CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture());
        draftController.showGui(draft);
        draftController.setDraftQuest(CSubmenuQuestDraft.SINGLETON_INSTANCE);
        Singletons.getControl().setCurrentScreen(FScreen.DRAFTING_PROCESS);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(draftController);
    }

    @Override
    public void editDeck(boolean isExistingDeck) {
        CDetailPicture cDetailPicture = CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture();
        if (isExistingDeck) {
            VCurrentDeck.SINGLETON_INSTANCE.setItemManager(new DeckManager(GameType.Draft, cDetailPicture));
        }
        Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_QUEST_TOURNAMENT);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorQuestLimited(FModel.getQuest(), cDetailPicture));
    }

    public static class PnlMatchup
    extends JPanel {
        private static final long serialVersionUID = 2055607559359905216L;
        private final FSkin.SkinColor clr1 = FSkin.getColor(FSkin.Colors.CLR_THEME2).alphaColor(255);
        private final FSkin.SkinColor clr2 = FSkin.getColor(FSkin.Colors.CLR_THEME).alphaColor(100);
        private final FSkin.SkinColor clr3 = FSkin.getColor(FSkin.Colors.CLR_THEME).alphaColor(100);
        private final int wImg = 55;
        private final int hImg = 55;
        private FSkin.SkinImage img1;
        private FSkin.SkinImage img2;
        private FLabel name1 = new FLabel.Builder().fontSize(14).fontAlign(2).build();
        private FLabel name2 = new FLabel.Builder().fontSize(14).fontAlign(2).build();
        private LineDirection lineDir;
        private LineSide lineSide;
        private BoxSize size;
        private boolean singleBox;

        public PnlMatchup(LineDirection dir, LineSide side, BoxSize size, boolean singleBox) {
            this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
            if (!singleBox) {
                this.add((Component)this.name1, "w 100%!, h 50% - 30px!, gap 135px 0 0 30px, ax right");
                this.add((Component)this.name2, "w 100%!, h 50% - 30px!, gap 135px 0 31px 0, ax right");
            } else {
                this.add((Component)this.name1, "w 100%!, h 50%!, gap 135px 0 11px 0, ax right");
            }
            this.lineDir = dir;
            this.lineSide = side;
            this.size = size;
            this.singleBox = singleBox;
            this.name1.setVerticalAlignment(3);
            this.name2.setVerticalAlignment(1);
        }

        public PnlMatchup(LineDirection dir, LineSide side, BoxSize size) {
            this(dir, side, size, false);
        }

        public void setPlayerOne(String name, FSkin.SkinImage image) {
            this.name1.setText(name);
            this.img1 = image;
        }

        public void setPlayerTwo(String name, FSkin.SkinImage image) {
            this.name2.setText(name);
            this.img2 = image;
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2.create();
            int width = this.getWidth() - 100;
            int height = this.getHeight() - 40;
            if (this.size.equals((Object)BoxSize.MEDIUM)) {
                height -= 196;
                g2d.translate(0, 98);
            } else if (this.size.equals((Object)BoxSize.LARGE)) {
                height -= 588;
                g2d.translate(0, 294);
            } else if (this.size.equals((Object)BoxSize.LARGE_SINGLE)) {
                height -= 665;
                g2d.translate(0, 333);
            }
            g2d.setColor(this.clr1.getColor());
            g2d.setStroke(new BasicStroke(4.0f));
            if (this.lineSide.equals((Object)LineSide.LEFT) || this.lineSide.equals((Object)LineSide.BOTH)) {
                g2d.drawLine(0, height / 2 + 20, 47, height / 2 + 20);
            }
            g2d.translate(50, 20);
            if (this.lineSide.equals((Object)LineSide.RIGHT) || this.lineSide.equals((Object)LineSide.BOTH)) {
                g2d.drawLine(width, height / 2, width + 65, height / 2);
                if (this.lineDir.equals((Object)LineDirection.DOWN)) {
                    g2d.drawLine(width + 48, height / 2, width + 48, height + 400);
                } else if (this.lineDir.equals((Object)LineDirection.UP)) {
                    g2d.drawLine(width + 48, height / 2, width + 48, -400);
                } else if (this.lineDir.equals((Object)LineDirection.STRAIGHT)) {
                    g2d.drawLine(width, height / 2, width + 45, height / 2);
                }
            }
            FSkin.setGraphicsGradientPaint(g2d, 0.0f, 0.0f, this.clr3, 0.0f, (float)(height / 2 + 15), this.clr2);
            g2d.fillRect(0, 0, width, height / 2);
            FSkin.setGraphicsGradientPaint(g2d, 0.0f, (float)(height / 2 - 15), this.clr2, 0.0f, (float)height, this.clr3);
            g2d.fillRect(0, height / 2, width, height / 2);
            g2d.setColor(this.clr1.getColor());
            g2d.setStroke(new BasicStroke(4.0f));
            g2d.drawRect(1, 1, width - 2, height - 2);
            if (!this.singleBox) {
                FSkin.setGraphicsGradientPaint(g2d, 70.0f, (float)(height / 2 - 1), this.clr1.alphaColor(0), (float)width, (float)(height / 2 - 1), this.clr1);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawRect(70, height / 2 - 1, width - 70, 2);
            }
            g2d.setColor(FSkin.getColor(FSkin.Colors.CLR_TEXT).getColor());
            g2d.setStroke(new BasicStroke(1.0f));
            if (!this.singleBox) {
                Rectangle2D textSize = g2d.getFontMetrics().getStringBounds("VS", g2d);
                g2d.drawString("VS", (width + (int)textSize.getWidth()) / 2, (height + (int)textSize.getHeight()) / 2 - 2);
            }
            g2d.translate(12, 12);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            Dimension srcSize = this.img1.getSizeForPaint(g2d);
            int wSrc = srcSize.width;
            int hSrc = srcSize.height;
            FSkin.drawImage(g2d, this.img1, 0, 0, 55, 55, 0, 0, wSrc, hSrc);
            g2d.translate(0, 77);
            if (!this.singleBox) {
                FSkin.drawImage(g2d, this.img2, 0, 0, 55, 55, 0, 0, wSrc, hSrc);
            }
            g2d.dispose();
        }

        private static enum BoxSize {
            SMALL,
            MEDIUM,
            LARGE,
            LARGE_SINGLE;

        }

        private static enum LineSide {
            LEFT,
            RIGHT,
            BOTH;

        }

        private static enum LineDirection {
            UP,
            DOWN,
            STRAIGHT,
            NONE;

        }
    }

    private final class ProportionalDimension
    extends Dimension {
        private static final long serialVersionUID = -428811386088062426L;

        private ProportionalDimension(Dimension d, int w, int h2) {
            double containerAspect = (double)d.width / (double)d.height;
            double imageAspect = (double)w / (double)h2;
            double scale = 1.0;
            if (imageAspect < containerAspect) {
                scale = (double)d.height / (double)h2;
            } else if (imageAspect > containerAspect) {
                scale = (double)d.width / (double)w;
            }
            this.height = (int)((double)h2 * scale);
            this.width = (int)((double)w * scale);
        }
    }

    private final class ProportionalPanel
    extends JPanel {
        private static final long serialVersionUID = 2098643413467094674L;
        private final FSkin.SkinImage image;
        int w;
        int h;

        private ProportionalPanel(FSkin.SkinImage image, int w, int h2) {
            this.image = image;
            this.w = w;
            this.h = h2;
        }

        @Override
        public Dimension getPreferredSize() {
            return new ProportionalDimension(super.getSize(), this.w, this.h);
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2.create();
            Dimension srcSize = this.image.getSizeForPaint(g2d);
            int wSrc = srcSize.width;
            int hSrc = srcSize.height;
            int wImg = this.getPreferredSize().width;
            int hImg = this.getPreferredSize().height;
            int xOffset = (this.getSize().width - wImg) / 2;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHints(hints);
            FSkin.drawImage(g2d, this.image, xOffset, 0, wImg + xOffset, hImg, 0, 0, wSrc, hSrc);
            g2d.dispose();
        }
    }
}

