/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.QuestData;
import forge.gui.UiCommand;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class QuestFileLister
extends JPanel {
    private FSkin.SkinIcon icoDelete;
    private FSkin.SkinIcon icoDeleteOver;
    private FSkin.SkinIcon icoEdit;
    private FSkin.SkinIcon icoEditOver;
    private RowPanel previousSelect;
    private RowPanel[] rows;
    private UiCommand cmdRowSelect;
    private UiCommand cmdRowDelete;
    private UiCommand cmdRowEdit;
    private final Color clrDefault = new Color(0, 0, 0, 0);
    private final FSkin.SkinColor clrHover = FSkin.getColor(FSkin.Colors.CLR_HOVER);
    private final FSkin.SkinColor clrActive = FSkin.getColor(FSkin.Colors.CLR_ACTIVE);
    private final FSkin.SkinColor clrBorders = FSkin.getColor(FSkin.Colors.CLR_BORDERS);

    public QuestFileLister() {
        this(true, true);
    }

    public QuestFileLister(boolean deletable, boolean editable) {
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.icoDelete = FSkin.getIcon(FSkinProp.ICO_DELETE);
        this.icoDeleteOver = FSkin.getIcon(FSkinProp.ICO_DELETE_OVER);
        this.icoEdit = FSkin.getIcon(FSkinProp.ICO_EDIT);
        this.icoEditOver = FSkin.getIcon(FSkinProp.ICO_EDIT_OVER);
    }

    public void setQuests(List<QuestData> qd0) {
        this.removeAll();
        ArrayList<RowPanel> tempRows = new ArrayList<RowPanel>();
        ArrayList<QuestData> sorted = new ArrayList<QuestData>(qd0);
        sorted.sort(Comparator.comparing(x -> x.getName().toLowerCase()));
        FSkin.SkinnedPanel rowTitle = new FSkin.SkinnedPanel();
        rowTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        rowTitle.setLayout(new MigLayout("insets 0, gap 0"));
        rowTitle.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblNameAndRank", new Object[0])).fontAlign(2).build(), "w 60%!, h 20px!, gaptop 5px, gapleft 48px");
        rowTitle.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblModeAndDifficulty", new Object[0])).fontAlign(2).build(), "w 40% - 112px!, h 20px!, gaptop 5px, gapleft 4px");
        rowTitle.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblRecordAndAssets", new Object[0])).fontAlign(2).build(), "w 120px!, h 20px!, gaptop 5px, gapleft 4px");
        this.add((Component)rowTitle, "w 98%!, h 30px!, gapleft 1%");
        HashMap<Integer, String> difficultyNameMap = new HashMap<Integer, String>();
        difficultyNameMap.put(0, Localizer.getInstance().getMessage("questDifficultyEasy", new Object[0]));
        difficultyNameMap.put(1, Localizer.getInstance().getMessage("questDifficultyMedium", new Object[0]));
        difficultyNameMap.put(2, Localizer.getInstance().getMessage("questDifficultyHard", new Object[0]));
        difficultyNameMap.put(3, Localizer.getInstance().getMessage("questDifficultyExpert", new Object[0]));
        for (QuestData qd : sorted) {
            String mode = qd.getMode().toString();
            RowPanel row = new RowPanel(qd);
            row.add((Component)new DeleteButton(row), "w 22px!, h 20px!, cell 0 0 1 2");
            row.add((Component)new EditButton(row), "w 22px!, h 20px!, cell 1 0 1 2");
            row.add((Component)new FLabel.Builder().text(qd.getName()).fontAlign(2).fontStyle(1).build(), "w 60%, h 20px!, shrinkx, gaptop 5px, gapleft 4px, cell 2 0 1 1");
            row.add((Component)new FLabel.Builder().text(FModel.getQuest().getRank(qd.getAchievements().getLevel())).fontAlign(2).fontSize(12).build(), "w 60%, h 20px!, shrinkx, gapbottom 5px, gapleft 4px, cell 2 1 1 1");
            row.add((Component)new FLabel.Builder().text(mode).fontAlign(2).build(), "h 20px!, gaptop 5px, gapleft 4px, cell 3 0 1 1");
            row.add((Component)new FLabel.Builder().text((String)difficultyNameMap.get(qd.getAchievements().getDifficulty())).fontAlign(2).fontSize(12).build(), "h 20px!, pushx, gapbottom 5px, gapleft 4px, cell 3 1 1 1");
            row.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblXWinOfYLost", qd.getAchievements().getWin(), qd.getAchievements().getLost())).fontAlign(4).build(), "h 20px!, gaptop 5px, gapleft 4px, gapright 5px, cell 4 0 1 1, align right");
            FLabel cardsLabel = new FLabel.Builder().text(String.valueOf(qd.getAssets().getCardPool().countAll())).fontAlign(2).fontSize(12).icon(FSkin.getImage(FSkinProp.IMG_ZONE_HAND)).build();
            FLabel goldLabel = new FLabel.Builder().text(String.valueOf(qd.getAssets().getCredits())).fontAlign(2).fontSize(12).icon(FSkin.getImage(FSkinProp.ICO_QUEST_GOLD)).build();
            row.add((Component)cardsLabel, "h 20px!, gapbottom 5px, cell 4 1 1 1");
            row.add((Component)goldLabel, "h 20px!, gapleft 10px, gapright 5px, gapbottom 5px, cell 4 1 1 1");
            this.add((Component)row, "w 98%!, h 50px!, gap 1% 0 0 0");
            tempRows.add(row);
        }
        this.rows = tempRows.toArray(new RowPanel[0]);
        this.revalidate();
    }

    public QuestData getSelectedQuest() {
        return this.previousSelect.getQuestData();
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.rows.length; ++i) {
            if (!this.rows[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public boolean setSelectedIndex(int i0) {
        if (i0 >= this.rows.length) {
            return false;
        }
        this.selectHandler(this.rows[i0]);
        return true;
    }

    public boolean setSelectedQuestData(QuestData qd0) {
        for (RowPanel r : this.rows) {
            if (!r.getQuestData().getName().equals(qd0.getName())) continue;
            this.selectHandler(r);
            return true;
        }
        return false;
    }

    public void setSelectCommand(UiCommand c0) {
        this.cmdRowSelect = c0;
    }

    public void setEditCommand(UiCommand c0) {
        this.cmdRowEdit = c0;
    }

    public void setDeleteCommand(UiCommand c0) {
        this.cmdRowDelete = c0;
    }

    private void selectHandler(RowPanel r0) {
        if (this.previousSelect != null) {
            this.previousSelect.setSelected(false);
        }
        r0.setSelected(true);
        this.previousSelect = r0;
        if (this.cmdRowSelect != null) {
            this.cmdRowSelect.run();
        }
    }

    private void editQuest(QuestData quest) {
        String questName;
        String oldQuestName = quest.getName();
        while (true) {
            if ((questName = FOptionPane.showInputDialog(Localizer.getInstance().getMessage("lblRenameQuestTo", new Object[0]) + ":", Localizer.getInstance().getMessage("lblQuestRename", new Object[0]), null, oldQuestName)) == null) {
                return;
            }
            if ((questName = QuestUtil.cleanString(questName)).equals(oldQuestName)) {
                return;
            }
            if (questName.isEmpty()) {
                FOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblQuestNameEmpty", new Object[0]));
                continue;
            }
            boolean exists = false;
            for (RowPanel r : this.rows) {
                if (!r.getQuestData().getName().equalsIgnoreCase(questName)) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            FOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblQuestExists", new Object[0]));
        }
        quest.rename(questName);
        if (this.cmdRowEdit != null) {
            this.cmdRowEdit.run();
        }
    }

    private void deleteFile(RowPanel r0) {
        QuestData qd = r0.getQuestData();
        if (!FOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblConfirmDelete", new Object[0]) + " '" + qd.getName() + "'?", Localizer.getInstance().getMessage("lblDeleteQuest", new Object[0]), Localizer.getInstance().getMessage("lblDelete", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]), false)) {
            return;
        }
        new File(ForgeConstants.QUEST_SAVE_DIR, r0.getQuestData().getName() + ".dat").delete();
        new File(ForgeConstants.QUEST_SAVE_DIR, r0.getQuestData().getName() + ".dat.bak").delete();
        if (this.cmdRowDelete != null) {
            this.cmdRowDelete.run();
        }
        this.remove(r0);
        this.repaint();
        this.revalidate();
    }

    private class RowPanel
    extends FSkin.SkinnedPanel {
        private boolean selected = false;
        private boolean hovered = false;
        private QuestData questData;

        public RowPanel(QuestData qd0) {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setLayout(new MigLayout("insets 0, gap 0"));
            this.setBorder(new FSkin.MatteSkinBorder(0, 0, 1, 0, QuestFileLister.this.clrBorders));
            this.questData = qd0;
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onMouseEnter(MouseEvent e) {
                    RowPanel.this.hovered = true;
                    if (!RowPanel.this.selected) {
                        RowPanel.this.setBackground(QuestFileLister.this.clrHover);
                        RowPanel.this.setOpaque(true);
                    }
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    RowPanel.this.hovered = false;
                    if (!RowPanel.this.selected) {
                        RowPanel.this.setBackground(QuestFileLister.this.clrDefault);
                        RowPanel.this.setOpaque(false);
                    }
                }

                @Override
                public void onLeftMouseDown(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        QuestFileLister.this.selectHandler(RowPanel.this);
                    }
                }
            });
        }

        public void setSelected(boolean b0) {
            this.selected = b0;
            this.setOpaque(b0);
            if (b0) {
                this.setBackground(QuestFileLister.this.clrActive);
            } else if (this.hovered) {
                this.setBackground(QuestFileLister.this.clrHover);
            } else {
                this.setBackground(QuestFileLister.this.clrDefault);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public QuestData getQuestData() {
            return this.questData;
        }
    }

    private class EditButton
    extends FSkin.SkinnedButton {
        public EditButton(final RowPanel r0) {
            this.setRolloverEnabled(true);
            this.setPressedIcon(QuestFileLister.this.icoEditOver);
            this.setRolloverIcon(QuestFileLister.this.icoEditOver);
            this.setIcon(QuestFileLister.this.icoEdit);
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorder((Border)null);
            this.setBorderPainted(false);
            this.setToolTipText(Localizer.getInstance().getMessage("lblRenameThisQuest", new Object[0]));
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onMouseEnter(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuestFileLister.this.clrHover);
                        r0.setOpaque(true);
                    }
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuestFileLister.this.clrDefault);
                        r0.setOpaque(false);
                    }
                }

                @Override
                public void onLeftClick(MouseEvent e) {
                    QuestFileLister.this.editQuest(r0.getQuestData());
                }
            });
        }
    }

    private class DeleteButton
    extends FSkin.SkinnedButton {
        public DeleteButton(final RowPanel r0) {
            this.setRolloverEnabled(true);
            this.setPressedIcon(QuestFileLister.this.icoDeleteOver);
            this.setRolloverIcon(QuestFileLister.this.icoDeleteOver);
            this.setIcon(QuestFileLister.this.icoDelete);
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorder((Border)null);
            this.setBorderPainted(false);
            this.setToolTipText(Localizer.getInstance().getMessage("lblDeleteThisQuest", new Object[0]));
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onMouseEnter(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuestFileLister.this.clrHover);
                        r0.setOpaque(true);
                    }
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuestFileLister.this.clrDefault);
                        r0.setOpaque(false);
                    }
                }

                @Override
                public void onLeftClick(MouseEvent e) {
                    QuestFileLister.this.deleteFile(r0);
                }
            });
        }
    }
}

