/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.ImageCache;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestUtil;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

class PnlEvent
extends JPanel {
    private final QuestEvent event;
    private final FRadioButton rad;
    private final FSkin.SkinImage image;
    private final int wImg = 85;
    private final int hImg = 85;
    private final int hRfl = 20;
    private final Color clr1 = new Color(255, 0, 255, 100);
    private final Color clr2 = new Color(255, 255, 0, 0);
    private final FSkin.SkinColor clr3 = FSkin.getColor(FSkin.Colors.CLR_THEME2).alphaColor(200);

    public PnlEvent(QuestEvent e0) {
        this.event = e0;
        this.image = this.event.getFullTitle().startsWith("Random Opponent") ? FSkin.getIcon(FSkinProp.ICO_UNKNOWN) : (this.event.hasImage() ? ImageCache.getIcon(e0.getIconImageKey()) : null);
        this.rad = new FRadioButton(this.event.getFullTitle());
        this.rad.setFont(FSkin.getRelativeBoldFont(16));
        FTextArea tarDesc = new FTextArea();
        tarDesc.setText(this.event.getDescription());
        tarDesc.setFont(FSkin.getItalicFont());
        tarDesc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.getComponent().getParent().dispatchEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().getParent().dispatchEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.getComponent().getParent().dispatchEvent(e);
            }
        });
        this.rad.addChangeListener(arg0 -> {
            if (this.rad.isSelected()) {
                QuestUtil.setEvent(this.event);
            }
        });
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.add((Component)this.rad, "gap 100px 0 10px 0");
        this.add((Component)tarDesc, "w 100% - 100px!, gap 100px 0 5px 0");
    }

    public QuestEvent getEvent() {
        return this.event;
    }

    public JRadioButton getRad() {
        return this.rad;
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        FSkin.setGraphicsGradientPaint(g2d, 0.0f, 0.0f, this.clr3, (float)this.getWidth(), 0.0f, this.clr2);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.translate(5, 5);
        Dimension srcSize = this.image.getSizeForPaint(g2d);
        int wSrc = srcSize.width;
        int hSrc = srcSize.height;
        FSkin.drawImage(g2d, this.image, 0, 0, 85, 85, 0, 0, wSrc, hSrc);
        g2d.dispose();
    }
}

