/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.QuestEventDraft;
import forge.gamemodes.quest.QuestUtil;
import forge.screens.home.quest.VSubmenuQuestDraft;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.FTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PnlDraftEvent
extends JPanel {
    private static final long serialVersionUID = 7348489421342846451L;
    private final Color clr2 = new Color(255, 255, 0, 0);
    private final FSkin.SkinColor clr3 = FSkin.getColor(FSkin.Colors.CLR_THEME2).alphaColor(200);
    private final FRadioButton radButton;
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            PnlDraftEvent.this.radButton.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PnlDraftEvent.this.radButton.getModel().setRollover(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mousePressed(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                VSubmenuQuestDraft.SINGLETON_INSTANCE.getBtnStartDraft().doClick();
            } else if (e.getButton() == 1) {
                PnlDraftEvent.this.radButton.setSelected(true);
            }
        }
    };

    public PnlDraftEvent(QuestEventDraft event) {
        this.radButton = new FRadioButton(event.getTitle());
        this.radButton.setFont(FSkin.getRelativeBoldFont(20));
        this.radButton.setIconTextGap(10);
        FTextArea eventBoosters = new FTextArea();
        FTextArea eventFee = new FTextArea();
        eventBoosters.setText(event.getBoosterList());
        eventBoosters.setFont(FSkin.getFont());
        eventFee.setText(QuestUtil.formatCredits(event.getEntryFee()) + " Credit Entry Fee");
        eventFee.setFont(FSkin.getFont());
        this.radButton.addChangeListener(arg0 -> {
            if (this.radButton.isSelected()) {
                QuestUtil.setDraftEvent(event);
            }
        });
        this.addMouseListener(this.mouseListener);
        eventBoosters.addMouseListener(this.mouseListener);
        eventFee.addMouseListener(this.mouseListener);
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.add((Component)this.radButton, "gap 25px 0 20px 0");
        this.add((Component)eventBoosters, "w 100% - 25px!, gap 25px 0 15px 0");
        this.add((Component)eventFee, "w 100% - 25px!, gap 25px 0 10px 0");
    }

    public FRadioButton getRadioButton() {
        return this.radButton;
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        FSkin.setGraphicsGradientPaint(g2d, 0.0f, 0.0f, this.clr3, (float)((int)((double)this.getWidth() * 0.75)), 0.0f, this.clr2);
        g2d.fillRect(0, 0, (int)((double)this.getWidth() * 0.75), this.getHeight());
        g2d.dispose();
    }
}

