/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.Singletons;
import forge.card.CardEdition;
import forge.gui.SOverlayUtils;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.FButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FCheckBoxTree;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FRadioButton;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.FSpinner;
import forge.util.Localizer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;

public class DialogChooseSets {
    private final List<String> selectedSets = new ArrayList<String>();
    private boolean wantReprints = true;
    private Runnable okCallback;
    private final FCheckBox cbWantReprints = new FCheckBox(Localizer.getInstance().getMessage("lblDisplayRecentSetReprints", new Object[0]));
    private final FCheckBoxTree checkBoxTree = new FCheckBoxTree();

    public DialogChooseSets(Collection<String> preselectedSets, Collection<String> unselectableSets, boolean showWantReprintsCheckbox) {
        this(preselectedSets, unselectableSets, showWantReprintsCheckbox, false);
    }

    public DialogChooseSets(Collection<String> preselectedSets, Collection<String> unselectableSets, Collection<String> limitedSets, boolean showWantReprintsCheckbox) {
        this(preselectedSets, unselectableSets, limitedSets, showWantReprintsCheckbox, false);
    }

    public DialogChooseSets(Collection<String> preselectedSets, Collection<String> unselectableSets, boolean showWantReprintsCheckbox, boolean allowReprints) {
        this(preselectedSets, unselectableSets, null, showWantReprintsCheckbox, allowReprints);
    }

    /*
     * WARNING - void declaration
     */
    public DialogChooseSets(Collection<String> preselectedSets, Collection<String> unselectableSets, Collection<String> limitedSets, boolean showWantReprintsCheckbox, boolean allowReprints) {
        HashSet<String> blackList;
        if (limitedSets != null && limitedSets.size() == 0) {
            limitedSets = null;
        }
        if (unselectableSets != null && limitedSets != null) {
            blackList = new HashSet<String>();
            for (String string : unselectableSets) {
                if (limitedSets.contains(string)) continue;
                blackList.add(string);
            }
            if (blackList.size() > 0) {
                for (String string : blackList) {
                    unselectableSets.remove(string);
                }
            }
        }
        if (preselectedSets != null) {
            blackList = new HashSet();
            for (String string : preselectedSets) {
                if (unselectableSets != null && unselectableSets.contains(string)) {
                    blackList.add(string);
                }
                if (limitedSets == null || limitedSets.contains(string)) continue;
                blackList.add(string);
            }
            if (blackList.size() > 0) {
                for (String string : blackList) {
                    preselectedSets.remove(string);
                }
            }
        }
        Map<CardEdition.Type, List<CardEdition>> editionsTypeMap = FModel.getMagicDb().getEditionsTypeMap();
        TreeSet<CardEdition.Type> preselectedTypes = null;
        if (preselectedSets != null) {
            preselectedTypes = new TreeSet<CardEdition.Type>();
            for (String string : preselectedSets) {
                CardEdition edition = FModel.getMagicDb().getCardEdition(string);
                if (edition == null) continue;
                preselectedTypes.add(edition.getType());
            }
        }
        Object var8_17 = null;
        if (limitedSets != null) {
            TreeSet<CardEdition.Type> treeSet = new TreeSet<CardEdition.Type>();
            for (String code : limitedSets) {
                CardEdition edition = FModel.getMagicDb().getCardEdition(code);
                if (edition == null) continue;
                treeSet.add(edition.getType());
            }
        }
        TreeMap<FCheckBoxTree.FTreeNodeData, List<FCheckBoxTree.FTreeNodeData>> treeMap = new TreeMap<FCheckBoxTree.FTreeNodeData, List<FCheckBoxTree.FTreeNodeData>>();
        TreeMap<CardEdition.Type, Integer> allEditionTypes = new TreeMap<CardEdition.Type, Integer>();
        ArrayList<CardEdition> allCardEditions = new ArrayList<CardEdition>();
        for (CardEdition.Type editionType : editionsTypeMap.keySet()) {
            void var8_19;
            List<CardEdition> editionsOfType = editionsTypeMap.get((Object)editionType);
            if (editionsOfType.size() == 0 || var8_19 != null && !var8_19.contains((Object)editionType)) continue;
            ArrayList<FCheckBoxTree.FTreeNodeData> editionPerTypeNodes = new ArrayList<FCheckBoxTree.FTreeNodeData>();
            allCardEditions.addAll(editionsOfType);
            int enabledEditionsOfTypeCounter = 0;
            for (CardEdition cardEdition : editionsOfType) {
                String code = cardEdition.getCode();
                if (limitedSets != null && !limitedSets.contains(code)) continue;
                boolean isSelected = null != preselectedSets && preselectedSets.contains(code);
                boolean isEnabled = null == unselectableSets || !unselectableSets.contains(code);
                FCheckBoxTree.FTreeNodeData editionNode = new FCheckBoxTree.FTreeNodeData(cardEdition, cardEdition.getName(), cardEdition.getCode());
                editionNode.isEnabled = isEnabled;
                editionNode.isSelected = isSelected;
                if (isEnabled) {
                    ++enabledEditionsOfTypeCounter;
                }
                editionPerTypeNodes.add(editionNode);
            }
            treeMap.put(new FCheckBoxTree.FTreeNodeData((Comparable)((Object)editionType)), editionPerTypeNodes);
            allEditionTypes.put(editionType, enabledEditionsOfTypeCounter);
        }
        this.checkBoxTree.setTreeData(treeMap);
        FPanel mainDialogPanel = new FPanel(new MigLayout(String.format("insets 10, gap 5, center, wrap 2, w %d!", this.getMainDialogWidth())));
        mainDialogPanel.setOpaque(false);
        mainDialogPanel.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        JPanel randomSelectionPanel = new JPanel(new MigLayout("insets 10, gap 5, right, wrap 2"));
        randomSelectionPanel.setOpaque(false);
        randomSelectionPanel.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblSelectRandomSets", new Object[0])).fontSize(14).fontStyle(1).build(), "h 40!, w 100%, center, span 2");
        FButton randomSelectionButton = new FButton(Localizer.getInstance().getMessage("lblRandomizeSets", new Object[0]));
        randomSelectionButton.setFont(FSkin.getBoldFont(13));
        randomSelectionButton.setEnabled(false);
        TreeMap<CardEdition.Type, FSpinner> spinnersEditionTypeMap = new TreeMap<CardEdition.Type, FSpinner>();
        TreeMap<CardEdition.Type, Object> labelsEditionTypeMap = new TreeMap<CardEdition.Type, Object>();
        ArrayList<FSpinner> editionTypeSpinners = new ArrayList<FSpinner>();
        for (CardEdition.Type editionType : allEditionTypes.keySet()) {
            int enabledEditionCount = (Integer)allEditionTypes.get((Object)editionType);
            FSpinner spinner2 = new FSpinner.Builder().initialValue(0).minValue(0).maxValue(enabledEditionCount).build();
            String labTxt = "<html>" + editionType.toString().replaceAll(" ", "<br>") + ": </html>";
            FLabel label = new FLabel.Builder().text(labTxt).fontSize(13).build();
            if (enabledEditionCount == 0) {
                spinner2.setEnabled(false);
                label.setEnabled(false);
            }
            editionTypeSpinners.add(spinner2);
            labelsEditionTypeMap.put(editionType, label);
            spinnersEditionTypeMap.put(editionType, spinner2);
        }
        editionTypeSpinners.forEach(spinner -> spinner.addChangeListener(e -> {
            int spinValue = (Integer)spinner.getValue();
            if (spinValue > 0) {
                if (!randomSelectionButton.isEnabled()) {
                    randomSelectionButton.setEnabled(true);
                }
            } else {
                boolean allZeros = true;
                for (FSpinner spin : editionTypeSpinners) {
                    int value = (Integer)spin.getValue();
                    if (value == 0) continue;
                    allZeros = false;
                    break;
                }
                if (allZeros) {
                    randomSelectionButton.setEnabled(false);
                }
            }
        }));
        Object var18_35 = null;
        randomSelectionPanel.add((Component)new JSeparator(0), "w 100%, span 2, center");
        randomSelectionPanel.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("nlSelectRandomSets", new Object[0])).fontSize(12).fontStyle(2).build(), "w 80%!, h 22px!, gap 5 0 0 0, span 2, center");
        String pairPanelLayout = "wrap 2, w 30%";
        int componentIndex = 0;
        int pairPerPanel = 3;
        int panelCompsCount = 0;
        for (CardEdition.Type editionType : allEditionTypes.keySet()) {
            void var18_36;
            if (panelCompsCount == 0) {
                JPanel jPanel = new JPanel(new MigLayout("insets 5, wrap 3"));
            }
            var18_36.setOpaque(false);
            JPanel pairPanel = new JPanel(new MigLayout(pairPanelLayout));
            pairPanel.setOpaque(false);
            pairPanel.add((Component)labelsEditionTypeMap.get((Object)editionType), "w 100!, align left, span 1");
            pairPanel.add((Component)spinnersEditionTypeMap.get((Object)editionType), "w 45!, align right, span 1");
            var18_36.add((Component)pairPanel, "span 1, center, growx, h 50!");
            if (++panelCompsCount != pairPerPanel && ++componentIndex != editionTypeSpinners.size()) continue;
            randomSelectionPanel.add((Component)var18_36, "w 100%, span 2");
            panelCompsCount = 0;
        }
        randomSelectionPanel.add((Component)new JSeparator(0), "w 100%, span 2, gap 0");
        FButton clearSelectionButton = new FButton(Localizer.getInstance().getMessage("lblClearSelection", new Object[0]));
        clearSelectionButton.setFont(FSkin.getBoldFont(13));
        randomSelectionPanel.add((Component)clearSelectionButton, "gaptop 15, w 40%, h 26!, center");
        randomSelectionPanel.add((Component)randomSelectionButton, "gaptop 15, w 40%, h 26!, center");
        if (showWantReprintsCheckbox) {
            this.cbWantReprints.setSelected(allowReprints);
            randomSelectionPanel.add((Component)this.cbWantReprints, "gaptop 10, left, span, wrap");
        }
        JPanel optionsPanel = new JPanel(new MigLayout("insets 10, gap 5, center, wrap 2"));
        optionsPanel.setOpaque(false);
        JPanel formatOptionsPanel = new JPanel(new MigLayout("insets 10, gap 25 5, center"));
        formatOptionsPanel.setOpaque(false);
        formatOptionsPanel.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblFormatRestrictions", new Object[0]) + ":").fontSize(14).fontStyle(1).build(), "span 1");
        ButtonGroup formatButtonGroup = new ButtonGroup();
        ArrayList gameFormats = new ArrayList();
        FModel.getFormats().getSanctionedList().forEach(gameFormats::add);
        HashMap<String, FRadioButton> formatButtonGroupMap = new HashMap<String, FRadioButton>();
        gameFormats.forEach(item -> {
            FRadioButton button = new FRadioButton(item.getName());
            button.setActionCommand(item.getName());
            button.addActionListener(e -> {
                FCheckBoxTree.FTreeNode node;
                List<String> allowedSetCodes = item.getAllowedSetCodes();
                if (allowedSetCodes.size() == 0) {
                    for (CardEdition ce : allCardEditions) {
                        String code = ce.getCode();
                        FCheckBoxTree.FTreeNode node2 = this.checkBoxTree.getNodeByKey(code);
                        if (node2 == null) continue;
                        this.checkBoxTree.setNodeEnabledStatus(node2, true);
                    }
                    for (CardEdition.Type editionType : allEditionTypes.keySet()) {
                        int numberOfEnabledEditions = (Integer)allEditionTypes.get((Object)editionType);
                        if (numberOfEnabledEditions == 0) continue;
                        FSpinner spinner = (FSpinner)spinnersEditionTypeMap.get((Object)editionType);
                        FLabel label = (FLabel)labelsEditionTypeMap.get((Object)editionType);
                        spinner.setEnabled(true);
                        label.setEnabled(true);
                        FCheckBoxTree.FTreeNode node3 = this.checkBoxTree.getNodeByKey((Object)editionType);
                        if (node3 != null) {
                            int maxValue = this.checkBoxTree.getNumberOfActiveChildNodes(node3);
                            int currentValue = (Integer)spinner.getValue();
                            spinner.setValue(Math.min(currentValue, maxValue));
                            SpinnerNumberModel m4 = (SpinnerNumberModel)spinner.getModel();
                            m4.setMaximum(Integer.valueOf(maxValue));
                            continue;
                        }
                        spinner.setValue(0);
                    }
                    return;
                }
                ArrayList<String> codesToDisable = new ArrayList<String>();
                HashSet<CardEdition.Type> typesToDisable = new HashSet<CardEdition.Type>();
                HashSet<CardEdition.Type> allowedTypes = new HashSet<CardEdition.Type>();
                for (CardEdition ce : allCardEditions) {
                    String code = ce.getCode();
                    if (unselectableSets != null && unselectableSets.contains(code)) continue;
                    if (!allowedSetCodes.contains(code)) {
                        codesToDisable.add(code);
                        typesToDisable.add(ce.getType());
                        continue;
                    }
                    allowedTypes.add(ce.getType());
                }
                typesToDisable.removeAll(allowedTypes);
                for (String code : codesToDisable) {
                    node = this.checkBoxTree.getNodeByKey(code);
                    if (node == null) continue;
                    this.checkBoxTree.setNodeEnabledStatus(node, false);
                }
                for (String code : allowedSetCodes) {
                    node = this.checkBoxTree.getNodeByKey(code);
                    if (node == null) continue;
                    this.checkBoxTree.setNodeEnabledStatus(node, true);
                }
                for (CardEdition.Type editionType : typesToDisable) {
                    FSpinner spinner = (FSpinner)spinnersEditionTypeMap.get((Object)editionType);
                    FLabel label = (FLabel)labelsEditionTypeMap.get((Object)editionType);
                    spinner.setEnabled(false);
                    spinner.setValue(0);
                    label.setEnabled(false);
                }
                for (CardEdition.Type editionType : allowedTypes) {
                    if ((Integer)allEditionTypes.get((Object)editionType) == 0) continue;
                    FLabel label = (FLabel)labelsEditionTypeMap.get((Object)editionType);
                    label.setEnabled(true);
                    FSpinner spinner = (FSpinner)spinnersEditionTypeMap.get((Object)editionType);
                    spinner.setEnabled(true);
                    FCheckBoxTree.FTreeNode node4 = this.checkBoxTree.getNodeByKey((Object)editionType);
                    if (node4 != null) {
                        int maxValue = this.checkBoxTree.getNumberOfActiveChildNodes(node4);
                        int currentValue = (Integer)spinner.getValue();
                        spinner.setValue(Math.min(currentValue, maxValue));
                        SpinnerNumberModel m5 = (SpinnerNumberModel)spinner.getModel();
                        m5.setMaximum(Integer.valueOf(maxValue));
                        continue;
                    }
                    spinner.setValue(0);
                }
            });
            formatButtonGroup.add(button);
            formatOptionsPanel.add(button);
            formatButtonGroupMap.put(item.getName(), button);
        });
        FRadioButton noFormatSelectionButton = new FRadioButton(Localizer.getInstance().getMessage("lblNoFormatRestriction", new Object[0]));
        noFormatSelectionButton.setActionCommand("No Format");
        noFormatSelectionButton.addActionListener(e -> {
            for (CardEdition ce : allCardEditions) {
                String code = ce.getCode();
                FCheckBoxTree.FTreeNode node = this.checkBoxTree.getNodeByKey(code);
                if (node == null) continue;
                this.checkBoxTree.setNodeEnabledStatus(node, true);
            }
            for (CardEdition.Type editionType : allEditionTypes.keySet()) {
                if ((Integer)allEditionTypes.get((Object)editionType) == 0) continue;
                FSpinner spinner = (FSpinner)spinnersEditionTypeMap.get((Object)editionType);
                FLabel label = (FLabel)labelsEditionTypeMap.get((Object)editionType);
                spinner.setEnabled(true);
                label.setEnabled(true);
                FCheckBoxTree.FTreeNode node = this.checkBoxTree.getNodeByKey((Object)editionType);
                if (node != null) {
                    int maxValue = this.checkBoxTree.getNumberOfActiveChildNodes(node);
                    int currentValue = (Integer)spinner.getValue();
                    spinner.setValue(Math.min(currentValue, maxValue));
                    SpinnerNumberModel m4 = (SpinnerNumberModel)spinner.getModel();
                    m4.setMaximum(Integer.valueOf(maxValue));
                    continue;
                }
                spinner.setValue(0);
            }
        });
        formatButtonGroup.add(noFormatSelectionButton);
        formatOptionsPanel.add(noFormatSelectionButton);
        formatButtonGroupMap.put("No Format", noFormatSelectionButton);
        noFormatSelectionButton.setSelected(true);
        optionsPanel.add((Component)formatOptionsPanel, "span 2, w 100%");
        optionsPanel.add((Component)new JSeparator(0), "w 100%, span 2");
        JPanel editionSelectionPanel = new JPanel(new MigLayout("insets 10, gap 25 5, wrap 1, align left"));
        editionSelectionPanel.setOpaque(false);
        editionSelectionPanel.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblCardEditionTypeList", new Object[0])).fontSize(14).fontStyle(1).build(), "h 40!, w 100%, center, span 1");
        this.checkBoxTree.setOpaque(false);
        FScrollPane selectionScroller = new FScrollPane(this.checkBoxTree, true);
        editionSelectionPanel.add((Component)selectionScroller, "span 1, w 100%");
        clearSelectionButton.addActionListener(actionEvent -> {
            this.checkBoxTree.resetCheckingState();
            allEditionTypes.forEach((editionType, count) -> {
                if (count == 0) {
                    return;
                }
                FSpinner spinner = (FSpinner)spinnersEditionTypeMap.get(editionType);
                FLabel label = (FLabel)labelsEditionTypeMap.get(editionType);
                spinner.setValue(0);
                spinner.setEnabled(true);
                label.setEnabled(true);
            });
            noFormatSelectionButton.setSelected(true);
            this.cbWantReprints.setSelected(false);
            mainDialogPanel.repaintSelf();
        });
        randomSelectionButton.addActionListener(actionEvent -> {
            HashMap<CardEdition.Type, Integer> countPerEditionType = new HashMap<CardEdition.Type, Integer>();
            for (CardEdition.Type editionType : allEditionTypes.keySet()) {
                int value;
                FSpinner spinner;
                if ((Integer)allEditionTypes.get((Object)editionType) == 0 || !(spinner = (FSpinner)spinnersEditionTypeMap.get((Object)editionType)).isEnabled() || (value = ((Integer)spinner.getValue()).intValue()) <= 0) continue;
                countPerEditionType.put(editionType, value);
            }
            this.checkBoxTree.resetCheckingState();
            String selectedFormat = formatButtonGroup.getSelection().getActionCommand();
            FRadioButton formatButton = (FRadioButton)formatButtonGroupMap.get(selectedFormat);
            formatButton.doClick();
            for (CardEdition.Type editionType : countPerEditionType.keySet()) {
                int totalToSelect = (Integer)countPerEditionType.get((Object)editionType);
                FCheckBoxTree.FTreeNode setTypeNode = this.checkBoxTree.getNodeByKey((Object)editionType);
                if (setTypeNode == null) continue;
                List<FCheckBoxTree.FTreeNode> activeChildNodes = this.checkBoxTree.getActiveChildNodes(setTypeNode);
                Collections.shuffle(activeChildNodes);
                for (int i = 0; i < totalToSelect; ++i) {
                    this.checkBoxTree.setNodeCheckStatus(activeChildNodes.get(i), true);
                }
            }
            mainDialogPanel.repaintSelf();
        });
        mainDialogPanel.add((Component)new FLabel.Builder().text(Localizer.getInstance().getMessage("lblChooseSets", new Object[0])).fontSize(20).build(), "center, span, wrap, gaptop 10");
        mainDialogPanel.add((Component)editionSelectionPanel, "aligny top, w 50%, span 1");
        mainDialogPanel.add((Component)randomSelectionPanel, "aligny top, w 50%, span 1");
        mainDialogPanel.add((Component)optionsPanel, "center, w 100, span 2");
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        overlay.setLayout(new MigLayout("insets 0, gap 0, wrap, ax center, ay center"));
        Runnable cleanup = SOverlayUtils::hideOverlay;
        FButton btnOk = new FButton(Localizer.getInstance().getMessage("lblOK", new Object[0]));
        btnOk.addActionListener(arg0 -> {
            cleanup.run();
            this.handleOk();
        });
        FButton btnCancel = new FButton(Localizer.getInstance().getMessage("lblCancel", new Object[0]));
        btnCancel.addActionListener(e -> cleanup.run());
        JPanel southPanel = new JPanel(new MigLayout("insets 10, gap 30, ax center"));
        southPanel.setOpaque(false);
        southPanel.add((Component)btnOk, "center, w 250!, h 30!");
        southPanel.add((Component)btnCancel, "center, w 250!, h 30!");
        mainDialogPanel.add((Component)southPanel, "dock south, gapBottom 10");
        overlay.add(mainDialogPanel);
        mainDialogPanel.getRootPane().setDefaultButton(btnOk);
        SOverlayUtils.showOverlay();
    }

    private int getMainDialogWidth() {
        int winWidth = Singletons.getView().getFrame().getSize().width;
        int[] sizeBoundaries = new int[]{800, 1024, 1280, 2048};
        return this.calculateRelativePanelDimension(winWidth, 90, sizeBoundaries);
    }

    private int getMainDialogHeight() {
        int winHeight = Singletons.getView().getFrame().getSize().height;
        int[] sizeBoundaries = new int[]{600, 720, 780, 1024};
        return this.calculateRelativePanelDimension(winHeight, 40, sizeBoundaries);
    }

    private int calculateRelativePanelDimension(int winDim, int ratio, int[] sizeBoundaries) {
        int relativeWinDimension = winDim * ratio / 100;
        if (winDim < sizeBoundaries[0]) {
            return relativeWinDimension;
        }
        for (int i = 1; i < sizeBoundaries.length; ++i) {
            int left = sizeBoundaries[i - 1];
            int right = sizeBoundaries[i];
            if (winDim <= left || winDim > right) continue;
            return Math.min(right * 90 / 100, relativeWinDimension);
        }
        return sizeBoundaries[sizeBoundaries.length - 1] * 90 / 100;
    }

    public void setOkCallback(Runnable onOk) {
        this.okCallback = onOk;
    }

    public List<String> getSelectedSets() {
        return this.selectedSets;
    }

    public boolean getWantReprints() {
        return this.wantReprints;
    }

    private void handleOk() {
        Object[] checkedValues;
        for (Object data : checkedValues = this.checkBoxTree.getCheckedValues(true)) {
            CardEdition edition = (CardEdition)data;
            this.selectedSets.add(edition.getCode());
        }
        this.wantReprints = this.cbWantReprints.isSelected();
        if (null != this.okCallback) {
            this.okCallback.run();
        }
    }
}

