/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.StartingPoolPreferences;
import forge.gui.SOverlayUtils;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.FTextField;
import forge.toolbox.FTextPane;
import forge.toolbox.JXButtonPanel;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DialogChoosePoolDistribution {
    final Localizer localizer = Localizer.getInstance();
    private final FPanel mainPanel = new FPanel(new MigLayout("insets 20, gap 25, center, wrap 2"));
    private final FCheckBox cbxBlack = new FCheckBox(this.localizer.getMessage("lblBlack", new Object[0]));
    private final FCheckBox cbxBlue = new FCheckBox(this.localizer.getMessage("lblBlue", new Object[0]));
    private final FCheckBox cbxGreen = new FCheckBox(this.localizer.getMessage("lblGreen", new Object[0]));
    private final FCheckBox cbxRed = new FCheckBox(this.localizer.getMessage("lblRed", new Object[0]));
    private final FCheckBox cbxWhite = new FCheckBox(this.localizer.getMessage("lblWhite", new Object[0]));
    private final FCheckBox cbxColorless = new FCheckBox(this.localizer.getMessage("lblColorless", new Object[0]));
    private final FCheckBox cbxArtifacts = new FCheckBox(this.localizer.getMessage("lblIncludeArtifacts", new Object[0]));
    private final FRadioButton radBalanced = new FRadioButton(this.localizer.getMessage("lblBalanced", new Object[0]));
    private final FRadioButton radRandom = new FRadioButton(this.localizer.getMessage("lblTrueRandom", new Object[0]));
    private final FRadioButton radSurpriseMe = new FRadioButton(this.localizer.getMessage("lblSurpriseMe", new Object[0]));
    private final FRadioButton radBoosters = new FRadioButton(this.localizer.getMessage("lblBoosters", new Object[0]));
    private final ButtonGroup poolTypeButtonGroup = new ButtonGroup();
    private final FTextField numberOfBoostersField = new FTextField.Builder().text("0").maxLength(10).build();
    private final FButton btnOk = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
    private Runnable callback;

    public DialogChoosePoolDistribution(List<Byte> preferredColors, StartingPoolPreferences.PoolType poolType2, boolean includeArtifacts) {
        if (this.poolTypeButtonGroup.getButtonCount() == 0) {
            this.poolTypeButtonGroup.add(this.radBalanced);
            this.poolTypeButtonGroup.add(this.radRandom);
            this.poolTypeButtonGroup.add(this.radSurpriseMe);
            this.poolTypeButtonGroup.add(this.radBoosters);
        }
        for (Byte color : preferredColors) {
            switch (color) {
                case 4: {
                    this.cbxBlack.setSelected(true);
                    break;
                }
                case 2: {
                    this.cbxBlue.setSelected(true);
                    break;
                }
                case 16: {
                    this.cbxGreen.setSelected(true);
                    break;
                }
                case 8: {
                    this.cbxRed.setSelected(true);
                    break;
                }
                case 1: {
                    this.cbxWhite.setSelected(true);
                    break;
                }
                case 0: {
                    this.cbxColorless.setSelected(true);
                }
            }
        }
        this.cbxArtifacts.setSelected(includeArtifacts);
        switch (poolType2) {
            case BALANCED: {
                this.radBalanced.setSelected(true);
                break;
            }
            case RANDOM: {
                this.radRandom.setSelected(true);
                break;
            }
            case RANDOM_BALANCED: {
                this.radSurpriseMe.setSelected(true);
                break;
            }
            case BOOSTERS: {
                this.radBoosters.setSelected(true);
            }
        }
        this.mainPanel.setOpaque(false);
        this.mainPanel.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        String contentPanelConstraints = "w 200px!, h 340px!, left, gap 5, insets 10 25 10 25, wrap 1";
        FPanel right = new FPanel(new MigLayout("w 200px!, h 340px!, left, gap 5, insets 10 25 10 25, wrap 1"));
        right.setOpaque(false);
        FLabel clearColors = new FLabel.Builder().text(this.localizer.getMessage("lblClearAll", new Object[0])).fontSize(12).opaque(true).hoverable(true).build();
        clearColors.setCommand(() -> {
            this.cbxBlack.setSelected(false);
            this.cbxBlue.setSelected(false);
            this.cbxGreen.setSelected(false);
            this.cbxRed.setSelected(false);
            this.cbxWhite.setSelected(false);
            this.cbxColorless.setSelected(false);
        });
        FLabel boosterPackLabel = new FLabel.Builder().text(this.localizer.getMessage("lblNumberofBoosters", new Object[0]) + ":").fontSize(14).build();
        FLabel colorsLabel = new FLabel.Builder().text(this.localizer.getMessage("lblColors", new Object[0])).fontSize(18).build();
        FTextPane noSettingsText = new FTextPane(this.localizer.getMessage("lblnoSettings", new Object[0]));
        if (this.radBoosters.isSelected()) {
            right.add((Component)boosterPackLabel, "gaptop 10");
            right.add((Component)this.numberOfBoostersField, "w 100px!, gaptop 5");
        } else if (this.radSurpriseMe.isSelected()) {
            right.add((Component)noSettingsText, "gaptop 10");
        } else if (this.radRandom.isSelected()) {
            right.add((Component)this.cbxArtifacts, "gaptop 10");
        } else {
            right.add((Component)colorsLabel, "gaptop 10");
            right.add((Component)clearColors, "w 75px!, h 20px!, gaptop 10");
            right.add((Component)this.cbxBlack, "gaptop 10");
            right.add(this.cbxBlue);
            right.add(this.cbxGreen);
            right.add(this.cbxRed);
            right.add(this.cbxWhite);
            right.add(this.cbxColorless);
            right.add((Component)this.cbxArtifacts, "gaptop 25");
        }
        FPanel left = new FPanel(new MigLayout("w 200px!, h 340px!, left, gap 5, insets 10 25 10 25, wrap 1"));
        left.setOpaque(false);
        left.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblDistribution", new Object[0])).fontSize(18).build(), "gaptop 10");
        JXButtonPanel poolTypePanel = new JXButtonPanel();
        String radioConstraints = "h 25px!, gaptop 5";
        poolTypePanel.add((Component)this.radBalanced, "h 25px!, gaptop 5");
        poolTypePanel.add((Component)this.radRandom, "h 25px!, gaptop 5");
        poolTypePanel.add((Component)this.radSurpriseMe, "h 25px!, gaptop 5");
        poolTypePanel.add((Component)this.radBoosters, "h 25px!, gaptop 5");
        left.add((Component)poolTypePanel, "gaptop 15");
        left.add((Component)new FTextPane(this.localizer.getMessage("lblHoverforDescription", new Object[0])), "gaptop 20");
        ActionListener radioButtonListener = e -> {
            right.removeAll();
            if (this.radBoosters.isSelected()) {
                right.add((Component)boosterPackLabel, "gaptop 10");
                right.add((Component)this.numberOfBoostersField, "w 100px!, gaptop 5");
            } else if (this.radSurpriseMe.isSelected()) {
                right.add((Component)noSettingsText, "gaptop 10");
            } else if (this.radRandom.isSelected()) {
                right.add((Component)this.cbxArtifacts, "gaptop 10");
            } else {
                right.add((Component)colorsLabel, "gaptop 10");
                right.add((Component)clearColors, "w 75px!, h 20px!, gaptop 10");
                right.add((Component)this.cbxBlack, "gaptop 10");
                right.add(this.cbxBlue);
                right.add(this.cbxGreen);
                right.add(this.cbxRed);
                right.add(this.cbxWhite);
                right.add(this.cbxColorless);
                right.add((Component)this.cbxArtifacts, "gaptop 25");
            }
            clearColors.setVisible(this.radBalanced.isSelected());
            this.cbxBlack.setVisible(this.radBalanced.isSelected());
            this.cbxBlue.setVisible(this.radBalanced.isSelected());
            this.cbxGreen.setVisible(this.radBalanced.isSelected());
            this.cbxRed.setVisible(this.radBalanced.isSelected());
            this.cbxWhite.setVisible(this.radBalanced.isSelected());
            this.cbxColorless.setVisible(this.radBalanced.isSelected());
            this.cbxArtifacts.setVisible(!this.radSurpriseMe.isSelected() && !this.radBoosters.isSelected());
            this.numberOfBoostersField.setVisible(this.radBoosters.isSelected());
            right.validate();
            right.repaint();
        };
        clearColors.setVisible(this.radBalanced.isSelected());
        this.cbxBlack.setVisible(this.radBalanced.isSelected());
        this.cbxBlue.setVisible(this.radBalanced.isSelected());
        this.cbxGreen.setVisible(this.radBalanced.isSelected());
        this.cbxRed.setVisible(this.radBalanced.isSelected());
        this.cbxWhite.setVisible(this.radBalanced.isSelected());
        this.cbxColorless.setVisible(this.radBalanced.isSelected());
        this.cbxArtifacts.setVisible(!this.radSurpriseMe.isSelected() && !this.radBoosters.isSelected());
        this.numberOfBoostersField.setVisible(this.radBoosters.isSelected());
        this.radBalanced.setToolTipText(this.localizer.getMessage("lblradBalanced", new Object[0]));
        this.radRandom.setToolTipText(this.localizer.getMessage("lblradRandom", new Object[0]));
        this.radSurpriseMe.setToolTipText(this.localizer.getMessage("lblradSurpriseMe", new Object[0]));
        this.radBoosters.setToolTipText(this.localizer.getMessage("lblradBoosters", new Object[0]));
        this.cbxArtifacts.setToolTipText(this.localizer.getMessage("lblcbxArtifacts", new Object[0]));
        this.radBalanced.addActionListener(radioButtonListener);
        this.radRandom.addActionListener(radioButtonListener);
        this.radSurpriseMe.addActionListener(radioButtonListener);
        this.radBoosters.addActionListener(radioButtonListener);
        this.mainPanel.add(left);
        this.mainPanel.add(right);
        this.btnOk.setCommand(() -> {
            SOverlayUtils.hideOverlay();
            this.callback.run();
        });
        FButton btnCancel = new FButton(this.localizer.getMessage("lblCancel", new Object[0]));
        btnCancel.setCommand(SOverlayUtils::hideOverlay);
        JPanel southPanel = new JPanel(new MigLayout("insets 10, gap 20, ax right"));
        southPanel.setOpaque(false);
        southPanel.add((Component)this.btnOk, "w 150px!, h 30px!");
        southPanel.add((Component)btnCancel, "w 150px!, h 30px!");
        this.mainPanel.add((Component)southPanel, "dock south, gapBottom 10");
    }

    public void show(Runnable callback) {
        this.callback = callback;
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        overlay.setLayout(new MigLayout("insets 30, gap 15, wrap, ax center, ay center"));
        overlay.add(this.mainPanel);
        this.mainPanel.getRootPane().setDefaultButton(this.btnOk);
        SOverlayUtils.showOverlay();
    }

    public List<Byte> getPreferredColors() {
        ArrayList<Byte> preferredColors = new ArrayList<Byte>();
        if (this.cbxBlack.isSelected()) {
            preferredColors.add((byte)4);
        }
        if (this.cbxBlue.isSelected()) {
            preferredColors.add((byte)2);
        }
        if (this.cbxGreen.isSelected()) {
            preferredColors.add((byte)16);
        }
        if (this.cbxRed.isSelected()) {
            preferredColors.add((byte)8);
        }
        if (this.cbxWhite.isSelected()) {
            preferredColors.add((byte)1);
        }
        if (this.cbxColorless.isSelected()) {
            preferredColors.add((byte)0);
        }
        return preferredColors;
    }

    public StartingPoolPreferences.PoolType getPoolType() {
        if (this.radRandom.isSelected()) {
            return StartingPoolPreferences.PoolType.RANDOM;
        }
        if (this.radSurpriseMe.isSelected()) {
            return StartingPoolPreferences.PoolType.RANDOM_BALANCED;
        }
        if (this.radBoosters.isSelected()) {
            return StartingPoolPreferences.PoolType.BOOSTERS;
        }
        return StartingPoolPreferences.PoolType.BALANCED;
    }

    public boolean includeArtifacts() {
        return this.cbxArtifacts.isSelected();
    }

    public int getNumberOfBoosters() {
        try {
            return Integer.parseInt(this.numberOfBoostersField.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

