/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.game.GameFormat;
import forge.gui.SOverlayUtils;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.FButton;
import forge.toolbox.FCheckBox;
import forge.toolbox.FCheckBoxList;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class DialogChooseFormats {
    private List<GameFormat> selectedFormats = new ArrayList<GameFormat>();
    private boolean wantReprints = true;
    private Runnable okCallback;
    private final List<FCheckBox> choices = new ArrayList<FCheckBox>();
    final Localizer localizer = Localizer.getInstance();
    private final FCheckBox cbWantReprints = new FCheckBox(this.localizer.getMessage("cbWantReprints", new Object[0]));

    public DialogChooseFormats() {
        this(null);
    }

    public DialogChooseFormats(Set<GameFormat> preselectedFormats) {
        ArrayList<FCheckBox> sanctioned = new ArrayList<FCheckBox>();
        ArrayList<FCheckBox> casual = new ArrayList<FCheckBox>();
        ArrayList<FCheckBox> archived = new ArrayList<FCheckBox>();
        for (GameFormat format : FModel.getFormats().getOrderedList()) {
            FCheckBox box = new FCheckBox(format.getName());
            box.setName(format.getName());
            switch (format.getFormatType()) {
                case SANCTIONED: {
                    sanctioned.add(box);
                    break;
                }
                case ARCHIVED: {
                    archived.add(box);
                    break;
                }
                default: {
                    casual.add(box);
                }
            }
            box.setSelected(null != preselectedFormats && preselectedFormats.contains(format));
        }
        FPanel panel = new FPanel(new MigLayout("insets 0, gap 0, center, wrap 3"));
        panel.setOpaque(false);
        panel.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        panel.add((Component)new FLabel.Builder().text(this.localizer.getMessage("lblChooseFormats", new Object[0])).fontSize(18).build(), "center, span, wrap, gaptop 10");
        String constraints = "aligny top";
        panel.add((Component)this.makeCheckBoxList(sanctioned, this.localizer.getMessage("lblSanctioned", new Object[0]), true), constraints);
        panel.add((Component)this.makeCheckBoxList(casual, this.localizer.getMessage("lblOther", new Object[0]), false), constraints);
        panel.add((Component)this.makeCheckBoxList(archived, this.localizer.getMessage("lblArchived", new Object[0]), false), constraints);
        FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
        overlay.setLayout(new MigLayout("insets 0, gap 0, wrap, ax center, ay center"));
        Runnable cleanup = SOverlayUtils::hideOverlay;
        FButton btnOk = new FButton(this.localizer.getMessage("lblOK", new Object[0]));
        btnOk.addActionListener(arg0 -> {
            cleanup.run();
            this.handleOk();
        });
        FButton btnCancel = new FButton(this.localizer.getMessage("lblCancel", new Object[0]));
        btnCancel.addActionListener(e -> cleanup.run());
        JPanel southPanel = new JPanel(new MigLayout("insets 10, gap 20, ax center"));
        southPanel.setOpaque(false);
        southPanel.add((Component)this.cbWantReprints, "center, span, wrap");
        southPanel.add((Component)btnOk, "center, w 40%, h 20!");
        southPanel.add((Component)btnCancel, "center, w 40%, h 20!");
        panel.add((Component)southPanel, "dock south, gapBottom 10");
        overlay.add(panel);
        panel.getRootPane().setDefaultButton(btnOk);
        SOverlayUtils.showOverlay();
    }

    public void setOkCallback(Runnable onOk) {
        this.okCallback = onOk;
    }

    public List<GameFormat> getSelectedFormats() {
        return this.selectedFormats;
    }

    public boolean getWantReprints() {
        return this.wantReprints;
    }

    public void setWantReprintsCB(boolean isSet) {
        this.cbWantReprints.setSelected(isSet);
    }

    private JPanel makeCheckBoxList(List<FCheckBox> formats, String title, boolean focused) {
        this.choices.addAll(formats);
        FCheckBoxList<FCheckBox> cbl = new FCheckBoxList<FCheckBox>(false);
        cbl.setListData(formats.toArray(new FCheckBox[0]));
        cbl.setVisibleRowCount(Math.min(20, formats.size()));
        if (focused) {
            SwingUtilities.invokeLater(cbl::requestFocusInWindow);
        }
        JPanel pnl = new JPanel(new MigLayout("center, wrap"));
        pnl.setOpaque(false);
        pnl.add(new FLabel.Builder().text(title).build());
        pnl.add(new FScrollPane(cbl, true));
        return pnl;
    }

    private void handleOk() {
        for (FCheckBox box : this.choices) {
            if (box.isSelected()) {
                this.selectedFormats.add(FModel.getFormats().getFormat(box.getName()));
            }
            this.wantReprints = this.cbWantReprints.isSelected();
        }
        if (null != this.okCallback) {
            this.okCallback.run();
        }
    }
}

