/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.deck.Deck;
import forge.game.GameFormat;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestMode;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.QuestWorld;
import forge.gamemodes.quest.StartingPoolPreferences;
import forge.gamemodes.quest.StartingPoolType;
import forge.gamemodes.quest.data.DeckConstructionRules;
import forge.gamemodes.quest.data.GameFormatQuest;
import forge.gamemodes.quest.data.QuestData;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.framework.ICDoc;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.screens.home.CHomeUI;
import forge.screens.home.quest.DialogChooseFormats;
import forge.screens.home.quest.DialogChoosePoolDistribution;
import forge.screens.home.quest.DialogChooseSets;
import forge.screens.home.quest.VSubmenuQuestDecks;
import forge.screens.home.quest.VSubmenuQuestStart;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public enum CSubmenuQuestStart implements ICDoc
{
    SINGLETON_INSTANCE;

    private final Map<String, QuestData> arrQuests = new HashMap<String, QuestData>();
    private final VSubmenuQuestStart view = VSubmenuQuestStart.SINGLETON_INSTANCE;
    private final List<String> customFormatCodes = new ArrayList<String>();
    private final List<String> customPrizeFormatCodes = new ArrayList<String>();
    private List<Byte> preferredColors = new ArrayList<Byte>();
    private StartingPoolPreferences.PoolType poolType = StartingPoolPreferences.PoolType.BALANCED;
    private boolean includeArtifacts = true;
    private int numberOfBoosters = 0;

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getBtnEmbark().setCommand(this::newQuest);
        ArrayList<String> unselectableSets = new ArrayList<String>();
        unselectableSets.add("LEA");
        unselectableSets.add("LEB");
        unselectableSets.add("MBP");
        unselectableSets.add("VAN");
        unselectableSets.add("ARC");
        unselectableSets.add("PC2");
        this.view.getBtnCustomFormat().setCommand(() -> {
            DialogChooseSets dialog = new DialogChooseSets(this.customFormatCodes, unselectableSets, false);
            dialog.setOkCallback(() -> {
                this.customFormatCodes.clear();
                this.customFormatCodes.addAll(dialog.getSelectedSets());
            });
        });
        this.view.getBtnSelectFormat().setCommand(() -> {
            DialogChooseFormats dialog = new DialogChooseFormats();
            dialog.setOkCallback(() -> {
                this.customFormatCodes.clear();
                HashSet<String> sets = new HashSet<String>();
                for (GameFormat format : dialog.getSelectedFormats()) {
                    sets.addAll(format.getAllowedSetCodes());
                }
                this.customFormatCodes.addAll(sets);
            });
        });
        this.view.getBtnPrizeCustomFormat().setCommand(() -> {
            DialogChooseSets dialog = new DialogChooseSets(this.customPrizeFormatCodes, unselectableSets, false);
            dialog.setOkCallback(() -> {
                this.customPrizeFormatCodes.clear();
                this.customPrizeFormatCodes.addAll(dialog.getSelectedSets());
            });
        });
        this.view.getBtnPrizeSelectFormat().setCommand(() -> {
            DialogChooseFormats dialog = new DialogChooseFormats();
            dialog.setOkCallback(() -> {
                this.customPrizeFormatCodes.clear();
                HashSet<String> sets = new HashSet<String>();
                for (GameFormat format : dialog.getSelectedFormats()) {
                    sets.addAll(format.getAllowedSetCodes());
                }
                this.customPrizeFormatCodes.addAll(sets);
            });
        });
        this.view.getBtnPreferredColors().setCommand(() -> {
            DialogChoosePoolDistribution colorChooser = new DialogChoosePoolDistribution(this.preferredColors, this.poolType, this.includeArtifacts);
            colorChooser.show(() -> {
                this.preferredColors = colorChooser.getPreferredColors();
                this.poolType = colorChooser.getPoolType();
                this.includeArtifacts = colorChooser.includeArtifacts();
                this.numberOfBoosters = colorChooser.getNumberOfBoosters();
            });
        });
    }

    @Override
    public void update() {
    }

    private void newQuest() {
        String questName;
        GameFormat fmtPrizes;
        StartingPoolType prizedPoolType;
        GameFormat fmtStartPool;
        Deck dckStartPool;
        QuestMode mode;
        int difficulty;
        VSubmenuQuestStart view;
        Localizer localizer;
        block23: {
            GameFormatQuest worldFormat;
            block22: {
                localizer = Localizer.getInstance();
                view = VSubmenuQuestStart.SINGLETON_INSTANCE;
                difficulty = view.getSelectedDifficulty();
                mode = view.isFantasy() ? QuestMode.Fantasy : QuestMode.Classic;
                dckStartPool = null;
                fmtStartPool = null;
                QuestWorld startWorld = FModel.getWorlds().get(view.getStartingWorldName());
                GameFormatQuest gameFormatQuest = worldFormat = startWorld == null ? null : startWorld.getFormat();
                if (worldFormat != null) break block22;
                switch (view.getStartingPoolType()) {
                    case Sanctioned: {
                        fmtStartPool = view.getRotatingFormat();
                        break;
                    }
                    case Casual: 
                    case CustomFormat: {
                        if (this.customFormatCodes.isEmpty() && !FOptionPane.showConfirmDialog(localizer.getMessage("lblNotFormatDefined", new Object[0]))) {
                            return;
                        }
                        fmtStartPool = this.customFormatCodes.isEmpty() ? null : new GameFormatQuest("Custom", this.customFormatCodes, null);
                        break;
                    }
                    case DraftDeck: 
                    case SealedDeck: 
                    case Cube: {
                        dckStartPool = view.getSelectedDeck();
                        if (null == dckStartPool) {
                            FOptionPane.showMessageDialog(localizer.getMessage("lbldckStartPool", new Object[0]), localizer.getMessage("lblCannotStartaQuest", new Object[0]), FOptionPane.ERROR_ICON);
                            return;
                        }
                        break block23;
                    }
                    case Precon: {
                        dckStartPool = QuestController.getPrecons().get(view.getSelectedPrecon()).getDeck();
                        break;
                    }
                }
                break block23;
            }
            fmtStartPool = worldFormat;
        }
        if (null == (prizedPoolType = view.getPrizedPoolType())) {
            fmtPrizes = fmtStartPool;
            if (null == fmtPrizes && dckStartPool != null) {
                HashSet<String> sets = new HashSet<String>();
                for (Map.Entry entry : dckStartPool.getAllCardsInASinglePool()) {
                    sets.add(((PaperCard)entry.getKey()).getEdition());
                }
                fmtPrizes = new GameFormat(localizer.getMessage("lblFromDeck", new Object[0]), sets, null);
            }
        } else {
            switch (prizedPoolType) {
                case Complete: {
                    fmtPrizes = null;
                    break;
                }
                case Casual: 
                case CustomFormat: {
                    if (this.customPrizeFormatCodes.isEmpty() && !FOptionPane.showConfirmDialog(localizer.getMessage("lblNotFormatDefined", new Object[0]))) {
                        return;
                    }
                    fmtPrizes = this.customPrizeFormatCodes.isEmpty() ? null : new GameFormat("Custom Prizes", this.customPrizeFormatCodes, null);
                    break;
                }
                case Sanctioned: {
                    fmtPrizes = view.getPrizedRotatingFormat();
                    break;
                }
                default: {
                    throw new RuntimeException("Should not get this result");
                }
            }
        }
        StartingPoolPreferences userPrefs = new StartingPoolPreferences(this.poolType, this.preferredColors, this.includeArtifacts, view.startWithCompleteSet(), view.allowDuplicateCards(), this.numberOfBoosters);
        while (true) {
            if ((questName = FOptionPane.showInputDialog(localizer.getMessage("MsgQuestNewName", new Object[0]) + ":", localizer.getMessage("TitQuestNewName", new Object[0]))) == null) {
                return;
            }
            if ((questName = QuestUtil.cleanString(questName)).isEmpty()) {
                FOptionPane.showMessageDialog(localizer.getMessage("lblQuestNameEmpty", new Object[0]));
                continue;
            }
            if (this.getAllQuests().get(questName + ".dat") == null) break;
            FOptionPane.showMessageDialog(localizer.getMessage("lblQuestExists", new Object[0]));
        }
        DeckConstructionRules dcr = DeckConstructionRules.Default;
        if (VSubmenuQuestStart.SINGLETON_INSTANCE.isCommander()) {
            dcr = DeckConstructionRules.Commander;
        }
        QuestController qc = FModel.getQuest();
        qc.newGame(questName, difficulty, mode, fmtPrizes, view.isUnlockSetsAllowed(), dckStartPool, fmtStartPool, view.getStartingWorldName(), userPrefs, dcr);
        FModel.getQuest().save();
        FModel.getQuestPreferences().setPref(QuestPreferences.QPref.CURRENT_QUEST, questName + ".dat");
        FModel.getQuestPreferences().save();
        CHomeUI.SINGLETON_INSTANCE.itemClick(VSubmenuQuestDecks.SINGLETON_INSTANCE.getDocumentID());
    }

    private Map<String, QuestData> getAllQuests() {
        return this.arrQuests;
    }
}

