/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import com.google.common.primitives.Ints;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.framework.ICDoc;
import forge.model.FModel;
import forge.screens.home.quest.VSubmenuQuestPrefs;
import forge.util.Localizer;
import javax.swing.SwingUtilities;

public enum CSubmenuQuestPrefs implements ICDoc
{
    SINGLETON_INSTANCE;


    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
        SwingUtilities.invokeLater(VSubmenuQuestPrefs.SINGLETON_INSTANCE::focusFirstTextbox);
    }

    public static void validateAndSave(VSubmenuQuestPrefs.PrefInput i0) {
        if (i0.getText().equals(i0.getPreviousText())) {
            return;
        }
        QuestPreferences prefs = FModel.getQuestPreferences();
        String validationError = null;
        Localizer localizer = Localizer.getInstance();
        CSubmenuQuestPrefs.resetErrors();
        if (QuestPreferences.QPref.UNLOCK_DISTANCE_MULTIPLIER.equals((Object)i0.getQPref()) || QuestPreferences.QPref.WILD_OPPONENTS_MULTIPLIER.equals((Object)i0.getQPref())) {
            Double val = null;
            try {
                val = Double.valueOf(i0.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            validationError = val == null ? localizer.getMessage("lblEnteraDecimal", new Object[0]) : null;
        } else {
            Integer val = Ints.tryParse(i0.getText());
            String string = validationError = val == null ? localizer.getMessage("lblEnteraNumber", new Object[0]) : prefs.validatePreference(i0.getQPref(), val);
        }
        if (validationError != null) {
            CSubmenuQuestPrefs.showError(i0, validationError);
            return;
        }
        prefs.setPref(i0.getQPref(), i0.getText());
        prefs.save();
        i0.setPreviousText(i0.getText());
    }

    private static void showError(VSubmenuQuestPrefs.PrefInput i0, String s0) {
        VSubmenuQuestPrefs view = VSubmenuQuestPrefs.SINGLETON_INSTANCE;
        Localizer localizer = Localizer.getInstance();
        String s2 = localizer.getMessage("lblSavefailed", new Object[0]) + ":" + s0;
        switch (i0.getErrType()) {
            case GAME_SETTINGS: {
                view.getLblErrGameSettings().setVisible(true);
                view.getLblErrGameSettings().setText(s2);
                break;
            }
            case BOOSTER: {
                view.getLblErrBooster().setVisible(true);
                view.getLblErrBooster().setText(s2);
                break;
            }
            case DIFFICULTY: {
                view.getLblErrDifficulty().setVisible(true);
                view.getLblErrDifficulty().setText(s2);
                break;
            }
            case REWARDS: {
                view.getLblErrRewards().setVisible(true);
                view.getLblErrRewards().setText(s2);
                break;
            }
            case SHOP: {
                view.getLblErrShop().setVisible(true);
                view.getLblErrShop().setText(s2);
                break;
            }
            case DRAFT_TOURNAMENTS: {
                view.getLblErrDraftTournaments().setVisible(true);
                view.getLblErrDraftTournaments().setText(s2);
                break;
            }
        }
        i0.setText(i0.getPreviousText());
    }

    public static void resetErrors() {
        VSubmenuQuestPrefs view = VSubmenuQuestPrefs.SINGLETON_INSTANCE;
        view.getLblErrGameSettings().setVisible(false);
        view.getLblErrBooster().setVisible(false);
        view.getLblErrDifficulty().setVisible(false);
        view.getLblErrRewards().setVisible(false);
        view.getLblErrShop().setVisible(false);
        view.getLblErrDraftTournaments().setVisible(false);
    }
}

