/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.data.QuestData;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.QuestDataIO;
import forge.gui.UiCommand;
import forge.gui.framework.ICDoc;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.screens.bazaar.CBazaarUI;
import forge.screens.home.quest.CSubmenuChallenges;
import forge.screens.home.quest.CSubmenuDuels;
import forge.screens.home.quest.CSubmenuQuestDecks;
import forge.screens.home.quest.CSubmenuQuestDraft;
import forge.screens.home.quest.VSubmenuQuestLoadData;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public enum CSubmenuQuestLoadData implements ICDoc
{
    SINGLETON_INSTANCE;

    private final Map<String, QuestData> arrQuests = new HashMap<String, QuestData>();
    private final UiCommand cmdQuestSelect = this::changeQuest;
    private final UiCommand cmdQuestUpdate = this::update;

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
        VSubmenuQuestLoadData view = VSubmenuQuestLoadData.SINGLETON_INSTANCE;
        File dirQuests = new File(ForgeConstants.QUEST_SAVE_DIR);
        QuestController qc = FModel.getQuest();
        ArrayList<String> restorableQuests = new ArrayList<String>();
        FilenameFilter takeDatFiles = (dir, name) -> name.endsWith(".dat");
        File[] arrFiles = dirQuests.listFiles(takeDatFiles);
        this.arrQuests.clear();
        for (File f : arrFiles) {
            try {
                System.out.printf("About to load quest (%s)... %n", f.getName());
                this.arrQuests.put(f.getName(), QuestDataIO.loadData(f));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.err.printf("Error loading quest data (%s).. skipping for now..%n", f.getName());
                restorableQuests.add(f.getName());
            }
        }
        view.getLstQuests().setQuests(new ArrayList<QuestData>(this.arrQuests.values()));
        if (!this.arrQuests.isEmpty()) {
            String questName = FModel.getQuestPreferences().getPref(QuestPreferences.QPref.CURRENT_QUEST);
            if (this.arrQuests.get(questName) != null) {
                view.getLstQuests().setSelectedQuestData(this.arrQuests.get(questName));
            } else {
                view.getLstQuests().setSelectedIndex(0);
            }
            qc.load(view.getLstQuests().getSelectedQuest());
        } else {
            qc.load(null);
        }
        view.getLstQuests().setSelectCommand(this.cmdQuestSelect);
        view.getLstQuests().setDeleteCommand(this.cmdQuestUpdate);
        view.getLstQuests().setEditCommand(this.cmdQuestUpdate);
    }

    private void changeQuest() {
        FModel.getQuest().load(VSubmenuQuestLoadData.SINGLETON_INSTANCE.getLstQuests().getSelectedQuest());
        FModel.getQuestPreferences().setPref(QuestPreferences.QPref.CURRENT_QUEST, FModel.getQuest().getName() + ".dat");
        FModel.getQuestPreferences().save();
        CSubmenuDuels.SINGLETON_INSTANCE.update();
        CSubmenuChallenges.SINGLETON_INSTANCE.update();
        CSubmenuQuestDecks.SINGLETON_INSTANCE.update();
        CSubmenuQuestDraft.SINGLETON_INSTANCE.update();
        CBazaarUI.SINGLETON_INSTANCE.update();
    }

    private Map<String, QuestData> getAllQuests() {
        return this.arrQuests;
    }
}

