/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.deck.DeckGroup;
import forge.gamemodes.quest.QuestTournamentController;
import forge.gui.framework.ICDoc;
import forge.screens.home.quest.VSubmenuQuestDraft;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public enum CSubmenuQuestDraft implements ICDoc
{
    SINGLETON_INSTANCE;

    private QuestTournamentController controller;
    private final ActionListener selectTournamentStart = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CSubmenuQuestDraft.this.controller.startDraft();
        }
    };
    private final ActionListener prepareDeckStart = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CSubmenuQuestDraft.this.controller.startTournament();
        }
    };
    private final ActionListener nextMatchStart = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CSubmenuQuestDraft.this.controller.startNextMatch();
        }
    };

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VSubmenuQuestDraft view = VSubmenuQuestDraft.SINGLETON_INSTANCE;
        this.controller = new QuestTournamentController(view);
        view.getBtnStartDraft().addActionListener(this.selectTournamentStart);
        view.getBtnStartTournament().addActionListener(this.prepareDeckStart);
        view.getBtnStartMatch().addActionListener(this.nextMatchStart);
        view.getBtnStartMatchSmall().setCommand(() -> this.controller.startNextMatch());
        view.getBtnSpendToken().setCommand(() -> this.controller.spendToken());
        view.getBtnEditDeck().setCommand(() -> view.editDeck(true));
        view.getBtnLeaveTournament().setCommand(() -> this.controller.endTournamentAndAwardPrizes());
    }

    @Override
    public void update() {
        this.controller.update();
    }

    public void setCompletedDraft(DeckGroup finishedDraft) {
        this.controller.setCompletedDraft(finishedDraft);
    }

    public boolean cancelDraft() {
        return this.controller.cancelDraft();
    }
}

