/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.Singletons;
import forge.deck.DeckProxy;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gui.UiCommand;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.itemmanager.ItemManagerConfig;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorQuest;
import forge.screens.home.quest.VSubmenuQuestDecks;
import forge.util.Localizer;
import javax.swing.SwingUtilities;

public enum CSubmenuQuestDecks implements ICDoc
{
    SINGLETON_INSTANCE;

    private final UiCommand cmdDeckSelect = () -> {
        DeckProxy deck = (DeckProxy)VSubmenuQuestDecks.SINGLETON_INSTANCE.getLstDecks().getSelectedItem();
        if (deck != null) {
            FModel.getQuest().setCurrentDeck(deck.toString());
        } else {
            FModel.getQuest().setCurrentDeck(QuestPreferences.QPref.CURRENT_DECK.getDefault());
        }
        FModel.getQuest().save();
    };
    private final UiCommand cmdDeckDelete = this::update;

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        Localizer localizer = Localizer.getInstance();
        VSubmenuQuestDecks.SINGLETON_INSTANCE.getBtnNewDeck().setCommand(() -> {
            if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblCreateaDeck", new Object[0]))) {
                return;
            }
            Singletons.getControl().setCurrentScreen(FScreen.DECK_EDITOR_QUEST);
            CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorQuest(FModel.getQuest(), CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture()));
        });
    }

    @Override
    public void update() {
        DeckProxy deck;
        VSubmenuQuestDecks view = VSubmenuQuestDecks.SINGLETON_INSTANCE;
        view.getLstDecks().setSelectCommand(null);
        view.getLstDecks().setDeleteCommand(null);
        QuestController qData = FModel.getQuest();
        boolean hasQuest = qData.getAssets() != null;
        view.getLstDecks().setPool(DeckProxy.getAllQuestDecks(hasQuest ? qData.getMyDecks() : null));
        view.getLstDecks().setup(ItemManagerConfig.QUEST_DECKS);
        DeckProxy deckProxy = deck = hasQuest ? (DeckProxy)view.getLstDecks().stringToItem(FModel.getQuest().getCurrentDeck()) : null;
        if (deck != null) {
            view.getLstDecks().setSelectedItem(deck);
        }
        view.getLstDecks().setSelectCommand(this.cmdDeckSelect);
        view.getLstDecks().setDeleteCommand(this.cmdDeckDelete);
        SwingUtilities.invokeLater(() -> view.getBtnNewDeck().requestFocusInWindow());
    }
}

