/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.bazaar.QuestPetController;
import forge.gui.framework.ICDoc;
import forge.model.FModel;
import forge.screens.home.quest.PnlEvent;
import forge.screens.home.quest.VSubmenuDuels;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.JXButtonPanel;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public final class CSubmenuDuels
extends Enum<CSubmenuDuels>
implements ICDoc {
    public static final /* enum */ CSubmenuDuels SINGLETON_INSTANCE = new CSubmenuDuels();
    private final KeyAdapter startOnEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                VSubmenuDuels.SINGLETON_INSTANCE.getBtnStart().doClick();
            }
        }
    };
    private final MouseAdapter mouseClickListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getComponent() instanceof PnlEvent) {
                ((PnlEvent)e.getComponent()).getRad().getModel().setRollover(true);
            } else {
                ((PnlEvent)e.getComponent().getParent()).getRad().getModel().setRollover(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getComponent() instanceof PnlEvent) {
                ((PnlEvent)e.getComponent()).getRad().getModel().setRollover(false);
            } else {
                ((PnlEvent)e.getComponent().getParent()).getRad().getModel().setRollover(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mousePressed(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                VSubmenuDuels.SINGLETON_INSTANCE.getBtnStart().doClick();
            } else if (e.getButton() == 1) {
                if (e.getComponent() instanceof PnlEvent) {
                    ((PnlEvent)e.getComponent()).getRad().setSelected(true);
                } else {
                    ((PnlEvent)e.getComponent().getParent()).getRad().setSelected(true);
                }
            }
        }
    };
    private static final /* synthetic */ CSubmenuDuels[] $VALUES;

    public static CSubmenuDuels[] values() {
        return (CSubmenuDuels[])$VALUES.clone();
    }

    public static CSubmenuDuels valueOf(String name) {
        return Enum.valueOf(CSubmenuDuels.class, name);
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VSubmenuDuels view = VSubmenuDuels.SINGLETON_INSTANCE;
        view.getBtnSpellShop().setCommand(QuestUtil::showSpellShop);
        view.getBtnBazaar().setCommand(QuestUtil::showBazaar);
        view.getBtnTravel().setCommand(() -> {
            QuestUtil.travelWorld();
            this.update();
        });
        view.getBtnUnlock().setCommand(() -> {
            QuestUtil.chooseAndUnlockEdition();
            this.update();
        });
        view.getBtnStart().addActionListener(e -> QuestUtil.startGame());
        QuestController quest = FModel.getQuest();
        view.getCbPlant().addActionListener(arg0 -> {
            quest.selectPet(0, view.getCbPlant().isSelected() ? "Plant" : null);
            quest.save();
        });
        ((FComboBoxWrapper)view.getCbxMatchLength()).addActionListener(arg0 -> {
            String match = (String)((FComboBoxWrapper)view.getCbxMatchLength()).getSelectedItem();
            if (match != null) {
                quest.setMatchLength(match.substring(match.length() - 1));
                quest.save();
            }
        });
        ((FComboBoxWrapper)view.getCbxPet()).addActionListener(arg0 -> {
            boolean slot = true;
            int index = ((FComboBoxWrapper)view.getCbxPet()).getSelectedIndex();
            List<QuestPetController> pets = quest.getPetsStorage().getAvaliablePets(1, quest.getAssets());
            String petName = index <= 0 || index > pets.size() ? null : pets.get(index - 1).getName();
            quest.selectPet(1, petName);
            quest.save();
        });
    }

    @Override
    public void update() {
        QuestUtil.updateQuestView(VSubmenuDuels.SINGLETON_INSTANCE);
        VSubmenuDuels view = VSubmenuDuels.SINGLETON_INSTANCE;
        if (FModel.getQuest().getAchievements() != null) {
            Localizer localizer = Localizer.getInstance();
            view.getLblTitle().setText(localizer.getMessage("lblDuels", new Object[0]) + ": " + FModel.getQuest().getRank());
            view.getPnlDuels().removeAll();
            List<QuestEventDuel> duels = FModel.getQuest().getDuelsManager().generateDuels();
            JXButtonPanel grpPanel = new JXButtonPanel();
            assert (duels != null);
            for (int i = 0; i < duels.size(); ++i) {
                PnlEvent temp = new PnlEvent(duels.get(i));
                JRadioButton rad = temp.getRad();
                if (i == 0) {
                    rad.setSelected(true);
                    SwingUtilities.invokeLater(rad::requestFocusInWindow);
                }
                temp.addKeyListener(this.startOnEnter);
                temp.addMouseListener(this.mouseClickListener);
                grpPanel.add((Component)temp, rad, "w 100%!, h 95px!, gapy 8px");
            }
            view.getPnlDuels().add((Component)grpPanel, "w 100%!");
            StringBuilder sb = new StringBuilder();
            sb.append(localizer.getMessage("lblMatchBestof", new Object[0])).append(" ").append(FModel.getQuest().getMatchLength());
            ((FComboBoxWrapper)view.getCbxMatchLength()).setSelectedItem(sb.toString());
        }
    }

    static {
        $VALUES = new CSubmenuDuels[]{SINGLETON_INSTANCE};
    }
}

