/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.quest;

import forge.Singletons;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestUtil;
import forge.gamemodes.quest.bazaar.QuestItemType;
import forge.gamemodes.quest.bazaar.QuestPetController;
import forge.gui.framework.ICDoc;
import forge.model.FModel;
import forge.screens.home.quest.PnlEvent;
import forge.screens.home.quest.VSubmenuChallenges;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FLabel;
import forge.toolbox.JXButtonPanel;
import forge.util.Localizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public enum CSubmenuChallenges implements ICDoc
{
    SINGLETON_INSTANCE;

    private final KeyAdapter _startOnEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if ('\n' == e.getKeyChar()) {
                VSubmenuChallenges.SINGLETON_INSTANCE.getBtnStart().doClick();
            }
        }
    };
    private final MouseAdapter _startOnDblClick = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (1 == e.getButton() && 2 == e.getClickCount()) {
                VSubmenuChallenges.SINGLETON_INSTANCE.getBtnStart().doClick();
            }
        }
    };

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        VSubmenuChallenges view = VSubmenuChallenges.SINGLETON_INSTANCE;
        view.getBtnSpellShop().setCommand(QuestUtil::showSpellShop);
        view.getBtnBazaar().setCommand(QuestUtil::showBazaar);
        view.getBtnUnlock().setCommand(() -> {
            QuestUtil.chooseAndUnlockEdition();
            this.update();
        });
        view.getBtnTravel().setCommand(() -> {
            QuestUtil.travelWorld();
            this.update();
        });
        view.getBtnStart().addActionListener(e -> QuestUtil.startGame());
        view.getLblZep().setCommand(() -> {
            Localizer localizer = Localizer.getInstance();
            if (!QuestUtil.checkActiveQuest(localizer.getMessage("lblLaunchaZeppelin", new Object[0]))) {
                return;
            }
            FModel.getQuest().getAchievements().setCurrentChallenges(null);
            FModel.getQuest().getAssets().setItemLevel(QuestItemType.ZEPPELIN, 2);
            this.update();
        });
        QuestController quest = FModel.getQuest();
        view.getCbPlant().addActionListener(arg0 -> {
            quest.selectPet(0, view.getCbPlant().isSelected() ? "Plant" : null);
            quest.save();
        });
        ((FComboBoxWrapper)view.getCbxPet()).addActionListener(arg0 -> {
            boolean slot = true;
            int index = ((FComboBoxWrapper)view.getCbxPet()).getSelectedIndex();
            List<QuestPetController> pets = quest.getPetsStorage().getAvaliablePets(1, quest.getAssets());
            String petName = index <= 0 || index > pets.size() ? null : pets.get(index - 1).getName();
            quest.selectPet(1, petName);
            quest.save();
        });
        ((FComboBoxWrapper)view.getCbxMatchLength()).addActionListener(arg0 -> {
            String match = (String)((FComboBoxWrapper)view.getCbxMatchLength()).getSelectedItem();
            if (match != null) {
                quest.setMatchLength(match.substring(match.length() - 1));
                quest.save();
            }
        });
    }

    @Override
    public void update() {
        QuestUtil.updateQuestView(VSubmenuChallenges.SINGLETON_INSTANCE);
        VSubmenuChallenges view = VSubmenuChallenges.SINGLETON_INSTANCE;
        QuestController qCtrl = FModel.getQuest();
        if (qCtrl.getAchievements() == null) {
            return;
        }
        Localizer localizer = Localizer.getInstance();
        view.getLblTitle().setText(localizer.getMessage("lblChallenges", new Object[0]) + ": " + qCtrl.getRank());
        view.getPnlChallenges().removeAll();
        qCtrl.regenerateChallenges();
        ArrayList<QuestEventChallenge> challenges = new ArrayList<QuestEventChallenge>();
        for (String id : qCtrl.getAchievements().getCurrentChallenges()) {
            challenges.add(qCtrl.getChallenges().get(id.toString()));
        }
        JXButtonPanel grpPanel = new JXButtonPanel();
        StringBuilder sb = new StringBuilder();
        sb.append(localizer.getMessage("lblMatchBestof", new Object[0])).append(" ").append(FModel.getQuest().getMatchLength());
        ((FComboBoxWrapper)view.getCbxMatchLength()).setSelectedItem(sb.toString());
        boolean haveAnyChallenges = true;
        for (QuestEventChallenge qc : challenges) {
            PnlEvent temp = new PnlEvent(qc);
            JRadioButton rad = temp.getRad();
            if (haveAnyChallenges) {
                rad.setSelected(true);
                SwingUtilities.invokeLater(rad::requestFocusInWindow);
                haveAnyChallenges = false;
            }
            rad.addKeyListener(this._startOnEnter);
            rad.addMouseListener(this._startOnDblClick);
            grpPanel.add((Component)temp, rad, "w 100%!, h 135px!, gapy 15px");
        }
        view.getPnlChallenges().add((Component)grpPanel, "w 100%!");
        if (!haveAnyChallenges) {
            FLabel lbl = new FLabel.Builder().text(VSubmenuChallenges.SINGLETON_INSTANCE.getLblNextChallengeInWins().getText()).fontAlign(0).build();
            lbl.setForeground(Color.red);
            lbl.setBackground(Color.white);
            lbl.setBorder(new EmptyBorder(10, 10, 10, 10));
            lbl.setOpaque(true);
            view.getPnlChallenges().add((Component)lbl, "w 50%!, h 30px!, gap 25% 0 50px 0");
            SwingUtilities.invokeLater(() -> view.getBtnTravel().requestFocusInWindow());
        }
        Singletons.getView().getFrame().validate();
    }
}

