/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.puzzle;

import forge.gamemodes.match.GameLobby;
import forge.gamemodes.match.LocalLobby;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.StartButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.VLobby;
import forge.screens.home.puzzle.CSubmenuPuzzleSolve;
import forge.toolbox.FList;
import forge.toolbox.FScrollPane;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuPuzzleSolve implements IVSubmenu<CSubmenuPuzzleSolve>
{
    SINGLETON_INSTANCE;

    private final FList puzzleList;
    private final FScrollPane puzzleListPane;
    final DefaultListModel model = new DefaultListModel();
    private final StartButton btnStart = new StartButton();
    private DragCell parentCell;
    final Localizer localizer = Localizer.getInstance();
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblPuzzleModeSolve", new Object[0]));
    private final GameLobby lobby = new LocalLobby();
    private final VLobby vLobby = new VLobby(this.lobby);

    private VSubmenuPuzzleSolve() {
        this.puzzleList = new FList();
        this.puzzleListPane = new FScrollPane(this.puzzleList, true);
        this.lobby.setListener(this.vLobby);
        this.vLobby.setPlayerChangeListener(this.lobby::applyToSlot);
        this.vLobby.update(false);
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.PUZZLE;
    }

    @Override
    public String getMenuTitle() {
        Localizer localizer = Localizer.getInstance();
        return localizer.getMessage("lblSolve", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_PUZZLE_SOLVE;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_PUZZLE_SOLVE;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuPuzzleSolve getLayoutControl() {
        return CSubmenuPuzzleSolve.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    public JList getList() {
        return this.puzzleList;
    }

    public DefaultListModel getModel() {
        return this.model;
    }

    public StartButton getBtnStart() {
        return this.btnStart;
    }

    @Override
    public void populate() {
        VHomeUI.PnlDisplay container = VHomeUI.SINGLETON_INSTANCE.getPnlDisplay();
        container.removeAll();
        container.setLayout(new MigLayout("insets 0, gap 0, wrap 1, ax right"));
        Localizer localizer = Localizer.getInstance();
        this.vLobby.getLblTitle().setText(localizer.getMessage("lblPuzzleModeSolve", new Object[0]));
        container.add((Component)this.vLobby.getLblTitle(), "w 80%, h 40px!, gap 0 0 15px 15px, span 2, al right, pushx");
        this.puzzleList.setModel(this.model);
        container.add((Component)this.puzzleListPane, "w 80%, h 80%, gap 0 0 0px 0px, span 2, al center");
        container.add((Component)this.btnStart, "w 98%!, ax center, gap 1% 0 20px 20px, span 2");
        if (container.isShowing()) {
            container.validate();
            container.repaint();
        }
    }
}

