/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.puzzle;

import forge.deck.Deck;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.puzzle.Puzzle;
import forge.gamemodes.puzzle.PuzzleIO;
import forge.gui.GuiBase;
import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.framework.ICDoc;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.menus.IMenuProvider;
import forge.menus.MenuUtil;
import forge.player.GamePlayerUtil;
import forge.screens.home.puzzle.PuzzleGameMenu;
import forge.screens.home.puzzle.VSubmenuTutorial;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public enum CSubmenuTutorial implements ICDoc,
IMenuProvider
{
    SINGLETON_INSTANCE;

    private VSubmenuTutorial view = VSubmenuTutorial.SINGLETON_INSTANCE;
    private final UiCommand cmdStart = new UiCommand(){
        private static final long serialVersionUID = -367368436333443417L;

        @Override
        public void run() {
            CSubmenuTutorial.this.startPuzzleSolve();
        }
    };

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getList().setSelectionMode(0);
        this.updateData();
        this.view.getBtnStart().addActionListener(e -> this.startPuzzleSolve());
    }

    private void updateData() {
        ArrayList<Puzzle> tutorials = PuzzleIO.loadPuzzles(ForgeConstants.TUTORIAL_DIR);
        Collections.sort(tutorials);
        for (Puzzle p : tutorials) {
            this.view.getModel().addElement(p);
        }
    }

    @Override
    public void update() {
        MenuUtil.setMenuProvider(this);
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        menus.add(PuzzleGameMenu.getMenu());
        return menus;
    }

    private boolean startPuzzleSolve() {
        Puzzle selected = (Puzzle)this.view.getList().getSelectedValue();
        if (selected == null) {
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblPleaseFirstSelectAPuzzleFromList", new Object[0]), Localizer.getInstance().getMessage("lblNoSelectedPuzzle", new Object[0]), FSkinProp.ICO_ERROR);
            return false;
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        hostedMatch.setStartGameHook(() -> {
            SOptionPane.showMessageDialog(selected.getGoalDescription(), selected.getName(), SOptionPane.INFORMATION_ICON);
            selected.applyToGame(hostedMatch.getGame());
        });
        hostedMatch.setEndGameHook(() -> selected.savePuzzleSolve(hostedMatch.getGame().getOutcome().isWinner(GamePlayerUtil.getGuiPlayer())));
        ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(new Deck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        human.setStartingHand(0);
        players.add(human);
        RegisteredPlayer ai = new RegisteredPlayer(new Deck()).setPlayer(GamePlayerUtil.createAiPlayer());
        ai.setStartingHand(0);
        players.add(ai);
        GameRules rules = new GameRules(GameType.Puzzle);
        rules.setGamesPerMatch(1);
        hostedMatch.startMatch(rules, null, players, human, GuiBase.getInterface().getNewGuiGame());
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
        return true;
    }
}

