/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.puzzle;

import com.google.common.collect.Maps;
import forge.deck.Deck;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.puzzle.Puzzle;
import forge.gui.GuiBase;
import forge.gui.SOverlayUtils;
import forge.gui.framework.ICDoc;
import forge.gui.util.SGuiChoose;
import forge.gui.util.SOptionPane;
import forge.menus.IMenuProvider;
import forge.menus.MenuUtil;
import forge.player.GamePlayerUtil;
import forge.screens.home.puzzle.PuzzleGameMenu;
import forge.screens.home.puzzle.VSubmenuPuzzleCreate;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public enum CSubmenuPuzzleCreate implements ICDoc,
IMenuProvider
{
    SINGLETON_INSTANCE;

    private VSubmenuPuzzleCreate view = VSubmenuPuzzleCreate.SINGLETON_INSTANCE;

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getBtnStart().addActionListener(e -> this.startPuzzleCreate());
    }

    @Override
    public void update() {
        MenuUtil.setMenuProvider(this);
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        menus.add(PuzzleGameMenu.getMenu());
        return menus;
    }

    private Map<String, List<String>> generateEmptyPuzzle(String firstPlayer) {
        HashMap<String, List<String>> emptyPuzzle = Maps.newHashMap();
        emptyPuzzle.put("metadata", Arrays.asList("Name:New Puzzle", "URL:http://www.cardforge.org", "Goal:Win", "Turns:999", "Difficulty:Easy", "Description:This is a completely empty puzzle placeholder."));
        emptyPuzzle.put("state", Arrays.asList("ActivePlayer=" + firstPlayer, "ActivePhase=upkeep", "HumanLife=20", "AILife=20"));
        return emptyPuzzle;
    }

    private void startPuzzleCreate() {
        String firstPlayer = SGuiChoose.one(Localizer.getInstance().getMessage("lblWhoShouldBeFirstTakeTurn", new Object[0]), Arrays.asList("Human", "AI"));
        Puzzle emptyPuzzle = new Puzzle(this.generateEmptyPuzzle(firstPlayer));
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
        hostedMatch.setStartGameHook(() -> {
            SOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblWelcomePuzzleModeMessage", new Object[0]), Localizer.getInstance().getMessage("lblCreateNewPuzzle", new Object[0]), SOptionPane.WARNING_ICON);
            emptyPuzzle.applyToGame(hostedMatch.getGame());
        });
        ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(new Deck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        human.setStartingHand(0);
        players.add(human);
        RegisteredPlayer ai = new RegisteredPlayer(new Deck()).setPlayer(GamePlayerUtil.createAiPlayer());
        ai.setStartingHand(0);
        players.add(ai);
        GameRules rules = new GameRules(GameType.Puzzle);
        rules.setGamesPerMatch(1);
        hostedMatch.startMatch(rules, null, players, human, GuiBase.getInterface().getNewGuiGame());
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }
}

