/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.online;

import forge.deckchooser.FDeckChooser;
import forge.gamemodes.match.GameLobby;
import forge.gamemodes.net.IOnlineLobby;
import forge.gamemodes.net.client.FGameClient;
import forge.gamemodes.net.server.FServerManager;
import forge.gui.FNetOverlay;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.IVTopLevelUI;
import forge.gui.interfaces.ILobbyView;
import forge.gui.util.SOptionPane;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.StopButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.VLobby;
import forge.screens.home.online.CSubmenuOnlineLobby;
import forge.toolbox.FButton;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuOnlineLobby implements IVSubmenu<CSubmenuOnlineLobby>,
IOnlineLobby,
IVTopLevelUI
{
    SINGLETON_INSTANCE;

    private DragCell parentCell;
    private final DragTab tab = new DragTab(Localizer.getInstance().getMessage("lblLobby", new Object[0]));
    private VLobby lobby;
    private FGameClient client;
    private final JPanel pnlTitle = new JPanel(new MigLayout());
    private final StopButton btnStop = new StopButton();

    @Override
    public ILobbyView setLobby(GameLobby lobby) {
        this.lobby = new VLobby(lobby);
        this.getLayoutControl().setLobby(this.lobby);
        return this.lobby;
    }

    public void reset() {
        if (this.onClosing(null)) {
            this.client = null;
            this.lobby = null;
            this.populate();
        }
    }

    @Override
    public void setClient(FGameClient client) {
        this.client = client;
    }

    @Override
    public void populate() {
        VHomeUI.PnlDisplay container = VHomeUI.SINGLETON_INSTANCE.getPnlDisplay();
        container.removeAll();
        if (this.lobby == null) {
            FButton btnConnect = new FButton(Localizer.getInstance().getMessage("lblConnectToServer", new Object[0]));
            btnConnect.setFont(FSkin.getRelativeFont(20));
            btnConnect.addActionListener(e -> this.getLayoutControl().connectToServer());
            container.setLayout(new MigLayout("insets 0, gap 0, ax center, ay center"));
            container.add((Component)btnConnect, "w 300!, h 75!");
            if (container.isShowing()) {
                container.validate();
                container.repaint();
            }
            return;
        }
        container.setLayout(new MigLayout("insets 0, gap 0, wrap 1, ax right"));
        this.lobby.getLblTitle().setText(Localizer.getInstance().getMessage("lblOnlineLobbyTitle", new Object[0]));
        this.pnlTitle.removeAll();
        this.pnlTitle.setOpaque(false);
        this.pnlTitle.add((Component)this.lobby.getLblTitle(), "w 95%, h 40px!, gap 0 0 15px 15px, span 2");
        this.pnlTitle.add((Component)this.btnStop, "gap 10 10 0 0, align right");
        container.add((Component)this.pnlTitle, "w 80%, gap 0 0 0 0, al right, pushx");
        this.btnStop.addActionListener(arg0 -> {
            Runnable stopGame = this::reset;
            if (stopGame != null) {
                stopGame.run();
            }
        });
        for (FDeckChooser fdc : this.lobby.getDeckChoosers()) {
            fdc.populate();
            fdc.getDecksComboBox().addListener(ev -> this.lobby.focusOnAvatar());
        }
        container.add((Component)this.lobby.getConstructedFrame(), "gap 20px 20px 20px 0px, push, grow");
        container.add((Component)this.lobby.getPanelStart(), "gap 0 0 3.5%! 3.5%!, ax center");
        if (container.isShowing()) {
            container.validate();
            container.repaint();
        }
        if (!this.lobby.getPlayerPanels().isEmpty()) {
            this.lobby.changePlayerFocus(0);
        }
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.ONLINE;
    }

    @Override
    public String getMenuTitle() {
        return Localizer.getInstance().getMessage("lblLobby", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return this.getDocumentID();
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_NETWORK;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuOnlineLobby getLayoutControl() {
        return CSubmenuOnlineLobby.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }

    @Override
    public void instantiate() {
    }

    @Override
    public boolean onSwitching(FScreen fromScreen, FScreen toScreen) {
        return true;
    }

    @Override
    public boolean onClosing(FScreen screen) {
        FServerManager server = FServerManager.getInstance();
        if (server.isHosting()) {
            if (SOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblLeaveLobbyDescription", new Object[0]), Localizer.getInstance().getMessage("lblLeave", new Object[0]))) {
                server.stopServer();
                FNetOverlay.SINGLETON_INSTANCE.reset();
                return true;
            }
        } else if (this.client == null || SOptionPane.showConfirmDialog(Localizer.getInstance().getMessage("lblLeaveLobbyConfirm", new Object[0]), Localizer.getInstance().getMessage("lblLeave", new Object[0]))) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            FNetOverlay.SINGLETON_INSTANCE.reset();
            return true;
        }
        return false;
    }

    @Override
    public void closeConn(String msg) {
    }
}

