/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.online;

import forge.gamemodes.net.ChatMessage;
import forge.gamemodes.net.NetConnectUtil;
import forge.gui.FNetOverlay;
import forge.gui.FThreads;
import forge.gui.SOverlayUtils;
import forge.gui.error.BugReporter;
import forge.gui.framework.EDocID;
import forge.gui.framework.ICDoc;
import forge.gui.util.SOptionPane;
import forge.menus.IMenuProvider;
import forge.menus.MenuUtil;
import forge.screens.home.CHomeUI;
import forge.screens.home.CLobby;
import forge.screens.home.VLobby;
import forge.screens.home.online.VSubmenuOnlineLobby;
import forge.screens.home.sanctioned.ConstructedGameMenu;
import forge.util.Localizer;
import java.net.BindException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public enum CSubmenuOnlineLobby implements ICDoc,
IMenuProvider
{
    SINGLETON_INSTANCE;

    private CLobby lobby;

    void setLobby(VLobby lobbyView) {
        this.lobby = new CLobby(lobbyView);
        this.initialize();
    }

    void connectToServer() {
        String url = NetConnectUtil.getServerUrl();
        if (url == null) {
            return;
        }
        FThreads.invokeInBackgroundThread(() -> {
            if (url.length() > 0) {
                this.join(url);
            } else {
                try {
                    this.host();
                }
                catch (Exception ex) {
                    if (ex.getClass() == BindException.class) {
                        SOptionPane.showErrorDialog(Localizer.getInstance().getMessage("lblUnableStartServerPortAlreadyUse", new Object[0]));
                        SOverlayUtils.hideOverlay();
                    }
                    BugReporter.reportException(ex);
                }
            }
        });
    }

    private void host() {
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay(Localizer.getInstance().getMessage("lblStartingServer", new Object[0]));
            SOverlayUtils.showOverlay();
        });
        ChatMessage result = NetConnectUtil.host(VSubmenuOnlineLobby.SINGLETON_INSTANCE, FNetOverlay.SINGLETON_INSTANCE);
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.hideOverlay();
            FNetOverlay.SINGLETON_INSTANCE.show(result);
            if (CHomeUI.SINGLETON_INSTANCE.getCurrentDocID() == EDocID.HOME_NETWORK) {
                VSubmenuOnlineLobby.SINGLETON_INSTANCE.populate();
            }
            NetConnectUtil.copyHostedServerUrl();
        });
    }

    private void join(String url) {
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay(Localizer.getInstance().getMessage("lblConnectingToServer", new Object[0]));
            SOverlayUtils.showOverlay();
        });
        ChatMessage result = NetConnectUtil.join(url, VSubmenuOnlineLobby.SINGLETON_INSTANCE, FNetOverlay.SINGLETON_INSTANCE);
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.hideOverlay();
            if (result instanceof ChatMessage) {
                FNetOverlay.SINGLETON_INSTANCE.show(result);
                if (CHomeUI.SINGLETON_INSTANCE.getCurrentDocID() == EDocID.HOME_NETWORK) {
                    VSubmenuOnlineLobby.SINGLETON_INSTANCE.populate();
                }
            }
        });
    }

    @Override
    public void register() {
    }

    @Override
    public void update() {
        MenuUtil.setMenuProvider(this);
        if (this.lobby != null) {
            this.lobby.update();
        }
    }

    @Override
    public void initialize() {
        if (this.lobby != null) {
            this.lobby.initialize();
        }
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        menus.add(ConstructedGameMenu.getMenu());
        return menus;
    }
}

