/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.DeckType;
import forge.deckchooser.FDeckChooser;
import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.model.FModel;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.StartButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.gauntlet.CSubmenuGauntletQuick;
import forge.toolbox.FCheckBox;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuGauntletQuick implements IVSubmenu<CSubmenuGauntletQuick>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblQuickGauntlets", new Object[0]));
    private final FPanel pnlOptions = new FPanel(new MigLayout("insets 0, gap 0, wrap"));
    private final FLabel lblTitle = new FLabel.Builder().text(this.localizer.getMessage("lblQuickGauntletBuilder", new Object[0])).fontAlign(0).opaque(true).fontSize(16).build();
    private final FLabel lblDecklist = new FLabel.Builder().text(this.localizer.getMessage("lblDecklist", new Object[0])).fontSize(12).build();
    private final FSkin.SkinnedSlider sliOpponents = new FSkin.SkinnedSlider(0, 5, 50, 20);
    private final JCheckBox boxUserDecks = new FCheckBox(DeckType.CUSTOM_DECK.toString());
    private final JCheckBox boxPreconDecks = new FCheckBox(DeckType.PRECONSTRUCTED_DECK.toString());
    private final JCheckBox boxQuestDecks = new FCheckBox(DeckType.QUEST_OPPONENT_DECK.toString());
    private final JCheckBox boxColorDecks = new FCheckBox(DeckType.COLOR_DECK.toString());
    private final JCheckBox boxStandardColorDecks = new FCheckBox(DeckType.STANDARD_COLOR_DECK.toString());
    private final JCheckBox boxStandardCardgenDecks = new FCheckBox(DeckType.STANDARD_CARDGEN_DECK.toString());
    private final JCheckBox boxPioneerCardgenDecks = new FCheckBox(DeckType.PIONEER_CARDGEN_DECK.toString());
    private final JCheckBox boxHistoricCardgenDecks = new FCheckBox(DeckType.HISTORIC_CARDGEN_DECK.toString());
    private final JCheckBox boxModernCardgenDecks = new FCheckBox(DeckType.MODERN_CARDGEN_DECK.toString());
    private final JCheckBox boxLegacyCardgenDecks = new FCheckBox(DeckType.LEGACY_CARDGEN_DECK.toString());
    private final JCheckBox boxVintageCardgenDecks = new FCheckBox(DeckType.VINTAGE_CARDGEN_DECK.toString());
    private final JCheckBox boxPauperCardgenDecks = new FCheckBox(DeckType.PAUPER_CARDGEN_DECK.toString());
    private final JCheckBox boxModernColorDecks = new FCheckBox(DeckType.MODERN_COLOR_DECK.toString());
    private final JCheckBox boxPauperColorDecks = new FCheckBox(DeckType.PAUPER_COLOR_DECK.toString());
    private final JCheckBox boxThemeDecks = new FCheckBox(DeckType.THEME_DECK.toString());
    private final FDeckChooser lstDecks = new FDeckChooser(null, false, GameType.Constructed, false);
    private final FLabel lblOptions = new FLabel.Builder().fontSize(16).fontStyle(1).text(this.localizer.getMessage("lblOptions", new Object[0])).fontAlign(0).build();
    private final FLabel lblDesc1 = new FLabel.Builder().text(this.localizer.getMessage("lblMatchesperGauntlet", new Object[0])).fontStyle(2).build();
    private final FLabel lblDesc3 = new FLabel.Builder().text(this.localizer.getMessage("lblAllowedDeckTypes", new Object[0])).fontStyle(2).build();
    private final FLabel lblDesc = new FLabel.Builder().text(this.localizer.getMessage("lblAutosaveInf", new Object[0])).fontSize(12).build();
    private final StartButton btnStart = new StartButton();

    private VSubmenuGauntletQuick() {
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.boxUserDecks.setSelected(true);
        this.boxPreconDecks.setSelected(true);
        this.boxQuestDecks.setSelected(true);
        this.boxThemeDecks.setSelected(true);
        this.boxColorDecks.setSelected(true);
        this.boxStandardColorDecks.setSelected(true);
        if (FModel.isdeckGenMatrixLoaded()) {
            this.boxStandardCardgenDecks.setSelected(true);
            this.boxPioneerCardgenDecks.setSelected(true);
            this.boxModernCardgenDecks.setSelected(true);
            this.boxLegacyCardgenDecks.setSelected(true);
            this.boxVintageCardgenDecks.setSelected(true);
        } else {
            this.boxStandardCardgenDecks.setSelected(false);
            this.boxPioneerCardgenDecks.setSelected(false);
            this.boxModernCardgenDecks.setSelected(false);
            this.boxLegacyCardgenDecks.setSelected(false);
            this.boxVintageCardgenDecks.setSelected(false);
        }
        this.boxModernColorDecks.setSelected(true);
        this.boxPauperColorDecks.setSelected(true);
        this.sliOpponents.setMajorTickSpacing(5);
        this.sliOpponents.setMinorTickSpacing(0);
        this.sliOpponents.setPaintTicks(false);
        this.sliOpponents.setPaintLabels(true);
        this.sliOpponents.setSnapToTicks(true);
        this.sliOpponents.setOpaque(false);
        this.sliOpponents.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.sliOpponents.setFont(FSkin.getFont());
        this.pnlOptions.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.pnlOptions.add((Component)this.lblOptions, "h 30px!, w 96%!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.sliOpponents, "h 40px!, w 96%!, gap 2% 0 0 5px, ax center");
        this.pnlOptions.add((Component)this.lblDesc1, "w 96%!, gap 2% 0 0 20px");
        this.pnlOptions.add((Component)this.lblDesc3, "w 96%!, gap 2% 0 0 0");
        this.pnlOptions.setCornerDiameter(0);
        this.pnlOptions.add((Component)this.boxUserDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxPreconDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxQuestDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxThemeDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxColorDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        if (FModel.isdeckGenMatrixLoaded()) {
            this.pnlOptions.add((Component)this.boxStandardCardgenDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
            this.pnlOptions.add((Component)this.boxPioneerCardgenDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
            this.pnlOptions.add((Component)this.boxModernCardgenDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
            this.pnlOptions.add((Component)this.boxLegacyCardgenDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
            this.pnlOptions.add((Component)this.boxVintageCardgenDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        }
        this.pnlOptions.add((Component)this.boxStandardColorDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxModernColorDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxPauperColorDecks, "w 96%!, h 30px!, gap 2% 0 0 0");
    }

    public void updateDeckPanel() {
        this.lstDecks.restoreSavedState();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.GAUNTLET;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblQuickGauntlet", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_GAUNTLETQUICK;
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, wrap 2"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 98%!, h 30px!, gap 1% 0 15px 15px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblDesc, "ax center, gap 0 0 0 5px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblDecklist, "ax center, gap 0 0 0 15px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlOptions, "w 40%!, gap 1% 1% 0 0, pushy, growy");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lstDecks, "w 57%!, pushy, growy");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnStart, "w 98%!, ax center, gap 1% 0 20px 20px, span 2");
        this.getLstDecks().populate();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    public FDeckChooser getLstDecks() {
        return this.lstDecks;
    }

    public JCheckBox getBoxUserDecks() {
        return this.boxUserDecks;
    }

    public JCheckBox getBoxPreconDecks() {
        return this.boxPreconDecks;
    }

    public JCheckBox getBoxQuestDecks() {
        return this.boxQuestDecks;
    }

    public JCheckBox getBoxColorDecks() {
        return this.boxColorDecks;
    }

    public JCheckBox getBoxStandardColorDecks() {
        return this.boxStandardColorDecks;
    }

    public JCheckBox getBoxModernColorDecks() {
        return this.boxModernColorDecks;
    }

    public JCheckBox getBoxPauperColorDecks() {
        return this.boxPauperColorDecks;
    }

    public JCheckBox getBoxStandardGenDecks() {
        return this.boxStandardCardgenDecks;
    }

    public JCheckBox getBoxModernGenDecks() {
        return this.boxModernCardgenDecks;
    }

    public JCheckBox getBoxPioneerGenDecks() {
        return this.boxPioneerCardgenDecks;
    }

    public JCheckBox getBoxHistoricGenDecks() {
        return this.boxHistoricCardgenDecks;
    }

    public JCheckBox getBoxLegacyGenDecks() {
        return this.boxLegacyCardgenDecks;
    }

    public JCheckBox getBoxVintageGenDecks() {
        return this.boxVintageCardgenDecks;
    }

    public JCheckBox getBoxPauperGenDecks() {
        return this.boxPauperCardgenDecks;
    }

    public JCheckBox getBoxThemeDecks() {
        return this.boxThemeDecks;
    }

    public JSlider getSliOpponents() {
        return this.sliOpponents;
    }

    public JButton getBtnStart() {
        return this.btnStart;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_GAUNTLETQUICK;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuGauntletQuick getLayoutControl() {
        return CSubmenuGauntletQuick.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }
}

