/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.DeckType;
import forge.deckchooser.FDeckChooser;
import forge.game.GameType;
import forge.gui.framework.DragCell;
import forge.gui.framework.DragTab;
import forge.gui.framework.EDocID;
import forge.screens.home.EMenuGroup;
import forge.screens.home.IVSubmenu;
import forge.screens.home.StartButton;
import forge.screens.home.VHomeUI;
import forge.screens.home.gauntlet.CSubmenuGauntletCommander;
import forge.toolbox.FCheckBox;
import forge.toolbox.FLabel;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import net.miginfocom.swing.MigLayout;

public enum VSubmenuGauntletCommander implements IVSubmenu<CSubmenuGauntletCommander>
{
    SINGLETON_INSTANCE;

    final Localizer localizer = Localizer.getInstance();
    private DragCell parentCell;
    private final DragTab tab = new DragTab(this.localizer.getMessage("lblCommanderGauntlet", new Object[0]));
    private final FPanel pnlOptions = new FPanel(new MigLayout("insets 0, gap 0, wrap"));
    private final FLabel lblTitle = new FLabel.Builder().text(this.localizer.getMessage("lblCommanderGauntletBuilder", new Object[0])).fontAlign(0).opaque(true).fontSize(16).build();
    private final FLabel lblDecklist = new FLabel.Builder().text(this.localizer.getMessage("lblDecklist", new Object[0])).fontSize(12).build();
    private final FSkin.SkinnedSlider sliOpponents = new FSkin.SkinnedSlider(0, 5, 50, 20);
    private final JCheckBox boxRandomCommanderDecks = new FCheckBox(DeckType.RANDOM_COMMANDER_DECK.toString());
    private final JCheckBox boxPreconCommanderDecks = new FCheckBox(DeckType.PRECON_COMMANDER_DECK.toString());
    private final JCheckBox boxCommanderDecks = new FCheckBox(DeckType.COMMANDER_DECK.toString());
    private final FDeckChooser lstDecks = new FDeckChooser(null, false, GameType.CommanderGauntlet, true);
    private final FLabel lblOptions = new FLabel.Builder().fontSize(16).fontStyle(1).text(this.localizer.getMessage("lblOptions", new Object[0])).fontAlign(0).build();
    private final FLabel lblDesc1 = new FLabel.Builder().text(this.localizer.getMessage("lblMatchesperGauntlet", new Object[0])).fontStyle(2).build();
    private final FLabel lblDesc3 = new FLabel.Builder().text(this.localizer.getMessage("lblAllowedDeckTypes", new Object[0])).fontStyle(2).build();
    private final FLabel lblDesc = new FLabel.Builder().text(this.localizer.getMessage("lblAutosaveInf", new Object[0])).fontSize(12).build();
    private final StartButton btnStart = new StartButton();

    private VSubmenuGauntletCommander() {
        this.lblTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.boxRandomCommanderDecks.setSelected(true);
        this.boxPreconCommanderDecks.setSelected(true);
        this.boxCommanderDecks.setSelected(true);
        this.sliOpponents.setMajorTickSpacing(5);
        this.sliOpponents.setMinorTickSpacing(0);
        this.sliOpponents.setPaintTicks(false);
        this.sliOpponents.setPaintLabels(true);
        this.sliOpponents.setSnapToTicks(true);
        this.sliOpponents.setOpaque(false);
        this.sliOpponents.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.sliOpponents.setFont(FSkin.getFont());
        this.pnlOptions.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.pnlOptions.add((Component)this.lblOptions, "h 30px!, w 96%!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.sliOpponents, "h 40px!, w 96%!, gap 2% 0 0 5px, ax center");
        this.pnlOptions.add((Component)this.lblDesc1, "w 96%!, gap 2% 0 0 20px");
        this.pnlOptions.add((Component)this.lblDesc3, "w 96%!, gap 2% 0 0 0");
        this.pnlOptions.setCornerDiameter(0);
        this.pnlOptions.add((Component)this.boxRandomCommanderDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxPreconCommanderDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
        this.pnlOptions.add((Component)this.boxCommanderDecks, "w 96%!, h 30px!, gap 2% 0 0 5px");
    }

    public void updateDeckPanel() {
        this.lstDecks.restoreSavedState();
    }

    @Override
    public EMenuGroup getGroupEnum() {
        return EMenuGroup.GAUNTLET;
    }

    @Override
    public String getMenuTitle() {
        return this.localizer.getMessage("lblCommanderGauntlet", new Object[0]);
    }

    @Override
    public EDocID getItemEnum() {
        return EDocID.HOME_GAUNTLETCOMMANDER;
    }

    @Override
    public void populate() {
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().removeAll();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().setLayout(new MigLayout("insets 0, gap 0, wrap 2"));
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblTitle, "w 98%!, h 30px!, gap 1% 0 15px 15px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblDesc, "ax center, gap 0 0 0 5px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lblDecklist, "ax center, gap 0 0 0 15px, span 2");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.pnlOptions, "w 40%!, gap 1% 1% 0 0, pushy, growy");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.lstDecks, "w 57%!, pushy, growy");
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().add((Component)this.btnStart, "w 98%!, ax center, gap 1% 0 20px 20px, span 2");
        this.getLstDecks().populate();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().repaintSelf();
        VHomeUI.SINGLETON_INSTANCE.getPnlDisplay().revalidate();
    }

    public FDeckChooser getLstDecks() {
        return this.lstDecks;
    }

    public JCheckBox getBoxRandomCommanderDecks() {
        return this.boxRandomCommanderDecks;
    }

    public JCheckBox getBoxPreconCommanderDecks() {
        return this.boxPreconCommanderDecks;
    }

    public JCheckBox getBoxCommanderDecks() {
        return this.boxCommanderDecks;
    }

    public JSlider getSliOpponents() {
        return this.sliOpponents;
    }

    public JButton getBtnStart() {
        return this.btnStart;
    }

    @Override
    public EDocID getDocumentID() {
        return EDocID.HOME_GAUNTLETCOMMANDER;
    }

    @Override
    public DragTab getTabLabel() {
        return this.tab;
    }

    @Override
    public CSubmenuGauntletCommander getLayoutControl() {
        return CSubmenuGauntletCommander.SINGLETON_INSTANCE;
    }

    @Override
    public void setParentCell(DragCell cell0) {
        this.parentCell = cell0;
    }

    @Override
    public DragCell getParentCell() {
        return this.parentCell;
    }
}

