/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.UiCommand;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class QuickGauntletLister
extends JPanel {
    private final FSkin.SkinIcon icoDelete;
    private final FSkin.SkinIcon icoDeleteOver;
    private final FSkin.SkinIcon icoEdit;
    private final FSkin.SkinIcon icoEditOver;
    private RowPanel previousSelect;
    private RowPanel[] rows;
    private UiCommand cmdRowSelect;
    private UiCommand cmdRowDelete;
    private UiCommand cmdRowActivate;
    private final Color clrDefault = new Color(0, 0, 0, 0);
    private final FSkin.SkinColor clrHover = FSkin.getColor(FSkin.Colors.CLR_HOVER);
    private final FSkin.SkinColor clrActive = FSkin.getColor(FSkin.Colors.CLR_ACTIVE);
    private final FSkin.SkinColor clrBorders = FSkin.getColor(FSkin.Colors.CLR_BORDERS);
    private List<GauntletData> gauntlets;

    public QuickGauntletLister() {
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.icoDelete = FSkin.getIcon(FSkinProp.ICO_DELETE);
        this.icoDeleteOver = FSkin.getIcon(FSkinProp.ICO_DELETE_OVER);
        this.icoEdit = FSkin.getIcon(FSkinProp.ICO_EDIT);
        this.icoEditOver = FSkin.getIcon(FSkinProp.ICO_EDIT_OVER);
    }

    public void setGauntlets(List<GauntletData> gd0) {
        this.gauntlets = gd0;
        this.refresh();
    }

    public void refresh() {
        this.removeAll();
        ArrayList<RowPanel> tempRows = new ArrayList<RowPanel>();
        ArrayList<GauntletData> sorted = new ArrayList<GauntletData>(this.gauntlets);
        sorted.sort(Comparator.comparing(x -> x.getName().toLowerCase()));
        FSkin.SkinnedPanel rowTitle = new FSkin.SkinnedPanel();
        rowTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        rowTitle.setLayout(new MigLayout("insets 0, gap 0"));
        rowTitle.add((Component)new FLabel.Builder().text("Name").fontAlign(2).build(), "w 49% - 185px!, h 20px!, gap 64px 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Your Deck").fontAlign(2).build(), "w 49% - 185px!, h 20px!, gap 0 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Last Activity").fontAlign(2).build(), "w 140px!, h 20px!, gap 0 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Opponents").fontAlign(4).build(), "w 90px!, h 20px!, gap 0 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Progress").fontAlign(4).build(), "w 90px!, h 20px!, gap 0 0 5px 0");
        this.add((Component)rowTitle, "w 98%!, h 30px!, gapleft 1%");
        for (GauntletData gd : sorted) {
            String name = gd.getName();
            RowPanel row = new RowPanel(gd);
            row.setToolTipText(name);
            row.add((Component)new DeleteButton(row), "w 22px!, h 20px!, gap 5px 0 5px 0");
            row.add((Component)new EditButton(row), "w 22px!, h 20px!, gap 5px 0 5px 0");
            row.add((Component)new FLabel.Builder().fontAlign(2).text(name).build(), "w 49% - 185px!, h 20px!, gap 10px 0 5px 0");
            row.add((Component)new FLabel.Builder().text(gd.getUserDeck() == null ? "(none)" : gd.getUserDeck().getName()).fontAlign(2).build(), "w 49% - 185px!, h 20px!, gap 0 0 5px 0");
            row.add((Component)new FLabel.Builder().text(gd.getTimestamp()).fontAlign(2).build(), "w 140px!, h 20px!, gap 0 0 5px 0");
            row.add((Component)new FLabel.Builder().text(String.valueOf(gd.getDecks().size())).fontAlign(4).build(), "w 90px!, h 20px!, gap 0 0 5px 0");
            row.add((Component)new FLabel.Builder().text(Math.round((double)gd.getCompleted() / (double)gd.getDecks().size() * 100.0) + "%").fontAlign(4).build(), "w 90px!, h 20px!, gap 0 0 5px 0");
            this.add((Component)row, "w 98%!, h 30px!, gap 1% 0 0 0");
            tempRows.add(row);
        }
        this.rows = tempRows.toArray(new RowPanel[0]);
        this.revalidate();
    }

    public File getSelectedGauntletFile() {
        if (this.previousSelect == null) {
            return null;
        }
        return GauntletIO.getGauntletFile(this.previousSelect.getGauntletData());
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.rows.length; ++i) {
            if (!this.rows[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public boolean setSelectedIndex(int i0) {
        if (i0 >= this.rows.length) {
            return false;
        }
        this.selectHandler(this.rows[Math.max(0, i0)]);
        return true;
    }

    public void setCmdSelect(UiCommand c0) {
        this.cmdRowSelect = c0;
    }

    public void setCmdDelete(UiCommand c0) {
        this.cmdRowDelete = c0;
    }

    public void setCmdActivate(UiCommand c0) {
        this.cmdRowActivate = c0;
    }

    private void selectHandler(RowPanel r0) {
        if (this.previousSelect != null) {
            this.previousSelect.setSelected(false);
        }
        r0.setSelected(true);
        this.previousSelect = r0;
        if (this.cmdRowSelect != null) {
            this.cmdRowSelect.run();
        }
    }

    private void renameGauntlet(GauntletData gauntlet) {
        String gauntletName;
        String oldGauntletName = gauntlet.getName();
        while (true) {
            if ((gauntletName = FOptionPane.showInputDialog("Rename gauntlet to:", "Gauntlet Rename", null, oldGauntletName)) == null) {
                return;
            }
            if ((gauntletName = QuestUtil.cleanString(gauntletName)).equals(oldGauntletName)) {
                return;
            }
            if (gauntletName.isEmpty()) {
                FOptionPane.showMessageDialog("Please specify a gauntlet name.");
                continue;
            }
            boolean exists = false;
            for (RowPanel r : this.rows) {
                if (!r.getGauntletData().getName().equalsIgnoreCase(gauntletName)) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            FOptionPane.showMessageDialog("A gauntlet already exists with that name. Please pick another gauntlet name.");
        }
        gauntlet.rename(gauntletName);
        this.refresh();
    }

    private void deleteFile(RowPanel r0) {
        GauntletData gd = r0.getGauntletData();
        if (!FOptionPane.showConfirmDialog("Are you sure you want to delete \"" + gd.getName() + "\"?", "Delete Gauntlet")) {
            return;
        }
        GauntletIO.getGauntletFile(gd).delete();
        if (this.cmdRowDelete != null) {
            this.cmdRowDelete.run();
        }
        this.setSelectedIndex(0);
        this.remove(r0);
        this.repaint();
        this.revalidate();
    }

    private class RowPanel
    extends FSkin.SkinnedPanel {
        private boolean selected = false;
        private boolean hovered = false;
        private final GauntletData gauntletData;

        public RowPanel(GauntletData gd0) {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setLayout(new MigLayout("insets 0, gap 0"));
            this.setBorder(new FSkin.MatteSkinBorder(0, 0, 1, 0, QuickGauntletLister.this.clrBorders));
            this.gauntletData = gd0;
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onMouseEnter(MouseEvent e) {
                    RowPanel.this.hovered = true;
                    if (!RowPanel.this.selected) {
                        RowPanel.this.setBackground(QuickGauntletLister.this.clrHover);
                        RowPanel.this.setOpaque(true);
                    }
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    RowPanel.this.hovered = false;
                    if (!RowPanel.this.selected) {
                        RowPanel.this.setBackground(QuickGauntletLister.this.clrDefault);
                        RowPanel.this.setOpaque(false);
                    }
                }

                @Override
                public void onLeftMouseDown(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        QuickGauntletLister.this.selectHandler(RowPanel.this);
                    } else if (QuickGauntletLister.this.cmdRowActivate != null) {
                        QuickGauntletLister.this.cmdRowActivate.run();
                    }
                }
            });
        }

        public void setSelected(boolean b0) {
            this.selected = b0;
            this.setOpaque(b0);
            if (b0) {
                this.setBackground(QuickGauntletLister.this.clrActive);
            } else if (this.hovered) {
                this.setBackground(QuickGauntletLister.this.clrHover);
            } else {
                this.setBackground(QuickGauntletLister.this.clrDefault);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public GauntletData getGauntletData() {
            return this.gauntletData;
        }
    }

    private class EditButton
    extends FSkin.SkinnedButton {
        public EditButton(final RowPanel r0) {
            this.setRolloverEnabled(true);
            this.setPressedIcon(QuickGauntletLister.this.icoEditOver);
            this.setRolloverIcon(QuickGauntletLister.this.icoEditOver);
            this.setIcon(QuickGauntletLister.this.icoEdit);
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorder((Border)null);
            this.setBorderPainted(false);
            this.setToolTipText("Rename this gauntlet");
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onMouseEnter(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuickGauntletLister.this.clrHover);
                        r0.setOpaque(true);
                    }
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuickGauntletLister.this.clrDefault);
                        r0.setOpaque(false);
                    }
                }

                @Override
                public void onLeftClick(MouseEvent e) {
                    QuickGauntletLister.this.renameGauntlet(r0.getGauntletData());
                }
            });
        }
    }

    private class DeleteButton
    extends FSkin.SkinnedButton {
        public DeleteButton(final RowPanel r0) {
            this.setRolloverEnabled(true);
            this.setPressedIcon(QuickGauntletLister.this.icoDeleteOver);
            this.setRolloverIcon(QuickGauntletLister.this.icoDeleteOver);
            this.setIcon(QuickGauntletLister.this.icoDelete);
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorder((Border)null);
            this.setBorderPainted(false);
            this.setToolTipText("Delete this gauntlet");
            this.addMouseListener(new FMouseAdapter(){

                @Override
                public void onMouseEnter(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuickGauntletLister.this.clrHover);
                        r0.setOpaque(true);
                    }
                }

                @Override
                public void onMouseExit(MouseEvent e) {
                    if (!r0.selected) {
                        r0.setBackground(QuickGauntletLister.this.clrDefault);
                        r0.setOpaque(false);
                    }
                }

                @Override
                public void onLeftClick(MouseEvent e) {
                    QuickGauntletLister.this.deleteFile(r0);
                }
            });
        }
    }
}

