/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.gamemodes.gauntlet.GauntletData;
import forge.gui.UiCommand;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ContestGauntletLister
extends JPanel {
    private RowPanel previousSelect;
    private RowPanel[] rows;
    private UiCommand cmdRowSelect;
    private final Color clrDefault = new Color(0, 0, 0, 0);
    private final FSkin.SkinColor clrHover = FSkin.getColor(FSkin.Colors.CLR_HOVER);
    private final FSkin.SkinColor clrActive = FSkin.getColor(FSkin.Colors.CLR_ACTIVE);
    private final FSkin.SkinColor clrBorders = FSkin.getColor(FSkin.Colors.CLR_BORDERS);

    public ContestGauntletLister() {
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
    }

    public void setGauntlets(List<GauntletData> gd0) {
        this.removeAll();
        ArrayList<RowPanel> tempRows = new ArrayList<RowPanel>();
        ArrayList<GauntletData> sorted = new ArrayList<GauntletData>(gd0);
        sorted.sort(Comparator.comparing(GauntletData::getName));
        FSkin.SkinnedPanel rowTitle = new FSkin.SkinnedPanel();
        rowTitle.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        rowTitle.setLayout(new MigLayout("insets 0, gap 0"));
        rowTitle.add((Component)new FLabel.Builder().build(), "w 30px!, h 20px!, gap 1% 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Name").fontAlign(2).build(), "w 98% - 350px!, h 20px!, gap 20px 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Last Activity").fontAlign(0).build(), "w 100px!, h 20px!, gap 0 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Opponents").fontAlign(0).build(), "w 100px!, h 20px!, gap 0 0 5px 0");
        rowTitle.add((Component)new FLabel.Builder().text("Progress").fontAlign(0).build(), "w 100px!, h 20px!, gap 0 0 5px 0");
        this.add((Component)rowTitle, "w 98%!, h 30px!, gapleft 1%");
        for (GauntletData gd : sorted) {
            String name = gd.getName();
            name = name.substring("LOCKED_".length());
            String progress = Math.round((double)gd.getCompleted() / (double)gd.getDecks().size() * 100.0) + " %";
            if (gd.getUserDeck() == null) {
                progress = "---";
            }
            RowPanel row = new RowPanel(gd);
            row.setToolTipText(name);
            row.add((Component)new FLabel.Builder().fontAlign(2).text(name).build(), "w 98% - 350px!, h 20px!, gap 20px 0 5px 0");
            row.add((Component)new FLabel.Builder().text(gd.getTimestamp()).fontAlign(0).build(), "w 100px!, h 20px!, gap 0 0 5px 0");
            row.add((Component)new FLabel.Builder().text(String.valueOf(gd.getDecks().size())).fontAlign(0).build(), "w 100px!, h 20px!, gap 0 0 5px 0");
            row.add((Component)new FLabel.Builder().text(progress).fontAlign(0).build(), "w 100px!, h 20px!, gap 0 0 5px 0");
            this.add((Component)row, "w 98%!, h 30px!, gap 1% 0 0 0");
            tempRows.add(row);
        }
        this.rows = tempRows.toArray(new RowPanel[0]);
        this.revalidate();
    }

    public GauntletData getSelectedGauntlet() {
        if (this.previousSelect == null) {
            return null;
        }
        return this.previousSelect.getGauntletData();
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.rows.length; ++i) {
            if (!this.rows[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public boolean setSelectedIndex(int i0) {
        if (i0 >= this.rows.length) {
            return false;
        }
        this.selectHandler(this.rows[i0]);
        return true;
    }

    public void setSelectCommand(UiCommand c0) {
        this.cmdRowSelect = c0;
    }

    private void selectHandler(RowPanel r0) {
        if (this.previousSelect != null) {
            this.previousSelect.setSelected(false);
        }
        r0.setSelected(true);
        this.previousSelect = r0;
        if (this.cmdRowSelect != null) {
            this.cmdRowSelect.run();
        }
    }

    private class RowPanel
    extends FSkin.SkinnedPanel {
        private boolean selected = false;
        private final GauntletData gauntletData;

        public RowPanel(GauntletData gd0) {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setLayout(new MigLayout("insets 0, gap 0"));
            this.setBorder(new FSkin.MatteSkinBorder(0, 0, 1, 0, ContestGauntletLister.this.clrBorders));
            this.gauntletData = gd0;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!RowPanel.this.selected) {
                        RowPanel.this.setBackground(ContestGauntletLister.this.clrHover);
                        RowPanel.this.setOpaque(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!RowPanel.this.selected) {
                        RowPanel.this.setBackground(ContestGauntletLister.this.clrDefault);
                        RowPanel.this.setOpaque(false);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    ContestGauntletLister.this.selectHandler(RowPanel.this);
                }
            });
        }

        public void setSelected(boolean b0) {
            this.selected = b0;
            this.setOpaque(b0);
            this.setBackground(b0 ? ContestGauntletLister.this.clrActive : ContestGauntletLister.this.clrHover);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public GauntletData getGauntletData() {
            return this.gauntletData;
        }
    }
}

