/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.DeckType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletUtil;
import forge.gui.SOverlayUtils;
import forge.gui.framework.ICDoc;
import forge.player.GamePlayerUtil;
import forge.screens.home.gauntlet.VSubmenuGauntletQuick;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public enum CSubmenuGauntletQuick implements ICDoc
{
    SINGLETON_INSTANCE;

    private final ActionListener actStartGame = arg0 -> this.startGame();
    private final VSubmenuGauntletQuick view = VSubmenuGauntletQuick.SINGLETON_INSTANCE;

    @Override
    public void update() {
        SwingUtilities.invokeLater(() -> this.view.getBtnStart().requestFocusInWindow());
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getBtnStart().addActionListener(this.actStartGame);
        this.view.getLstDecks().initialize();
    }

    private void startGame() {
        RegisteredPlayer player = this.view.getLstDecks().getPlayer();
        if (player == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        ArrayList<DeckType> allowedDeckTypes = new ArrayList<DeckType>();
        if (this.view.getBoxColorDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.COLOR_DECK);
        }
        if (this.view.getBoxStandardColorDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.STANDARD_COLOR_DECK);
        }
        if (this.view.getBoxStandardGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.STANDARD_CARDGEN_DECK);
        }
        if (this.view.getBoxPioneerGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.PIONEER_CARDGEN_DECK);
        }
        if (this.view.getBoxHistoricGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.HISTORIC_CARDGEN_DECK);
        }
        if (this.view.getBoxModernGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.MODERN_CARDGEN_DECK);
        }
        if (this.view.getBoxLegacyGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.LEGACY_CARDGEN_DECK);
        }
        if (this.view.getBoxVintageGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.VINTAGE_CARDGEN_DECK);
        }
        if (this.view.getBoxPauperGenDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.PAUPER_CARDGEN_DECK);
        }
        if (this.view.getBoxModernColorDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.MODERN_COLOR_DECK);
        }
        if (this.view.getBoxPauperColorDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.PAUPER_COLOR_DECK);
        }
        if (this.view.getBoxThemeDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.THEME_DECK);
        }
        if (this.view.getBoxUserDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.CUSTOM_DECK);
        }
        if (this.view.getBoxQuestDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.QUEST_OPPONENT_DECK);
        }
        if (this.view.getBoxPreconDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.PRECONSTRUCTED_DECK);
        }
        GauntletData gd = GauntletUtil.createQuickGauntlet(player.getDeck(), this.view.getSliOpponents().getValue(), allowedDeckTypes, null);
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = player.setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(new RegisteredPlayer(gd.getDecks().get(gd.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()));
        gd.startRound(starter, human);
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }
}

