/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.Deck;
import forge.deck.DeckType;
import forge.deckchooser.FDeckChooser;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gui.SOverlayUtils;
import forge.gui.framework.ICDoc;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.home.gauntlet.VSubmenuGauntletLoad;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public enum CSubmenuGauntletLoad implements ICDoc
{
    SINGLETON_INSTANCE;

    private final ActionListener actStartGame = arg0 -> this.startGame();
    private final VSubmenuGauntletLoad view = VSubmenuGauntletLoad.SINGLETON_INSTANCE;

    @Override
    public void update() {
        this.updateData();
        this.enableStartButton();
        this.view.getGauntletLister().setSelectedIndex(0);
        SwingUtilities.invokeLater(() -> {
            JButton btnStart = this.view.getBtnStart();
            if (btnStart.isEnabled()) {
                this.view.getBtnStart().requestFocusInWindow();
            }
        });
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getBtnStart().addActionListener(this.actStartGame);
        this.view.getGauntletLister().setCmdDelete(this::enableStartButton);
        this.view.getGauntletLister().setCmdSelect(this::enableStartButton);
        this.view.getGauntletLister().setCmdActivate(this::startGame);
    }

    private void updateData() {
        File[] files = GauntletIO.getGauntletFilesUnlocked(null);
        ArrayList<GauntletData> data = new ArrayList<GauntletData>();
        for (File f : files) {
            GauntletData gd = GauntletIO.loadGauntlet(f);
            if (gd == null) continue;
            data.add(gd);
        }
        this.view.getGauntletLister().setGauntlets(data);
    }

    private void enableStartButton() {
        if (this.view.getGauntletLister().getSelectedGauntletFile() == null) {
            this.view.getBtnStart().setEnabled(false);
        } else {
            this.view.getBtnStart().setEnabled(true);
        }
    }

    private void startGame() {
        GauntletData gd = GauntletIO.loadGauntlet(this.view.getGauntletLister().getSelectedGauntletFile());
        if (gd == null) {
            return;
        }
        FModel.setGauntletData(gd);
        Deck aiDeck = gd.getDecks().get(gd.getCompleted());
        Deck userDeck = gd.getUserDeck();
        if (userDeck == null) {
            userDeck = FDeckChooser.promptForDeck(null, "Select a deck to play for this gauntlet", gd.isCommanderGauntlet() ? DeckType.COMMANDER_DECK : DeckType.CUSTOM_DECK, false);
            if (userDeck == null) {
                return;
            }
            gd.setUserDeck(userDeck);
            GauntletIO.saveGauntlet(gd);
            this.view.getGauntletLister().refresh();
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = gd.isCommanderGauntlet() ? RegisteredPlayer.forCommander(userDeck).setPlayer(GamePlayerUtil.getGuiPlayer()) : new RegisteredPlayer(userDeck).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(gd.isCommanderGauntlet() ? RegisteredPlayer.forCommander(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()) : new RegisteredPlayer(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()));
        gd.startRound(starter, human);
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }
}

