/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.Deck;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gui.SOverlayUtils;
import forge.gui.framework.ICDoc;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.home.gauntlet.VSubmenuGauntletContests;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public enum CSubmenuGauntletContests implements ICDoc
{
    SINGLETON_INSTANCE;

    private final VSubmenuGauntletContests view = VSubmenuGauntletContests.SINGLETON_INSTANCE;
    private final ActionListener actStartGame = arg0 -> this.startGame();

    @Override
    public void update() {
        SwingUtilities.invokeLater(() -> this.view.getBtnStart().requestFocusInWindow());
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getBtnStart().addActionListener(this.actStartGame);
        this.view.getLstDecks().initialize();
        this.updateData();
        this.view.getGauntletLister().setSelectedIndex(0);
    }

    private void updateData() {
        File[] files = GauntletIO.getGauntletFilesLocked();
        ArrayList<GauntletData> data = new ArrayList<GauntletData>();
        if (files != null) {
            for (File f : files) {
                GauntletData gd = GauntletIO.loadGauntlet(f);
                if (gd == null) continue;
                data.add(gd);
            }
        }
        this.view.getGauntletLister().setGauntlets(data);
        this.view.getGauntletLister().setSelectedIndex(0);
    }

    private void startGame() {
        GauntletData gd = this.view.getGauntletLister().getSelectedGauntlet();
        if (gd.getUserDeck() != null) {
            Deck userDeck = gd.getUserDeck();
        } else {
            Deck userDeck = this.view.getLstDecks().getPlayer().getDeck();
            gd.setUserDeck(userDeck);
        }
        gd.stamp();
        FModel.setGauntletData(gd);
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        Deck aiDeck = gd.getDecks().get(gd.getCompleted());
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = new RegisteredPlayer(gd.getUserDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(new RegisteredPlayer(aiDeck).setPlayer(GamePlayerUtil.createAiPlayer()));
        gd.startRound(starter, human);
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }
}

