/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.DeckType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletUtil;
import forge.gui.SOverlayUtils;
import forge.gui.framework.ICDoc;
import forge.player.GamePlayerUtil;
import forge.screens.home.gauntlet.VSubmenuGauntletCommander;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public enum CSubmenuGauntletCommander implements ICDoc
{
    SINGLETON_INSTANCE;

    private final ActionListener actStartGame = arg0 -> this.startGame();
    private final VSubmenuGauntletCommander view = VSubmenuGauntletCommander.SINGLETON_INSTANCE;

    @Override
    public void update() {
        SwingUtilities.invokeLater(() -> this.view.getBtnStart().requestFocusInWindow());
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getBtnStart().addActionListener(this.actStartGame);
        this.view.getLstDecks().initialize(DeckType.COMMANDER_DECK);
    }

    private void startGame() {
        RegisteredPlayer player = this.view.getLstDecks().getPlayer();
        if (player == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            SOverlayUtils.startGameOverlay();
            SOverlayUtils.showOverlay();
        });
        ArrayList<DeckType> allowedDeckTypes = new ArrayList<DeckType>();
        if (this.view.getBoxRandomCommanderDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.RANDOM_COMMANDER_DECK);
        }
        if (this.view.getBoxPreconCommanderDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.PRECON_COMMANDER_DECK);
        }
        if (this.view.getBoxCommanderDecks().isSelected()) {
            allowedDeckTypes.add(DeckType.COMMANDER_DECK);
        }
        GauntletData gd = GauntletUtil.createCommanderGauntlet(player.getDeck(), this.view.getSliOpponents().getValue(), allowedDeckTypes, null);
        ArrayList<RegisteredPlayer> starter = new ArrayList<RegisteredPlayer>();
        RegisteredPlayer human = RegisteredPlayer.forCommander(player.getDeck()).setPlayer(GamePlayerUtil.getGuiPlayer());
        starter.add(human);
        starter.add(RegisteredPlayer.forCommander(gd.getDecks().get(gd.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()));
        gd.startRound(starter, human);
        SwingUtilities.invokeLater(SOverlayUtils::hideOverlay);
    }
}

