/*
 * Decompiled with CFR 0.152.
 */
package forge.screens.home.gauntlet;

import forge.deck.Deck;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletIO;
import forge.gui.UiCommand;
import forge.gui.framework.ICDoc;
import forge.localinstance.properties.ForgeConstants;
import forge.screens.home.gauntlet.VSubmenuGauntletBuild;
import forge.toolbox.FOptionPane;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;

public enum CSubmenuGauntletBuild implements ICDoc
{
    SINGLETON_INSTANCE;

    private final VSubmenuGauntletBuild view = VSubmenuGauntletBuild.SINGLETON_INSTANCE;
    private final List<Deck> workingDecks = new ArrayList<Deck>();
    private final File openStartDir;
    private final FileFilter filterDAT;
    private final UiCommand cmdAddDeck;
    private final UiCommand cmdRemoveDeck;
    private final UiCommand cmdDeckUp;
    private final UiCommand cmdDeckDown;
    private final UiCommand cmdSave;
    private final UiCommand cmdNew;
    private final UiCommand cmdOpen;

    private CSubmenuGauntletBuild() {
        this.openStartDir = new File(ForgeConstants.GAUNTLET_DIR.userPrefLoc);
        this.filterDAT = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName();
                return !filename.startsWith("Quick_") && filename.endsWith(".dat");
            }

            @Override
            public String getDescription() {
                return "Forge data file .dat";
            }
        };
        this.cmdAddDeck = this::addDeck;
        this.cmdRemoveDeck = this::removeDeck;
        this.cmdDeckUp = this::deckUp;
        this.cmdDeckDown = this::deckDown;
        this.cmdSave = this::saveGauntlet;
        this.cmdNew = this::newGauntlet;
        this.cmdOpen = this::openGauntlet;
    }

    @Override
    public void update() {
        SwingUtilities.invokeLater(this.view::focusName);
    }

    @Override
    public void register() {
    }

    @Override
    public void initialize() {
        this.view.getLstRight().setSelectionMode(0);
        this.view.getBtnRight().setCommand(this.cmdAddDeck);
        this.view.getBtnLeft().setCommand(this.cmdRemoveDeck);
        this.view.getBtnUp().setCommand(this.cmdDeckUp);
        this.view.getBtnDown().setCommand(this.cmdDeckDown);
        this.view.getBtnSave().setCommand(this.cmdSave);
        this.view.getBtnOpen().setCommand(this.cmdOpen);
        this.view.getBtnNew().setCommand(this.cmdNew);
        this.view.getLstLeft().initialize();
    }

    private void addDeck() {
        Deck deckToAdd;
        Deck deck = deckToAdd = this.view.getLstLeft().getPlayer() != null ? this.view.getLstLeft().getPlayer().getDeck() : null;
        if (null == deckToAdd) {
            return;
        }
        this.workingDecks.add(deckToAdd);
        this.view.getLblSave().setVisible(false);
        this.dumpDecksIntoList();
    }

    private void removeDeck() {
        int selection = this.view.getLstRight().getSelectedIndex();
        if (selection == -1) {
            return;
        }
        this.workingDecks.remove(selection);
        this.view.getLblSave().setVisible(false);
        this.dumpDecksIntoList();
    }

    private void deckUp() {
        int oldIndex = this.view.getLstRight().getSelectedIndex();
        if (oldIndex <= 0) {
            return;
        }
        Deck movingDeck = this.workingDecks.remove(oldIndex);
        this.workingDecks.add(oldIndex - 1, movingDeck);
        this.view.getLblSave().setVisible(false);
        this.dumpDecksIntoList();
        this.view.getLstRight().setSelectedIndex(oldIndex - 1);
    }

    private void deckDown() {
        int oldIndex = this.view.getLstRight().getSelectedIndex();
        if (oldIndex == this.workingDecks.size() - 1) {
            return;
        }
        Deck movingDeck = this.workingDecks.remove(oldIndex);
        this.workingDecks.add(oldIndex + 1, movingDeck);
        this.view.getLblSave().setVisible(false);
        this.dumpDecksIntoList();
        this.view.getLstRight().setSelectedIndex(oldIndex + 1);
    }

    private void dumpDecksIntoList() {
        ArrayList<String> names = new ArrayList<String>();
        for (Deck d : this.workingDecks) {
            names.add(d.getName());
        }
        this.view.getLstRight().setListData((String[])names.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
    }

    private boolean saveGauntlet() {
        GauntletData gd;
        String name = this.view.getTxfFilename().getText();
        if (name.isEmpty()) {
            FOptionPane.showMessageDialog("Please name your gauntlet using the 'Gauntlet Name' box.", "Save Error!", FOptionPane.ERROR_ICON);
            return false;
        }
        File f = new File(ForgeConstants.GAUNTLET_DIR.userPrefLoc + name + ".dat");
        if (f.exists()) {
            if (!FOptionPane.showConfirmDialog("There is already a gauntlet named '" + name + "'.\nAll progress and data will be overwritten. Continue?", "Overwrite Gauntlet?")) {
                return false;
            }
            gd = GauntletIO.loadGauntlet(f);
            if (gd == null) {
                return false;
            }
        } else {
            if (!FOptionPane.showConfirmDialog("This will create a new gauntlet named '" + name + "'. Continue?", "Create Gauntlet?")) {
                return false;
            }
            gd = new GauntletData();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Deck d : this.workingDecks) {
            names.add(d.getName());
        }
        gd.setEventNames(names);
        gd.setDecks(this.workingDecks);
        gd.setName(name);
        gd.reset();
        this.view.getLblSave().setVisible(false);
        return true;
    }

    private boolean openGauntlet() {
        JFileChooser open = new JFileChooser(this.openStartDir);
        open.setDialogTitle("Import Deck");
        open.addChoosableFileFilter(this.filterDAT);
        int returnVal = open.showOpenDialog(null);
        if (returnVal != 0) {
            return false;
        }
        File file = open.getSelectedFile();
        GauntletData gd = GauntletIO.loadGauntlet(file);
        if (gd == null) {
            return false;
        }
        this.workingDecks.clear();
        this.workingDecks.addAll(gd.getDecks());
        this.view.getTxfFilename().setText(file.getName().substring(0, file.getName().lastIndexOf(46)));
        this.dumpDecksIntoList();
        return true;
    }

    private boolean newGauntlet() {
        this.workingDecks.clear();
        this.dumpDecksIntoList();
        this.view.getTxfFilename().setText("");
        return true;
    }
}

